# kodowanie: ASCII-8BIT
#!/usr/bin/env ruby

require 'metasm'
include Metasm

$SPAWN_GUI = false
CODE_BASE_ADDR = 0x10000000
HTABLE_BASE_ADDR = 0x18000000
DATA_BASE_ADDR = 0x1a000000
INJECT_MAX_ITER = 0x20
NATIVE_REGS = [:eax, :edx, :ecx, :ebx, :esp, :ebp, :esi, :edi]

def display(bd)
    bd.each{|key,value| puts "  #{Expression[key]} => #{Expression[value]}"}
end

# Generuje kod procedury obsugi architektury x86.
sc = Metasm::Shellcode.assemble(Metasm::Ia32.new, <<EOS)
lodsd
mov ecx, eax
xor ecx, ebp
movzx eax, cl
push eax
mov eax, [edi+eax]

movzx edx, ch
mov edx, [edi+edx]
xor eax, edx

pop edx
mov [edi+edx], eax

lodsd
xor ebp, 0x35ef6a14
xor eax, ebp
jmp [#{HTABLE_BASE_ADDR}+eax*4]
EOS

handler = sc.encode_string

# szesnastkowy kod sekcji danych
data_section_hex = "\xA3\xCB\xDB\x5F\x60\xBD\x34\x6A"

# Dodaj sekcj kodu.
dasm = sc.init_disassembler
dasm.add_section(EncodedData.new(handler), CODE_BASE_ADDR)

# Dodaj sekcj danych.
dasm.add_section(EncodedData.new(data_section_hex), DATA_BASE_ADDR)

# Deasembluj kod procedury.
dasm.disassemble_fast_deep(CODE_BASE_ADDR)

if $SPAWN_GUI
    Gui::DasmWindow.new("metasm - symbolic-execution-lvl2", dasm, [CODE_BASE_ADDR])
    dasm.load_plugin('hl_opcode') # hilight jmp/call instrs
    dasm.gui.focus_addr(dasm.gui.curaddr, :graph) # start in graph mode
    Gui.main
end

=begin

Pytanie 1:

Poprzednia prbka kodu bya tylko prbk, niedziaajcym kodem.
Okrel semantyk procedury.

=end

# Okrel semantyk procedury.

puts "\n=== Pytanie 1 ==="

basic_block = dasm.di_at(CODE_BASE_ADDR).block
start_addr = basic_block.list.first.address
end_addr = basic_block.list.last.address

puts "\n[+] okreslanie semantyki procedury od adresu 0x#{start_addr.to_s(16)}, do adresu #{end_addr.to_s(16)}"
binding = dasm.code_binding(start_addr, end_addr)
display(binding)

=begin

Pytanie 2:

Dla pierwszego wywoania maszyny wirtualnej inicjalizowany jest nastpujcy kontekst:
  pushad
  mov edi, esp

Maszyna wirtualna korzysta z kodu o zmiennej wartoci, ktra jest zapisywana w rejestrze ebp.

Odtwrz mapowanie pomidzy kontekstem maszyny wirtualnej, a kodem semantyki.

=end

puts "\n=== Pytanie 2 ==="

vm_symbolism = {
    :eax => :nhandler,
    :ebp => :vmkey,
    :esi => :bytecode_ptr,
    Indirection[[:edi], 4, nil] => :virt_edi,
    Indirection[[:edi, :+, 4], 4, nil] => :virt_esi,
    Indirection[[:edi, :+, 8], 4, nil] => :virt_ebp,
    Indirection[[:edi, :+, 0x10], 4, nil] => :virt_ebx,
    Indirection[[:edi, :+, 0x14], 4, nil] => :virt_edx,
    Indirection[[:edi, :+, 0x18], 4, nil] => :virt_ecx,
    Indirection[[:edi, :+, 0x1c], 4, nil] => :virt_eax,
}

def inject(binding, symbolism)
    return binding if not symbolism or symbolism.empty?
    new_binding = {}
    binding.each{|k, val|
        k = Expression[k].bind(symbolism)
        val = Expression[val].bind(symbolism)
        new_binding[Expression[k].reduce_rec] = Expression[val].reduce_rec
    }
    new_binding
end

puts "\n[+] wiazanie symboliczne"
symbolic_binding = inject(binding, vm_symbolism)
symbolic_binding.reject!{|k,v| NATIVE_REGS.include? k}
display(symbolic_binding)

=begin

Pytanie 3:

Oto kontekst maszyny wirtualnej przed uruchomieniem procedury:
context = {
  :nhandler => 0x84,
  :vmkey => 0x5fdbd7b7,
  virt_ecx => 0,
  virt_edx => 0x41414141,
  virt_ebx => 1,
  :virt_edi => :virt_edi,
  :virt_esi => DATA_BASE_ADDR,
}

Okrel efekt uruchomienia procedury.


Problemy:
  - Jak uzyskuje si dostp do danych programu?

=end

puts "\n=== Pytanie 3 ==="

context = {
    :nhandler => 0x84,
    :vmkey => 0x5fdbd7b7,
    :bytecode_ptr => DATA_BASE_ADDR,
    :virt_eax => 0xffeeffee,
    :virt_ecx => 0,
    :virt_edx => 0x41414141,
    :virt_ebx => 1,
    :virt_edi => :virt_edi,
}

puts "\n[+] oryginalny kontekst"
display(context)
$dasm = dasm

def solve_ind_partial(i, mode = :r)
    case i
    when Indirection
        # nie okrela ostatniej porednioci kluczy (tryb zapisu)
        return i if (mode == :w) and (i.complexity <= 2)

        # okrel cel porednioci
        mem_addr = solve_ind_partial(i.target)

        # sprawd czy adres znajduje si w obszarze danych binarnych 
        if s = $dasm.get_section_at(mem_addr)
          # wcszytaj z pamici
          puts "     [+] okreslono odczyt danych z adresu 0x#{mem_addr.to_s(16)}, rozmiar #{i.len}"
          value = s[0].decode_imm("a#{i.len*8}".to_sym, $dasm.cpu.endianness)
          puts "     [+] wartosc #{Expression[value]}"
          return value
        end

        Indirection[mem_addr, i.len, nil]

    when Expression
        tmp = i.bind(i.expr_indirections.inject({}) {|b, e|
            b.update e => Expression[solve_ind_partial(e)] }).reduce
        (tmp.kind_of? Integer) ? Expression[tmp, :&, 0xffff_ffff].reduce_rec : tmp

    when Integer; Expression[i, :&, 0xffff_ffff].reduce_rec
    when Symbol; i
    else Expression::Unknown; raise i.inspect
    end
end

def sym_exec_v2(context, binding, vm_symbolism)

    # rozwizywanie iteracyjne
    injector = lambda{|v, i, mode|
    next v if (v.kind_of? Symbol) and mode == :w
    next v if v.kind_of? Integer

    oldv = v
    oldoldv = oldv

    iter = 0
    while true
        iter += 1

        # jeeli klucz nie rozwizuje ostatniej operacji adresowania poredniego
        break if (mode == :w) and v.kind_of? Indirection and Expression[v.target].reduce_rec.kind_of? Integer

        v = Expression[v].bind(vm_symbolism).reduce_rec
        break if (v.kind_of? Symbol) and mode == :w

        v = Expression[v].bind(i).reduce_rec
        break if (v.kind_of? Symbol) and mode == :w

        v = Expression[solve_ind_partial(Expression[v], mode)].reduce_rec

        raise "[-] Wykryto nieskonczona petle" if (oldoldv == v and not oldoldv == oldv) or (iter > INJECT_MAX_ITER)
        break if v == oldv
        oldoldv = oldv
        oldv = v
        end
        v
    }

    # rozwi zaawansowane wizanie poprzez podstawienie
    puts "\n[+] wyjasnianie wiazania"
    full_bd = {}
    binding.each{|key, val|
        puts "\n  [+] klucz: #{Expression[key]}"
        full_key = (key.kind_of? Symbol) ? key : injector[key, context.reject{|k,v| k==key}, :w]
        puts "     => okreslono klucz: #{Expression[full_key]}"

        puts "\n  [+] wartosc: #{Expression[val]}"
        full_val = injector[val, context.reject{|k,v| v==val}, :r]
        puts "     => okreslono klucz: #{Expression[full_val]}"

        full_bd[full_key] = full_val
    }

    # filtr wizania(zaleny od architektury maszyny wirtualnej)
    full_bd.reject!{|k,v| not k.kind_of? Symbol}
end

solved_binding =  sym_exec_v2(context, symbolic_binding, vm_symbolism)

puts "\n[+] wyjasnianie wiazania"
display(solved_binding)

updated_context = context.update(solved_binding)

puts "\n[+] uaktualniony kontekst"
display(updated_context)

=begin

Pytanie 4 (dodatkowe):

Jak moemy odtworzy cz pierwotnego kodu?

=end

puts "\n=== Pytanie 4 ==="

# wskazwka: korzystamy tylko z kontekstu symbolicznego:
symbolic_context = {
    :nhandler => 0x84,
    :vmkey => 0x5fdbd7b7,
    :bytecode_ptr => DATA_BASE_ADDR,
    :virt_eax => :virt_eax,
    :virt_ecx => :virt_ecx,
    :virt_edx => :virt_edx,
    :virt_ebx => :virt_ebx,
    :virt_edi => :virt_edi
}

puts "\n[+] okreslono kontekst"
display(symbolic_context)

solved_symolic_binding = sym_exec_v2(symbolic_context, symbolic_binding, vm_symbolism)

puts "\n[+] wyjasnione wiazanie"
display(solved_symolic_binding)

