/**
*   Klasa do dynamicznego tworzenia grafiki wektorowej w formacie SVG
*
*   Opis:
*     Skorzystanie z klasy polega na utworzeniu egzemplarza klasy SVGDraw i wywolywaniu na nim jednej
*     z metod tworzacych nowe elementy, lub modyfikujaycych wlasciwosci utworzonych wczesniej
*     elementow SVG. Klasa wspolpracuje z przegladarkami wspierajacycmi umieszczanie kodu SVG
*     bezposrednio w kodzie HTML (inline SVG)
*
*   Utworzenie nowej instacji klasy:
*     Utworzenie nowej instancji klasy SVGDraw polega na wywolaniu konstruktora z jednym, lub
*     maksymalnie trzema dodatkowymi argumentami. Pierwszy argument (obowiazkowy) to identyfikator,
*     lub referencja do elementu w dokumencie HTML gdzie grafika bedzie rysowana (kontener grafiki).
*     Tworzenie egzemplarza klasy odbywa sie jak ponizej:
*       var inst = new SVGDraw(
*         @identyfikator elementu w dokumencie HTML String |
*         @referencja do elementu w dokumencie HTML Object
*         [, @szerokosc kontenera Int, @wysokosc kontenera Int, @viewBox String, @preserveAspectRatio String]);
*
*
*   Metody:
*     Uwagi ogole:
*       We wszystkich metodach rysujacych (i metodzie inject), jako drugi argument moze zostac
*       przekazana referencja do elementu jaki ma byc rodzicem nowego elementu w drzewie DOM.
*       Brak tego argumentu oznacza iz rodzicem jest element glowny dokumentu SVG.
*
*       W przypadku metod rysujacych, wyglad kazdego nowo tworzonego elementu jest definiowany
*       parametrami przekazanymi jako obiekt w formacie JSON jako pierwszy argument wspomnianych
*       metod. W biezacej wersji parametry oraz ich wartosci nie sa parsowane (walidowane), co
*       oznacza iz wszystkie wlasciwosci CSS dopuszczalne dla danego typu elementu moga zostac
*       przekazane jako parametr. Nazwy niektorych wlasciwosci sa zmienione w stosunku do tych
*       przewidzianych w specyfikacji jezyka. Sa to nastepujace wlasciwosci:
*         left   - odpowiednik wlasciwosci x i wlasciwosci cx (okreg i elipsa)
*         top    - odpowiednik wlasciwosci y i wlasciwosci cy (okreg i elipsa)
*         size   - odpowiednik wlasciwosci font-size elementu tekstowego
*         family - odpowiednik wlasciwosci font-family elementu tekstowego
*         style  - odpowiednik wlasciwosci font-style elementu tekstowego
*         weight - odpowiednik wlasciwosci font-weight elementu tekstowego
* 
* @author Krzysztof Ciesla
* @license GNU
*/
var SVGDraw = (function() {
    /* Returned Class Object */
    var _class = function(cnt, containerWidth, containerHeight, viewBox, preserveAspectRatio) {

        if(document.documentElement.tagName === "svg") {
            var SVG = document.documentElement;
            if(containerWidth)
                SVG.setAttribute("width", containerWidth);
            if(containerHeight)
                SVG.setAttribute("height", containerHeight);
            if(viewBox)
                SVG.setAttribute("viewBox", viewBox);
            if(preserveAspectRatio)
                SVG.setAttribute("preserveAspectRatio", preserveAspectRatio);                
            var bb = (SVG.getBBox())? SVG.getBBox():false;
            this.cntWidth  = (bb.width >0 && bb.width < Infinity)? bb.width : parseInt(SVG.getAttribute("width"))  || 500;
            this.cntHeight = (bb.height >0 && bb.height < Infinity)? bb.height : parseInt(SVG.getAttribute("height")) || 500;
            this.cnt = SVG;
            }
        else{
            this.cntElem = (typeof cnt === "string")? document.getElementById(cnt):cnt;
            if(!this.cntElem){
                return false;
                };
            this.cntWidth  = containerWidth  || this.cntElem.clientWidth;
            this.cntHeight = containerHeight || this.cntElem.clientHeight;
            this.cnt = createContainer.call(this, this.cntElem, this.cntWidth, this.cntHeight);
            if(viewBox)
                this.cnt.setAttribute("viewBox", viewBox);
            if(preserveAspectRatio)
                SVG.setAttribute("preserveAspectRatio", preserveAspectRatio);                 
            };
        this.defs = createDefs(this.cnt);
        this.SVGCode = "";
        this.lockElem = [this.defs];
        /*this.freeDraw = false;
        this.freeDrawPropObj = {};*/
        },// End _class
        svgNS   = "http://www.w3.org/2000/svg",
        xlinkNS = "http://www.w3.org/1999/xlink",
        svgVersion = "1.1",
        svgProfile = "full",
        //showErrors = 0,
        //clearProp  = 0,
        doc = document,
        defaultProp = {},
        hideDefaultProp = false,
        checkName = function(n) {
            return elementsName[n]||n;
            },
        prepareMethods = function() {
            for(var i in methods["svg"]) {
                _class.prototype[i] = methods["svg"][i];
                };
            },
        Fns = {"g":{
                "left": function(attrObj) {
                    attrObj.transform = (attrObj.transform||"")+" translate("+(attrObj.left||0)+","+(attrObj.top||0)+")";
                    delete attrObj.top;
                    delete attrObj.left;
                    return;
                    },
                "top" : this.left
                },
            "text": {
                "left": function(attrObj, addBeforeFn) {
                    addBeforeFn(this,
                        (function(top) {return function() {
                            this.setAttribute("y", parseInt(top, 10) + this.getBBox().height);
                            }})(attrObj.top||0));
                    delete attrObj.top;
                    return;
                    },
                "top" : this.left
                }
            },
        attrObj = {
            "":"id:id|class:class",
            "rect|circle|ellipse|text|line|polyline|polygone|path|use":"strokeLinecap:stroke-linecap|strokeLinejoin:stroke-linejoin|zIndex:z-index|fill:fill|fillOpacity:fill-opacity|stroke:stroke|strokeWidth:stroke-width|strokeOpacity:stroke-opacity|opacity:opacity|transform:transform",
            "image" :"",
            "g":"display",
            "use":"left:x|top:y",
            "rect"  :"left:x|top:y|width:width|height:height|radiusX:rx|radiusY:ry",
            "text"  :"size:font-size|family:font-family|style:font-style|weight:font-weight|rotate:rotate|left:x|top:y",
            "line"  :"x1:x1|x2:x2|y1:y1|y2:y2",
            "polyline|polygone":"data:points",
            "path":"data:d",
            "circle":"left:cx|top:cy|radius:r",
            "ellipse":"left:cx|top:cy|radiusX:rx|radiusY:ry",
            "linearGradient":"units:gradientUnits|x1:x1|x2:x2|y1:y1|y2:y2",
            "radialGradient":"units:gradientUnits|left:cx|top:cy|r:r",
            "stop":"offset:offset|color:stop-color|opacity:stop-opacity"
            },
        elementsName = "origin:use|image:image|rectangle:rect|circle:circle|oval:ellipse|line:line|polyline:polyline|polygone:polygone|path:path|layer:g",
        validateAttr = function(elemName, propObj) {
            var attrs = attrObj[elemName]||{}, tmpObj = {};
            map(propObj, function(obj, i) {
                if(attrs[i])
                    tmpObj[attrs[i]] = this;
                else
                    tmpObj[i] = this;
                });
            return tmpObj;
            },
        /*
        unCamelCase = function(s) {
            if(/-\+/.test(s)) return;
            var len = s.length, c, _c="";
            for(var i=0;i<len;i++) {
                c = s[i];
                _c += (/[A-Z]/.test(c))? ("-"+c.toLowerCase()):c;
                };
            return _c;
            },
        camelCase = function(s) {
            return map(s.split("-"), function(obj,i) {
                return (i>0)? (this.substr(0,1).toUpperCase()+this.substr(1)):this;
                }).join("");
            },
        */
        getUniqueID = (function() {
            var id = 0;
            return function() {
                return id++;
                };
            })(),
        createContainer = function(cntElem, cntWidth, cntHeight) {
            return appendElement(cntElem, "svg", {
                "xmlns"         : svgNS,
                "xmlns:xlink"   : "http://www.w3.org/1999/xlink",
                "width"         : cntWidth,
                "height"        : cntHeight,
                "version"       : svgVersion,
                "baseProfile"   : svgProfile
                });
            },
        createDefs = function(cnt) {
            return appendElement(cnt, "defs", {});
            },
        /*
        showError = function(er) {
            if(showErrors)
                alert(er);
            },
        */
        consolidateTransforms = function(obj, SVG) {
            var len = obj.transform.baseVal.numberOfItems, bv = obj.transform.baseVal;
            if(!len) {
                bv.appendItem(SVG.createSVGTransform());
                return;
                };
            if(len === 1)
                return;
            bv.initialize(bv.consolidate());          
            return;
            },
        map = function(ar, fn) {
            var resultAr = [], result, j=0;
            for(var i in ar) {
                if(isUndef(ar[i])) continue;
                result = fn.call(ar[i], ar, i);
                if(!result) continue;
                resultAr[j++] = result;
                };
            return resultAr;
            },
        ar2obj = function(ar,fill) {
            var obj = {};
            map(ar, function() {
                obj[this[0]||this] = this[1]||fill||"";
                });
            return obj;
            },
        objectsConcat = function() {
            var objTMP={};
            map(arguments, function() {
                map(this, function(obj, i) {
                    objTMP[i] = /*(!isUndef(objTMP[i]))||*/this;
                    });
                });
            return objTMP;
            },
        /*
        prepareElementProperty = function(propObj, attrObj) {
            var value, obj = {};
            for(var i in propObj) {
                value = parseValue(propObj[i]);
                if(value === false) {
                    showError("Blad parsowania wartosci "+propObj[i]);
                    continue;
                    };
                if(isUndef(attrObj[i])) {
                    showError("Atrybut "+i+" elementu nie istnieje");
                    if(clearProp) continue;
                    obj[i] = propObj[i];
                    continue;
                    };
                obj[attrObj[i]] = propObj[i];
                };
            delete propObj;
            return obj;
            },
        */
        sa = function(elem, n, v, ns) {(ns)? elem.setAttributeNS(ns,n,v):elem.setAttribute(n,v)},
        setAttr = function(elem, elemName, attrObj) {
             var v, obj = validateAttr(elemName, objectsConcat((hideDefaultProp)? {}:defaultProp[elemName], attrObj));
             
             for(var i in obj) {
                v = obj[i];
                if(i === "xlink:href") {
                    sa(elem, "xlink:href",v, xlinkNS);
                    continue;
                    };
                if(v.id) {
                    sa(elem, i, "url(#"+v.id+")");
                    continue;
                    };
                if(v <= 0 && i === "stroke-width") {
                    sa(elem, "stroke","none");
                    sa(elem, "stroke-width",0);
                    delete obj.stroke;
                    continue;
                    };
                sa(elem, i,v);
                };
             return elem;
            },
        appendElement = (function() {

             var elems = {}, beforeFnAr = [],
                addBeforeFn = function(elem, Fn) {
                    beforeFnAr[beforeFnAr.length] = [elem, Fn];
                    },
                executeFns = function() {
                    map(beforeFnAr, function() {
                        var elem = this.shift();
                        map(this, function() {
                            try{this.call(elem)}
                            catch(er){};
                            });
                        });
                    beforeFnAr = [];
                    },
                prepareAttrValue = function(attrObj, elem, elemName) {  
                    map(attrObj, function(obj, i) {
                        try{Fns[elemName][i].call(elem, obj, addBeforeFn/* Element, attributes, beforeInjectFn */)}
                        catch(er) {};
                        });
                    };

             return function(/*cnt, elemName, propObj*/) {
                var args = arguments, fragment, f, refObj = {}, cnt = args[0]||this.cnt;
                if(typeof args[1] != "object") {
                    var elemName = checkName(args[1]);
                    return cnt.appendChild(setAttr(doc.createElementNS(svgNS, elemName), elemName, args[2]));
                    }
                else{
                    fragment = doc.createDocumentFragment();
                    f = function() {
                        var args = arguments, len = args[1].length, elem, elemName, ob;
                        for(var i=0; i<len; i++) {
                            ob = args[1][i];
                            elemName = checkName(ob.elem);
                            elem = doc.createElementNS(svgNS, elemName);
                            /* Prepare inside tree */
                            if(ob.code) {
                                f(elem, ob.code);
                                };
                            /* Set text value to element */
                            if(ob.txt)
                                elem.textContent = ob.txt;
                            /* Create references to elements */
                            if(ob.ref)
                                refObj[ob.ref] = elem;
                            /* Prepare attributes value
                            /* left & top layer -> transform
                            /* left & top text element to x & y attribute
                            /*/
                            prepareAttrValue(ob.attrs, elem, elemName);
                            /* Execute functions before inject code */
                            if(ob.beforeInject)
                                addBeforeFn(elem, ob.beforeInject);
                            /* Set attributes to element */
                            args[0].appendChild(setAttr(elem, elemName, ob.attrs));
                            };
                        };

                    f(fragment, args[1]);
                    cnt.appendChild(fragment);
                    executeFns();
                    };
             /*
             if(!elems[elemName]) {
                elems[elemName] = doc.createElementNS(svgNS, elemName);
                };
             elem = elems[elemName].cloneNode(false);
             */
            return refObj;
            }})(),
        inject = function(v, cnt) {
            if(typeof v === "string") {
                var nodes = new DOMParser().parseFromString("<svg xmlns='"+svgNS+"'>"+v+"</svg>", "image/svg+xml").documentElement.childNodes, len = nodes.length;
                for(var i=0; i<len; i++) {
                    (cnt||this.cnt).appendChild(doc.importNode(nodes[i], true))
                    };
                return;
                }
            else{
                return appendElement.call(this, cnt, v);
                };
            },
        clone =  function(obj) {
            var inst = function(o1,o2) {return o1 instanceof o2};
            if(!inst(obj,Object))
                return obj;
            if(!isUndef(obj.nodeType))
                return obj.cloneNode(true);
            var tmpObj  = (inst(obj,Array))? []:{}, undef;
            for(var i in obj) {
                if(inst(obj[i],Object) && (obj[i] != window && obj[i] != document && obj[i].nodeType === undef)) {
                    tmpObj[i] = clone(obj[i]);
                    continue;
                    };
                tmpObj[i] = obj[i];
                };
            return tmpObj;
            },
        isUndef = (function(obj) {
            return function(v) {return (v === obj)? true : false}
            })(),
        getPreviousElem = function(elem) {
            var el = elem, prev = null;
            while(1) {
                prev = el.previousSibling;
                if(!prev)
                    return null;
                if(prev.nodeType === 1)
                    return prev;
                el = prev;
                };
            },
        getNextElem = function(elem) {
            var el = elem, nxt = null;
            while(1) {
                nxt = el.nextSibling;
                if(!nxt)
                    return null;
                if(nxt.nodeType === 1)
                    return nxt;
                el = nxt;
                };
            },
        dot = function(v) {return ((v+"").indexOf("%")>=0)? parseInt(v)/100:v},
        args2arr = function() {return Array.prototype.slice.call(arguments[0]||[],0)},
        methods = {
            "svg":{
                "property": function() {
                    var args = arguments, propObj, len = args.length, elemName = (args[0]||{}).tagName;
                    if(len <= 1 || !elemName)
                        return;
                    if(args.length === 2) {// Set property from string
                        if(typeof args[1] === "string") {
                            return args[0].getAttribute((attrObj[elemName]||{})[args[1]]||args[1])||"";
                            };
                        }
                    else{// Get property
                        var obj = {};
                        obj[args[1]] = args[2];

                        hideDefaultProp = true;
                        setAttr(args[0], elemName, obj);
                        hideDefaultProp = false;

                        return;
                        };

                    map(validateAttr(elemName, args[1]), function(obj, i){// Set property from object
                        args[0].setAttribute(i, this);
                        });
                    return;
                    },
                "txtValue": function(elem, s) {
                    return (s)? (elem.textContent = s):elem.textContent;
                    },
                "inject": function(code, cnt /* @Object|@String?, @Container? */) {
                    return inject.call(this, code, cnt);
                    },
                "deleteDefaultProp": function(elemName) {
                    var dProp = defaultProp, args=arguments, len = args.length, s = map((args[0]||"").split("|"), function() {return checkName(this)});
                    map(s, function() {
                        delete dProp[this];
                        });
                    return;
                    },
                "setDefaultProp": function() {
                    var dProp = defaultProp, args=arguments, len = args.length, s = map((args[0]||"").split("|"), function() {return checkName(this)}), obj={};
                    if(len>2)
                        obj[args[1]]=args[2];
                    else
                        obj=args[1];
                    map(s, function() {
                        dProp[this] = objectsConcat(dProp[this], obj);
                        });
                    return;
                    },
                "drawImage": function(propObj, cnt) {
                    propObj = propObj||{};
                    propObj["preserveAspectRatio"] = propObj["preserveAspectRatio"]||"none";
                    return appendElement.call(this, cnt, "image", propObj);
                    },
                "drawRectangle":function(propObj, cnt) {
                    return appendElement.call(this, cnt, "rect", propObj);
                    },
                "drawText": function(value, propObj, cnt) {
                    return (function(elem) {
                        elem.textContent = value||"";
                        return elem;
                        })(appendElement.call(this, cnt, "text", propObj));
                    },
                "drawOval": function(propObj, cnt) {
                    return appendElement.call(this, cnt, "ellipse", propObj);
                    },
                "drawCircle": function(propObj, cnt) {
                    return appendElement.call(this, cnt, "circle", propObj);
                    },
                "drawLine": function(propObj, cnt) {
                    return appendElement.call(this, cnt, "line", propObj);
                    },
                "drawPolyline": function(propObj, cnt) {
                    propObj["points"] = (function() {
                        var str = "", len = propObj["points"].length;
                        for(var i=0; i<len; i+=2) {
                            str += propObj["points"][i] + " " + propObj["points"][i+1] + ",";
                            };
                        return str.substr(0, str.length-1);
                        })();
                    return appendElement.call(this, cnt, "polyline", propObj);
                    },
                "drawPolygon":function(propObj, cnt) {
                    propObj["points"] = (function() {
                        var str = "", len = propObj["points"].length;
                        for(var i=0; i<len; i+=2) {
                            str += propObj["points"][i] + " " + propObj["points"][i+1] + ",";
                            };
                        return str.substr(0, str.length-1);
                        })();
                    return appendElement.call(this, cnt, "polygon", propObj);
                    },
                "drawPath": function(propObj, cnt) {
                    return appendElement.call(this, cnt, "path", propObj);
                    },
                "pointPos": function(elem, mode) {
                    /* No transformations */
                    try{
                        var bb = elem.getBBox()||{};
                        }
                    catch(err) {
                        throw Error(err.message);
                        };
                    var pos = (mode==="center"? "center-middle":mode||"").split("-"),
                        x=0, y=0;
                    switch(pos[0]) {
                        case "center": {x = bb.x + bb.width/2;break}
                        case "right" : {x = bb.x + bb.width;break}
                        default      : {x = bb.x;break}//left
                        };
                    switch(pos[1]) {
                        case "middle" : {y = bb.y + bb.height/2;break}
                        case "bottom" : {y = bb.y + bb.height;break}
                        default       : {y = bb.y;break}//top
                        };
                    return {left:x,top:y};
                    },
                "align": function(elem1, elem2, mode, marginX, marginY) {
                    
                    consolidateTransforms(elem1, this.cnt);
                    var m = elem1.transform.baseVal.getItem(0).matrix;
                    m.e = m.f = 0;
                    
                    var getPos = function(elem) {
                        var bb = elem.getBBox(), screenCTM = elem.getScreenCTM();
                        return {
                            x     : bb.x + screenCTM.e,
                            y     : bb.y + screenCTM.f,
                            width : bb.width,
                            height: bb.height
                            };
                        },
                        posMode = (mode==="center"? "center-middle":(mode+"")||"").split("-"),
                        pos1 = getPos(elem1), pos2 = getPos(elem2), tx, ty;

                    switch(posMode[0]) {
                        case "center": {tx = (pos2.x + pos2.width/2) - (pos1.x + pos1.width/2); break}
                        case "right" : {tx = pos2.x + (pos2.width - pos1.width); break}
                        default: {tx = pos2.x - pos1.x; break}
                        };
                    switch(posMode[1]) {
                        case "middle" : {ty = (pos2.y + pos2.height/2) - (pos1.y + pos1.height/2); break}
                        case "bottom" : {ty = pos2.y + (pos2.height - pos1.height); break}
                        default: {ty = pos2.y - pos1.y; break};
                        };                          
                    m.e = tx + (marginX||0);
                    m.f = ty + (marginY||0);
                    return;
                    },
                "setBlur": function(elem, v) {
			return (function(cnt) {
                        appendElement(cnt, "feGaussianBlur", {"stdDeviation":v||3});
                        elem.setAttribute("filter","url(#"+cnt.id+")");
                        return cnt;
			})(appendElement.call(this, this.defs, "filter", {"id":"filter"+getUniqueID()}));
                    },
                "setTransform": function(elem, propObj) {
                    var trObj = {
                        "translate": function() {
                            return "translate("+(propObj.tx||0)+","+(propObj.ty||0)+")";
                            },
                        "rotate": function() {
                            var cx=propObj.cx||0, cy=propObj.cy||0, pos;
                            if(propObj.rotateCenter) {
                                pos = _this_.pointPos(elem, propObj.rotateCenter);
                                cx = pos.left;
                                cy = pos.top;
                                };
                            return "rotate("+(propObj.angle||0)+","+cx+","+cy+")";
                            },
                        "scale": function() {
                            var sx=propObj.sx||1, sy=(typeof propObj.sy === "string")? 1:(propObj.sy||1), pos, trans1=trans2="";
                            if(propObj.scaleCenter) {
                                pos = _this_.pointPos(elem, propObj.scaleCenter);
                                trans1 = "translate("+pos.left+","+pos.top+") ";
                                trans2 = " translate("+(-pos.left)+","+(-pos.top)+")";
                                };
                            return trans1+"scale("+sx+","+sy+")"+trans2;
                            },
                        "":function(){return ""}
                        }, _this_ = this;
                    (function(tr) {
                        elem.setAttribute("transform", tr+" "+(trObj[propObj.transformName||""]()));
                        })(elem.getAttribute("transform")||"");
                    return elem;
                    },
                "translate": function(elem, tx, ty) {
                    return this.setTransform(elem, {transformName:"translate",tx:tx,ty:ty});
                    },
                "rotate": function(elem, angle, cx, cy) {
                    return this.setTransform(elem, {
                        "transformName":"rotate",
                        "angle":angle,
                        "rotateCenter":(typeof cx === "string")? cx:"",
                        "cx":cx,
                        "cy":cy
                        });
                    },
                "scale": function(elem, sx, sy, scaleCenter) {
                    return this.setTransform(elem, {
                        "transformName":"scale",
                        "scaleCenter":scaleCenter,
                        "sx":sx,
                        "sy":sy
                        });
                    },
                "addLayer": function(cnt, propObj) {
                    propObj = propObj||{};
                    propObj.id = "layer"+getUniqueID();
                    return appendElement.call(this, cnt, "g", propObj);
                    },
                "raiseOnTop": function(elem) {
                    if(elem.parentNode.lastChild === elem)
                        return elem;
                    return elem.parentNode.appendChild(elem);
                    },
                "raiseOneStep": function(elem) {
                    return (function(nxt) {
                        if(!nxt)
                            return elem;
                        if(nxt.nextSibling) {
                            return elem.parentNode.insertBefore(elem, nxt.nextSibling);
                            }
                        return elem.parentNode.appendChild(elem);
                        })(getNextElem(elem));
                    },
                "lowerToBottom": function(elem) {
                    return elem.parentNode.insertBefore(elem, elem.parentNode.firstChild);
                    },
                "lowerOneStep": function(elem) {
                    return (function(prev, _this_) {
                        if(!prev) return elem;
                        return elem.parentNode.insertBefore(elem, prev);
                        })(getPreviousElem(elem), this);
                    },
                "createLinearGradient": function(propObj) {
                    var colors = [
                        {"offset":"0%","color":"white"},
                        {"offset":"100%","color":"black"}
                        ], elem;
                    propObj=propObj||{};
                    colors = propObj.colors||colors;
                    propObj.id = propObj.id||"linear"+getUniqueID();
                    delete propObj.colors;
                    elem = appendElement(this.defs, "linearGradient", propObj);
                    map(colors, function() {appendElement(elem, "stop", this)});
                    return elem;
                    },
                "linearGradient": function(/* mode@String?, colors@Array? */) {
                    var args = arguments||[], mode = (typeof args[0] === "string")? args[0]:"",
                        obj, colors = (args[1])? args[1]:((typeof args[0] != "string")? args[0]:[]), len = colors.length;
                    switch(mode) {
                        case "right": {obj={x1:"100%",y1:"0%",x2:"0%",y2:"0%"};break}
                        case "up"   : {obj={x1:"0%",y1:"100%",x2:"0%",y2:"0%"};break}
                        case "down" : {obj={x1:"0%",y1:"0%",x2:"0%",y2:"100%"};break}
                        default     : {obj={x1:"0%",y1:"0%",x2:"100%",y2:"0%"};break}
                        };
                    if(len) {
                        var of = 100/len;
                        obj.colors=[];
                        for(var i=0; i<len; i++) {
                            obj.colors.push({
                                "color":colors[i],"offset":((i+1)*of)+"%"
                                });
                            };
                        };
                    return this.createLinearGradient(obj);
                    },
                "createRadialGradient": function(propObj) {
                    var colors = [
                            {"offset":"0%","color":"white"},
                            {"offset":"100%","color":"black"}
                            ], rx, ry, sx, sy, elem;
                    propObj = propObj||{};
                    rx = dot(propObj.radiusX||0.5);
                    ry = dot(propObj.radiusY||rx);
                    propObj.left = dot(propObj.left||0.5);
                    propObj.top  = dot(propObj.top||0.5);
                    colors = propObj.colors||colors;
                    propObj.r = 0.5;
                    propObj.id = propObj.id||"radial"+getUniqueID();
                    /* Only objectBoundingBox units */
                    propObj.units = "objectBoundingBox";

                    delete propObj.radiusX;
                    delete propObj.radiusY;
                    delete propObj.colors;

                    elem = appendElement(this.defs, "radialGradient", propObj);
                    map(colors, function() {appendElement(elem, "stop", this)});

                    sx = rx;
                    sy = ry;
                    elem.setAttribute("gradientTransform", "scale("+sx+","+sy+") translate("+(-(propObj.left/sx*(sx-1)))+","+(-(propObj.top/sy*(sy-1)))+")");
                    return elem;
                    },
                "radialGradient": function() {

                    },
		"addClipPath": function(elem) {
                    return (function(cnt) {
                        cnt.appendChild(elem);
                        return cnt;
			})(appendElement(this.defs, "clipPath", {"id":"clippath"+getUniqueID()}));
		    },
		"clip": function(elem, clipPath) {
		    sa(elem, "clip-path", "url(#"+clipPath.id+")");
                    return;
                    },
                "addElement": function(elemName, cnt, attrObj, txtValue) {
                    var elem = appendElement.call(this, cnt, elemName, attrObj||{});
                    if(txtValue) {
                        elem.textContent = txtValue;
                        };
                    return elem;
                    },
                /* Lock elements to destroy */
                "lockElement": function() {
                    return this.lockElem = this.lockElem.concat(args2arr(arguments));
                    },
                /* Unlock elements to destroy */
                "unlockElement": function() {
                    var argsAr = args2arr(arguments), defs = this.defs;
                    this.lockElem = map(this.lockElem, function() {
                        if(argsAr.indexOf(this)>=0 && this != defs) return false;
                        return this;
                        });                                          //console.log(this.lockElem);
                    return;
                    },
                "destroy": function(/*nodes array*/) {
                    var lockElem = this.lockElem;
                    map(arguments, function(args, i) {
                        if(lockElem.indexOf(this)>=0) return;
                        try{
                            this.parentNode.removeChild(this);
                            delete args[i];
                            } catch(er) {return};
                        });
                    return;
                    },
                "clear": function() {
                    try{
                        var elems, len, child, lockElem = this.lockElem, args = (arguments.length)? arguments:[this.cnt];
                        map(args, function() {
                            elems = this.childNodes;
                            len = elems.length;
                            while(len--) {
                                child = elems[len];
                                if(lockElem.indexOf(child)===-1)
                                this.removeChild(child);
                                delete elems[len];
                                };
                            });
                        } catch(er) {alert(er);}
                    finally{return};
                    },
                "addOrigin": function(elem, propObj) {
                    if(!elem)
                        return false;
                    propObj = propObj||{};
                    elem.id = propObj.id||"origin"+getUniqueID();
                    return this.defs.appendChild(elem);
                    },
                "useOrigin": function(origin, propObj, cnt) {
                    if(!origin)
                        return false;
                    propObj = propObj||{};
                    propObj["xlink:href"] = "#"+(origin.id||(origin.id="origin"+getUniqueID()));
                    return appendElement.call(this, cnt, "use", propObj);
                    }
                }
            };

    /* Dziedziczenie */
    prepareMethods();// END

    /* Budowanie inormacji o atrybutach elementow */
    var forAll = (attrObj[""])? ("|"+attrObj[""]):"";
    map(attrObj, function(obj,i) {
        map(i.split("|"), function(obj,j) {
            if(!i) return;
            if(attrObj[this]) {
                attrObj[this] += "|"+attrObj[i] + forAll;
                return;
                };
            attrObj[this] = attrObj[i] + forAll;
            });
        });
    map(attrObj, function(obj,i) {
        if(/\|/.test(i)) return;
        var ar = map(this.split("|"), function() {
            return this.split(":");
            });
        attrObj[i] = ar2obj(ar);
        });// END
                                                                                //console.log(attrObj);
     /* Budowanie inormacji nazwach elementow */
    elementsName = ar2obj(map(elementsName.split("|"), function() {
        return this.split(":");
        }));// END
                                                                                //console.log(elementsName);
    /* Return class contructor */
    return _class;// END

    })();