import itertools
from functools import reduce

def alldifferent(k,n):
    '''Prawdopodobieństwo, że k wartości (wybrane spośród n możliwości) jest różne.'''
    assert(k<=n)
    nums = range(n,n-k,-1)
    dens = itertools.repeat(n)
    fracs = map(lambda x,y: float(x)/y, nums,dens)
    return reduce(float.__mul__, fracs)
    
def collide(k,n):
    '''Prawdopodobieństwo, że przy wyborze k wartości z n możliwości 
    co najmniej dwie wartości są takie same.'''
    return 1 - alldifferent(k,n)
 
print(collide(35,365))
