/////////////////////////////////////////////////
// Pobranie i zwrócenie aktualnych przesunięć
// pasków przewijania (x = w poziomie,
// y = w pionie)
/////////////////////////////////////////////////
function getScrollXY() {
  // Początkowo wartość przesunięć ustawiana na 0
  var scrOfX = 0, scrOfY = 0;
  
  // Określamy przeglądarki i ustawiamy
  // przesunięcia zgodnie z wartościami
  // ustawień pasków przewijania.
  if (typeof(window.pageYOffset) == 'number') {
    //przeglądarki zgodne z Netscape
    scrOfY = window.pageYOffset;
    scrOfX = window.pageXOffset;
  } else if(document.body &&
           (document.body.scrollLeft ||
            document.body.scrollTop)) {
    //przeglądarki obsługujące DOM 
    scrOfY = document.body.scrollTop;
    scrOfX = document.body.scrollLeft;
  } else if(document.documentElement &&
           (document.documentElement.scrollLeft ||
            document.documentElement.scrollTop)) {
    //tryb zgodności z IE6
    scrOfY = document.documentElement.scrollTop;
    scrOfX = document.documentElement.scrollLeft;
  }
  
  // Zwrócenie tablicy z wartościami przesunięć
  return [ scrOfX, scrOfY ];
} // Function getScrollXY


/////////////////////////////////////////////////
// Zmiana kierunku przewijania (dir) oraz obrazka
// tła kontrolki sterującej przewijaniem
// (tak by odpowiadał on kierunkowi przewijania) 
/////////////////////////////////////////////////
function chdirscroll () {
  dir = dir * -1;
  obj = document.getElementById("scroller");
  if (dir == 1) {
    obj.style.backgroundImage = "url(images/dn_arrow.gif)";
  } else {
    obj.style.backgroundImage = "url(images/up_arrow.gif)";
  }
}


/////////////////////////////////////////////////
// Przewijanie dokumentu w kierynku y (w pionie)
// o określoną wielość (zmiana * kierunek)
/////////////////////////////////////////////////
function doscroll() {
  // Inicjalizacja wartości
  var y = -1;
  var yy = 0;
  
  // Pobranie auktualnego kierunku przewijania
  xy = getScrollXY();
  y = xy[1];
  
  // Przewinięcie dokumentu
  scrollBy(0,inc*dir);
  
  // Sprawedzenie nowego położenia, jeśli jest takie 
  // samo jak poprzednie, to paski przewiniaja nie 
  // zmieniły stanu, a to oznacza, że jesteśmy na
  // samym początku lub końcu dokumentu
  xy = getScrollXY();
  yy = xy[1];
  
  // Jeśli pasek przewijania znajduje się na górze 
  // lub na dole dokumentu, zmieniamy kierunek przewijania
  // (jeśli została ustawiona opcja - bounce).
  // Jeśli opcja ta nie została ustawiona, zatrzymujemy
  // przewijanie
  if (y == yy) {
    if (bounce == 1) {
      chdirscroll();
    } else {
      clearInterval(scrollIt);
    }
  }
} // Function doscroll()


/////////////////////////////////////////////////
// Rozpoczęcie przewijania zgodnie z wcześniejszymi 
// ustawieniami
/////////////////////////////////////////////////
function setscroll () {
  inc = speedmod * 20; // określenie przesunięcia
  // jest ono mnożone przez 20 (by speedmod)
  // Rozpoczęcie przewijania (o wartość inc) co 25 milisekund
  scrollIt = setInterval("doscroll(inc);",25);
}


/////////////////////////////////////////////////
// Koniec przewijania
/////////////////////////////////////////////////
function stopscroll () {
  clearInterval(scrollIt);
}


/////////////////////////////////////////////////
// Inicjalizacja wartości przewijania i innych ustawien
/////////////////////////////////////////////////
function initscroll () {
  // Inicjalizacja zmiennych związanych z przewijaniem
  dir = 1; // Kierunek przewijania (większy od zera = w dół)
  bounce = 1; // Czy zmieniać kierunek (bounce = 1) czy nie (bounce = 0)
  speedmod = 1; // Modyfikator szybkości przewijania (im wyższy tym szybciej)
  
  // Wyświetlenie odpowiedniej strzałki w kontrolce
  obj = document.getElementById("scroller");
  obj.style.backgroundImage = "url(images/dn_arrow.gif)";
}

