/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.MinusExpression;
import rene.zirkel.expression.ProductExpression;

class QuotientExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public QuotientExpression(BasicExpression e1, BasicExpression e2) {
        this.E1 = e1;
        this.E2 = e2;
    }

    public static BasicExpression scan(ExpressionText t, BasicExpression E) throws ConstructionException {
        BasicExpression E1 = MinusExpression.scan(t);
        if (t.next() == '/') {
            t.advance();
            return QuotientExpression.scan(t, new QuotientExpression(E, E1));
        }
        if (t.next() == '*' && t.nextnext() != '*') {
            t.advance();
            return ProductExpression.scan(t, new QuotientExpression(E, E1));
        }
        return new QuotientExpression(E, E1);
    }

    public double getValue() throws ConstructionException {
        return this.E1.getValue() / this.E2.getValue();
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "/" + this.E2;
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }
}

