/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.TextObject;

public class TextConstructor
extends ObjectConstructor {
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        TextObject p = new TextObject(zc.getConstruction(), x, y);
        zc.addObject(p);
        p.setDefaults();
        p.edit(zc);
        zc.repaint();
    }

    public boolean waitForPoint() {
        return false;
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.text"));
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Text")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("x") || !tag.hasParam("y")) {
            throw new ConstructionException("Point coordinates missing!");
        }
        TextObject p = new TextObject(c2, 0.0, 0.0);
        try {
            double x = new Expression(tag.getValue("x"), c2, p).getValue();
            double y = new Expression(tag.getValue("y"), c2, p).getValue();
            p.move(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setName(tag, p);
        this.set(tree, p);
        c2.add(p);
        this.setConditionals(tree, c2, p);
        p.setLines(p.getText());
        if (tag.hasParam("fixed")) {
            p.setFixed(tag.getValue("x"), tag.getValue("y"));
        }
        return true;
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        this.showStatus(zc);
    }
}

