/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Image;
import java.util.Enumeration;
import rene.util.FileName;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.QuadricObject;

public class ImageObject
extends ConstructionObject {
    PointObject[] P;
    static Count N = new Count();
    String Filename;
    Image I;

    public ImageObject(Construction c2, PointObject[] p, String filename) {
        super(c2);
        this.P = p;
        this.Filename = FileName.filename(filename);
        this.updateText();
    }

    public String getTag() {
        return "Image";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        try {
            String[] Names = new String[this.P.length];
            int i = 0;
            while (i < this.P.length) {
                Names[i] = this.P[i].getName();
                ++i;
            }
            this.setText(ImageObject.textAny(Zirkel.name("text.image"), Names));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validate() {
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        if (this.I == null) {
            this.I = zc.doLoadImage(this.Filename);
            if (this.I == null || this.I.getWidth(zc) == 0 || this.I.getHeight(zc) == 0) {
                this.Valid = false;
                return;
            }
            this.Valid = true;
        }
        if (this.P[1] == this.P[2] || this.P[0] == this.P[2]) {
            int w = this.I.getWidth(zc);
            int h = this.I.getWidth(zc);
            double dx = this.P[1].getX() - this.P[0].getX();
            double dy = this.P[1].getY() - this.P[0].getY();
            g.drawImage(this.I, zc.col(this.P[0].getX()), zc.row(this.P[0].getY()), zc.col(this.P[1].getX()), zc.row(this.P[1].getY()), zc.col(this.P[0].getX() + dy), zc.row(this.P[0].getY() - dx), zc);
        }
        g.drawImage(this.I, zc.col(this.P[0].getX()), zc.row(this.P[0].getY()), zc.col(this.P[1].getX()), zc.row(this.P[1].getY()), zc.col(this.P[2].getX()), zc.row(this.P[2].getY()), zc);
    }

    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        return this.P[0].nearto(cc, rr, zc) || this.P[1].nearto(cc, rr, zc) || this.P[2].nearto(cc, rr, zc);
    }

    public void edit(ZirkelCanvas zc) {
        new ObjectEditDialog(zc.getFrame(), "", this).setVisible(true);
        zc.repaint();
    }

    public void printArgs(XmlWriter xml) {
        int i = 0;
        while (i < this.P.length) {
            xml.printArg("point" + (i + 1), this.P[i].getName());
            ++i;
        }
        xml.printArg("filename", FileName.filename(this.Filename));
    }

    public Enumeration depending() {
        DL.reset();
        int i = 0;
        while (i < this.P.length) {
            DL.add(this.P[i]);
            ++i;
        }
        return DL.elements();
    }

    public void translate() {
        int i = 0;
        while (i < this.P.length) {
            this.P[i] = (PointObject)this.P[i].getTranslation();
            ++i;
        }
    }

    public ConstructionObject copy() {
        try {
            QuadricObject o = (QuadricObject)this.clone();
            this.setTranslation(o);
            o.P = new PointObject[this.P.length];
            int i = 0;
            while (i < this.P.length) {
                o.P[i] = this.P[i];
                ++i;
            }
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            o.setTarget(false);
            return o;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return this.nearto(x, y, zc);
    }

    public boolean hasUnit() {
        return false;
    }
}

