/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class BoundedPointConstructor
extends ObjectConstructor
implements Selector {
    boolean Control;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.checkVisual()) {
            return;
        }
        this.Control = e2.isControlDown();
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        PointObject p = new PointObject(zc.getConstruction(), zc.x(e2.getX()), zc.y(e2.getY()), o);
        if (!e2.isShiftDown()) {
            p.setUseAlpha(true);
        }
        if (this.Control && o instanceof InsideObject) {
            p.setInside(true);
        }
        zc.addObject(p);
        p.validate();
        p.setDefaults();
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        this.Control = e2.isControlDown();
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.boundedpoint", "Bounded Point: Choose a circle or line!"));
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        if (this.Control && o instanceof InsideObject) {
            return true;
        }
        return !this.Control && o instanceof PointonObject;
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "PointOn")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("on")) {
            throw new ConstructionException("Point bound missing!");
        }
        try {
            PointObject p;
            ConstructionObject o = c2.find(tag.getValue("on"));
            if (o != null && !(o instanceof PointonObject) && !(o instanceof InsideObject)) {
                throw new ConstructionException("");
            }
            double x = 0.0;
            double y = 0.0;
            try {
                x = new Double(tag.getValue("x"));
                y = new Double(tag.getValue("y"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o != null) {
                p = new PointObject(c2, x, y, o);
            } else {
                p = new PointObject(c2, x, y);
                p.setLaterBind(tag.getValue("on"));
            }
            p.setInside(tag.hasTrueParam("inside"));
            try {
                ConstructionObject on;
                double alpha = new Double(tag.getValue("alpha"));
                p.setAlpha(alpha);
                p.setUseAlpha(true);
                if (tag.hasParam("on") && (on = c2.find(tag.getValue("on"))) != null) {
                    p.project(on, alpha);
                }
            }
            catch (Exception alpha) {
                // empty catch block
            }
            if (tag.hasParam("shape")) {
                String s = tag.getValue("shape");
                if (s.equals("square")) {
                    p.setType(0);
                }
                if (s.equals("diamond")) {
                    p.setType(1);
                }
                if (s.equals("circle")) {
                    p.setType(2);
                }
                if (s.equals("dot")) {
                    p.setType(3);
                }
                if (s.equals("cross")) {
                    p.setType(4);
                }
                if (s.equals("dcross")) {
                    p.setType(5);
                }
            }
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
            if (tag.hasParam("fixed")) {
                p.setFixed(tag.getValue("x"), tag.getValue("y"));
            }
            if (tag.hasParam("increment")) {
                try {
                    p.setIncrement(new Double(tag.getValue("increment")));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ConstructionException("Illegal point bound!");
        }
        return true;
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setPrompt(Zirkel.name("prompt.pointon"));
    }
}

