/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointEditDialog;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class PointObject
extends ConstructionObject
implements MoveableObject {
    protected double X;
    protected double Y;
    protected double Alpha;
    protected boolean AlphaValid = false;
    protected boolean UseAlpha = false;
    protected boolean Moveable;
    protected boolean Fixed;
    private static Count N = new Count();
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    public static int MaxType = 3;
    protected Expression EX;
    protected Expression EY;
    private ConstructionObject Bound = null;
    private boolean Later;
    private String LaterBind = "";
    private boolean KeepInside;
    private boolean DontUpdate = false;
    private double Increment = 0.0;
    private boolean Large = false;
    protected ConstructionObject MovedBy;
    private double Delta;
    static double[] x = new double[4];
    static double[] y = new double[4];

    public PointObject(Construction c2, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Type = 0;
    }

    public PointObject(Construction c2, double x, double y, ConstructionObject bound) {
        this(c2, x, y);
        this.Bound = bound;
    }

    public PointObject(Construction c2, String name) {
        super(c2, name);
        this.X = 0.0;
        this.Y = 0.0;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Type = 0;
    }

    public String getTag() {
        if (this.Bound == null) {
            return "Point";
        }
        return "PointOn";
    }

    public int getN() {
        return N.next();
    }

    public void setDefaults() {
        super.setDefaults();
        this.Type = this.Cn.DefaultType;
        this.setFillBackground(Global.getParameter("options.fillbackground", true));
    }

    public double changedBy() {
        return this.Delta;
    }

    public void validate() {
        if (this.DontUpdate) {
            return;
        }
        this.MovedBy = null;
        this.Delta = 0.0;
        this.Valid = true;
        if (this.Bound != null && !this.Bound.isInConstruction()) {
            this.Bound = null;
        }
        if (this.Bound != null && !this.Bound.valid()) {
            this.Valid = false;
            return;
        }
        if (this.Increment > 1.0E-4) {
            this.X = Math.floor(this.X / this.Increment + 0.5) * this.Increment;
            this.Y = Math.floor(this.Y / this.Increment + 0.5) * this.Increment;
        }
        if (this.Bound != null) {
            double x = this.X;
            double y = this.Y;
            if (this.KeepInside && this.Bound instanceof InsideObject) {
                ((InsideObject)((Object)this.Bound)).keepInside(this);
            } else if (!this.KeepInside && this.Bound instanceof PointonObject) {
                if (!this.AlphaValid || !this.UseAlpha) {
                    this.project(this.Bound);
                } else {
                    this.project(this.Bound, this.Alpha);
                }
            }
            if (this.Later) {
                this.Delta = Math.sqrt((x - this.X) * (x - this.X) + (y - this.Y) * (y - this.Y));
            }
        }
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    public void updateText() {
        if (this.Bound != null) {
            this.setText(PointObject.text1(Zirkel.name("text.boundedpoint"), this.Bound.getName()));
        } else if (this.EX != null && this.EY != null) {
            this.setText(PointObject.text2(Zirkel.name("text.point"), "\"" + this.EX + "\"", "\"" + this.EY + "\""));
        } else {
            this.setText(PointObject.text2(Zirkel.name("text.point"), "" + this.round(this.X), "" + this.round(this.Y)));
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double size = PointObject.drawPoint(g, zc, this, this.X, this.Y, this.Type);
        String s = AngleObject.translateToUnicode(this.getDisplayText());
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.DisplaysText = true;
            this.setFont(g);
            double d2 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
            if (!this.KeepClose || d2 < 1.0E-10) {
                this.TX1 = zc.col(this.X + this.XcOffset) + 2.0 * size;
                this.TY1 = zc.row(this.Y + this.YcOffset) + 2.0 * size;
                this.drawLabel(g, s);
            } else {
                this.drawPointLabel(g, s, zc, this.X, this.Y, this.YcOffset / d2, -this.XcOffset / d2, 0.0, 0.0);
            }
        }
    }

    public static double drawPoint(MyGraphics g, ZirkelCanvas zc, ConstructionObject o, double X, double Y, int type) {
        double size = zc.pointSize();
        if (o instanceof PointObject && ((PointObject)o).isLarge()) {
            size *= 1.5;
        }
        double r = zc.col(X);
        double c2 = zc.row(Y);
        if (size < 1.0) {
            size = 1.0;
        }
        if (o.visible(zc)) {
            if (o.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerLine(r, c2, r, c2);
            }
            g.setColor(o);
            switch (type) {
                case 0: {
                    if (o.getColorType() == 1) {
                        g.fillRect(r - (size -= 1.0), c2 - size, 2.0 * size, 2.0 * size, true, false, o);
                        break;
                    }
                    if (o.isFillBackground()) {
                        g.fillRect(r - size, c2 - size, 2.0 * size, 2.0 * size, false, false, o);
                        g.setColor(o);
                    }
                    g.drawRect(r - size, c2 - size, 2.0 * size, 2.0 * size);
                    break;
                }
                case 1: {
                    size += 1.0;
                    if (o.getColorType() == 1) {
                        PointObject.x[0] = r - (size += 1.0);
                        PointObject.x[1] = r;
                        PointObject.x[2] = r + size;
                        PointObject.x[3] = r;
                        PointObject.y[0] = c2;
                        PointObject.y[1] = c2 - size;
                        PointObject.y[2] = c2;
                        PointObject.y[3] = c2 + size;
                        g.fillPolygon(x, y, 4, false, false, o);
                        break;
                    }
                    if (o.isFillBackground()) {
                        PointObject.x[0] = r - size;
                        PointObject.x[1] = r;
                        PointObject.x[2] = r + size;
                        PointObject.x[3] = r;
                        PointObject.y[0] = c2;
                        PointObject.y[1] = c2 - size;
                        PointObject.y[2] = c2;
                        PointObject.y[3] = c2 + size;
                        g.fillPolygon(x, y, 4, false, false, o);
                        g.setColor(o);
                    }
                    g.drawLine(r - size, c2, r, c2 + size);
                    g.drawLine(r - size, c2, r, c2 - size);
                    g.drawLine(r + size, c2, r, c2 + size);
                    g.drawLine(r + size, c2, r, c2 - size);
                    break;
                }
                case 2: {
                    if (o.getColorType() == 1) {
                        g.fillOval(r - size - 1.0, c2 - size - 1.0, 2.0 * size + 2.0, 2.0 * size + 2.0, true, false, o);
                        break;
                    }
                    if (o.isFillBackground()) {
                        g.fillOval(r - size, c2 - size, 2.0 * size, 2.0 * size, false, false, o);
                        g.setColor(o);
                    }
                    g.drawOval(r - size, c2 - size, 2.0 * size, 2.0 * size);
                    break;
                }
                case 3: {
                    if (o.getColorType() == 1) {
                        g.fillRect(r, c2, 1.0, 1.0, true, false, o);
                        break;
                    }
                    g.drawLine(r, c2, r, c2);
                    break;
                }
                case 4: {
                    if (o.getColorType() == 1) {
                        g.drawThickLine(r - size, c2, r + size, c2);
                        g.drawThickLine(r, c2 - size, r, c2 + size);
                        break;
                    }
                    g.drawLine(r - size, c2, r + size, c2);
                    g.drawLine(r, c2 - size, r, c2 + size);
                    break;
                }
                case 5: {
                    if (o.getColorType() == 1) {
                        g.drawThickLine(r - size, c2 - size, r + size, c2 + size);
                        g.drawThickLine(r + size, c2 - size, r - size, c2 + size);
                        break;
                    }
                    g.drawLine(r - size, c2 - size, r + size, c2 + size);
                    g.drawLine(r + size, c2 - size, r - size, c2 + size);
                }
            }
        }
        return size;
    }

    public String getDisplayValue() {
        return "(" + this.roundDisplay(this.X) + (Global.getParameter("options.germanpoints", false) ? "|" : ",") + this.roundDisplay(this.Y) + ")";
    }

    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        double c2 = zc.col(this.X);
        double r = zc.row(this.Y);
        int size = (int)zc.selectionSize();
        this.Value = Math.abs((double)x - c2) + Math.abs((double)y - r);
        return this.Value <= (double)(size * 3 / 2);
    }

    public boolean nearto(PointObject p) {
        if (!this.Valid) {
            return false;
        }
        double dx = p.X - this.X;
        double dy = p.Y - this.Y;
        return Math.sqrt(dx * dx + dy * dy) < 1.0E-9;
    }

    public double distanceTo(int x, int y, ZirkelCanvas zc) {
        double dx = (double)x - zc.col(this.X);
        double dy = (double)y - zc.row(this.Y);
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public boolean moveable() {
        boolean fixed = this.Fixed;
        if (this.dependsOnItselfOnly()) {
            fixed = false;
        }
        return this.Moveable && !fixed && !this.Keep;
    }

    public boolean dependsOnItselfOnly() {
        boolean res = false;
        Enumeration e2 = this.depending();
        while (e2.hasMoreElements()) {
            if ((ConstructionObject)e2.nextElement() != this) continue;
            res = true;
            break;
        }
        e2 = this.depending();
        while (e2.hasMoreElements()) {
            if ((ConstructionObject)e2.nextElement() == this) continue;
            res = false;
            break;
        }
        return res;
    }

    public boolean dependsOnParametersOnly() {
        Enumeration e2 = this.depending();
        while (e2.hasMoreElements()) {
            if (((ConstructionObject)e2.nextElement()).isParameter()) continue;
            return false;
        }
        return true;
    }

    public boolean moveableBy(ConstructionObject o) {
        if (this.Bound != null) {
            return false;
        }
        return this.moveable() && (this.MovedBy == null || this.MovedBy == o);
    }

    public boolean moveablePoint() {
        if (this.Bound != null) {
            return true;
        }
        return this.Moveable && !this.Keep;
    }

    public boolean setBound(String name) {
        block6: {
            if (name.equals("")) {
                this.Bound = null;
                this.setFixed(false);
                this.Later = false;
                return true;
            }
            try {
                this.Bound = null;
                ConstructionObject o = this.Cn.find(name);
                if (o instanceof PointonObject) {
                    this.Bound = o;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = false;
                    break block6;
                }
                if (o instanceof InsideObject) {
                    this.Bound = o;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = true;
                    break block6;
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        if (this.Cn.before(this, this.Bound)) {
            this.Cn.needsOrdering();
            this.Cn.dovalidate();
        }
        this.updateText();
        return true;
    }

    public void setBound(ConstructionObject bound) {
        this.Bound = bound;
    }

    public ConstructionObject getBound() {
        return this.Bound;
    }

    public void setMoveable(boolean flag) {
        this.Moveable = flag;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EX = new Expression(x, this.getConstruction(), this);
        this.EY = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    public void move(double x, double y) {
        this.X = x;
        this.Y = y;
        this.AlphaValid = false;
    }

    public void setXY(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public void setA(double alpha) {
        this.Alpha = alpha;
    }

    public void project(ConstructionObject o) {
        if (!(o instanceof PointonObject)) {
            return;
        }
        ((PointonObject)((Object)o)).project(this);
        if (this.UseAlpha) {
            this.AlphaValid = true;
        }
    }

    public void project(ConstructionObject o, double alpha) {
        ((PointonObject)((Object)o)).project(this, alpha);
    }

    public void edit(ZirkelCanvas zc) {
        PointEditDialog d2 = new PointEditDialog(zc, this);
        d2.setVisible(true);
        zc.repaint();
        if (this.EX != null && !this.EX.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.EX.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        } else if (this.EY != null && !this.EY.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.EY.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xml) {
        this.updateText();
        if (this.Bound != null) {
            xml.printArg("on", this.Bound.getName());
            if (this.KeepInside) {
                xml.printArg("inside", "true");
            }
        }
        if (this.Fixed && this.EX != null) {
            xml.printArg("x", this.EX.toString());
            xml.printArg("actx", "" + this.X);
        } else {
            if (this.Bound != null && this.AlphaValid && this.UseAlpha) {
                xml.printArg("alpha", "" + this.Alpha);
            }
            xml.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null) {
            xml.printArg("y", this.EY.toString());
            xml.printArg("acty", "" + this.Y);
        } else {
            xml.printArg("y", "" + this.Y);
        }
        this.printType(xml);
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        if (this.Increment > 1.0E-4) {
            xml.printArg("increment", "" + this.getIncrement());
        }
        if (this.isLarge()) {
            xml.printArg("large", "true");
        }
    }

    public void printType(XmlWriter xml) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xml.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xml.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xml.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xml.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xml.printArg("shape", "dcross");
                }
            }
        }
    }

    public int getType() {
        return this.Type;
    }

    public void setType(int type) {
        this.Type = type;
    }

    public void movedBy(ConstructionObject o) {
        this.MovedBy = o;
    }

    public boolean equals(ConstructionObject o) {
        if (!(o instanceof PointObject) || !o.valid()) {
            return false;
        }
        PointObject p = (PointObject)o;
        return this.equals(this.X, p.X) && this.equals(this.Y, p.Y);
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public boolean isOn(ConstructionObject o) {
        if (this.Bound != null) {
            return o == this.Bound;
        }
        return o.contains(this);
    }

    public void translate() {
        if (this.Bound != null) {
            this.Bound = this.Bound.getTranslation();
        } else if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Enumeration depending() {
        super.depending();
        if (this.Bound != null) {
            DL.add(this.Bound);
        }
        if (this.Fixed) {
            if (this.EX != null) {
                this.EX.addDep(this);
            }
            if (this.EY != null) {
                this.EY.addDep(this);
            }
        }
        return DL.elements();
    }

    public void snap(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
        this.updateText();
    }

    public void updateCircleDep() {
        if (this.Bound != null && this.Bound instanceof PrimitiveCircleObject) {
            ((PrimitiveCircleObject)this.Bound).addDep(this);
        }
        if (this.Bound != null && this.Bound instanceof PrimitiveLineObject) {
            ((PrimitiveLineObject)this.Bound).addDep(this);
        }
    }

    public boolean isPointOn() {
        return this.Bound != null;
    }

    public void setLaterBind(String s) {
        this.LaterBind = s;
    }

    public void setInside(boolean flag) {
        this.KeepInside = flag;
    }

    public boolean isInside() {
        return this.KeepInside;
    }

    public void laterBind(Construction c2) {
        if (this.LaterBind.equals("")) {
            return;
        }
        ConstructionObject o = c2.find(this.LaterBind);
        if (o != null && (o instanceof PointonObject || o instanceof InsideObject)) {
            this.Bound = o;
            this.updateText();
            this.validate();
        }
        this.LaterBind = "";
    }

    public void setAlpha(double alpha) {
        this.Alpha = alpha;
        this.AlphaValid = true;
    }

    public void setUseAlpha(boolean flag) {
        this.UseAlpha = flag;
    }

    public boolean useAlpha() {
        return this.UseAlpha;
    }

    public double getAlpha() {
        return this.Alpha;
    }

    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x - this.X;
        this.YcOffset = y - this.Y;
    }

    public boolean canKeepClose() {
        return true;
    }

    public boolean dontUpdate() {
        return this.DontUpdate;
    }

    public void dontUpdate(boolean flag) {
        this.DontUpdate = flag;
    }

    public void setTargetDefaults() {
        super.setTargetDefaults();
        this.Type = this.Cn.DefaultType;
    }

    public boolean startDrag(double x, double y) {
        return true;
    }

    public boolean dragTo(double x, double y) {
        this.move(x, y);
        return true;
    }

    public void setIncrement(double inc) {
        this.Increment = inc;
    }

    public double getIncrement() {
        return this.Increment;
    }

    public boolean isLarge() {
        return this.Large;
    }

    public void setLarge(boolean large) {
        this.Large = large;
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return o instanceof PointObject;
    }
}

