/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.Global;
import rene.gui.MyChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.HelpCloseDialog;

public class ExportScaler
extends HelpCloseDialog
implements ItemListener {
    TextFieldAction W;
    TextFieldAction H;
    TextFieldAction Scale;
    TextFieldAction Width;
    TextFieldAction Height;
    TextFieldAction DPI;
    TextFieldAction LineWidth;
    TextFieldAction TextSize;
    TextFieldAction PointSize;
    Checkbox Middle;
    Checkbox Sizes;
    Checkbox Aspect;
    Checkbox Latex;
    ZirkelFrame F;
    boolean AbsCoord;
    MyChoice Presets;
    String[] Pres = new String[]{"printscaler.preset", "printscaler.preset.300dpi", "printscaler.preset.300dpi12", "printscaler.preset.window", "printscaler.preset.clip50", "printscaler.preset.latex10"};
    String[] PresVect = new String[]{"printscaler.preset", "printscaler.preset.300dpi", "printscaler.preset.300dpi12"};

    public ExportScaler(ZirkelFrame f2, boolean abscoord) {
        super(f2, Global.name("printscaler.title"), true);
        int i;
        this.F = f2;
        this.AbsCoord = abscoord;
        this.setLayout(new BorderLayout());
        MyPanel panel0 = new MyPanel();
        panel0.setLayout(new GridLayout(1, 2));
        panel0.add(new MyLabel(Zirkel.name("printscaler.presets")));
        this.Presets = new MyChoice();
        panel0.add(this.Presets);
        if (abscoord) {
            i = 0;
            while (i < this.Pres.length) {
                this.Presets.add(Zirkel.name(this.Pres[i]));
                ++i;
            }
        } else {
            i = 0;
            while (i < this.PresVect.length) {
                this.Presets.add(Zirkel.name(this.PresVect[i]));
                ++i;
            }
        }
        this.Presets.addItemListener(this);
        this.add("North", new Panel3D(panel0));
        MyPanel panel1 = new MyPanel();
        panel1.setLayout(new BorderLayout());
        MyPanel north1 = new MyPanel();
        north1.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.setLayout(new GridLayout(0, 2));
        double scale = Global.getParameter("printscale.scale", 1.0);
        int w = (int)((double)this.F.ZC.IW * scale);
        int h = (int)((double)this.F.ZC.IH * scale);
        north.add(new MyLabel(Zirkel.name("printscaler.w")));
        this.W = new TextFieldAction(this, "w");
        north.add(this.W);
        this.W.setText("" + Global.getParameter("printscale.w", w));
        north.add(new MyLabel(Zirkel.name("printscaler.h")));
        this.H = new TextFieldAction(this, "h");
        north.add(this.H);
        this.H.setText("" + Global.getParameter("printscale.h", h));
        north.add(new MyLabel(Zirkel.name("printscaler.scale")));
        this.Scale = new TextFieldAction(this, "scale");
        north.add(this.Scale);
        this.Scale.setText("" + Global.getParameter("printscale.scale", 1.0));
        north.add(new MyLabel(Zirkel.name("printscaler.aspect")));
        this.Aspect = new CheckboxAction(this, "", "aspect");
        north.add(this.Aspect);
        this.Aspect.setState(Global.getParameter("printscale.aspect", false));
        north.add(new MyLabel(Zirkel.name("printscaler.middle")));
        this.Middle = new CheckboxAction(this, "", "middle");
        north.add(this.Middle);
        this.Middle.setState(Global.getParameter("printscale.middle", false));
        if (abscoord) {
            panel1.add("North", new Panel3D(north));
        }
        north1.add("Center", new Panel3D(north));
        MyPanel north2 = new MyPanel();
        north2.setLayout(new GridLayout(0, 2));
        north2.add(new MyLabel(Zirkel.name("printscaler.latex")));
        this.Latex = new CheckboxAction(this, "", "latex");
        north2.add(this.Latex);
        this.Latex.setState(Global.getParameter("printscale.latex", false));
        north1.add("South", new Panel3D(north2));
        if (abscoord) {
            panel1.add("North", north1);
        }
        MyPanel middle = new MyPanel();
        middle.setLayout(new GridLayout(0, 2));
        middle.add(new MyLabel(Zirkel.name("printscaler.width")));
        this.Width = new TextFieldAction(this, "width");
        middle.add(this.Width);
        this.Width.setText("" + Global.getParameter("printscale.width", 5.0));
        middle.add(new MyLabel(Zirkel.name("printscaler.height")));
        this.Height = new TextFieldAction(this, "height");
        middle.add(this.Height);
        this.Height.setText("" + Global.getParameter("printscale.height", 5.0));
        middle.add(new MyLabel(Zirkel.name("printscaler.dpi")));
        this.DPI = new TextFieldAction(this, "dpi");
        middle.add(this.DPI);
        this.DPI.setText("" + Global.getParameter("printscale.dpi", 300));
        panel1.add("Center", new Panel3D(middle));
        MyPanel south = new MyPanel();
        south.setLayout(new GridLayout(0, 2));
        south.add(new MyLabel(Zirkel.name("printscaler.sizes")));
        this.Sizes = new CheckboxAction(this, "", "sizes");
        south.add(this.Sizes);
        this.Sizes.setState(Global.getParameter("printscale.sizes", true));
        south.add(new MyLabel(Zirkel.name("printscaler.linewidth")));
        this.LineWidth = new TextFieldAction(this, "linewidth");
        south.add(this.LineWidth);
        this.LineWidth.setText("" + Global.getParameter("printscale.linewidth", 0.02));
        south.add(new MyLabel(Zirkel.name("printscaler.pointsize")));
        this.PointSize = new TextFieldAction(this, "pointsize");
        south.add(this.PointSize);
        this.PointSize.setText("" + Global.getParameter("printscale.pointsize", 0.07));
        south.add(new MyLabel(Zirkel.name("printscaler.textsize")));
        this.TextSize = new TextFieldAction(this, "textsize");
        south.add(this.TextSize);
        this.TextSize.setText("" + Global.getParameter("printscale.textsize", 0.3));
        panel1.add("South", new Panel3D(south));
        this.add("Center", panel1);
        MyPanel panel2 = new MyPanel();
        panel2.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        panel2.add(new ButtonAction(this, Zirkel.name("cancel"), "Close"));
        this.addHelp(panel2, "print");
        this.add("South", new Panel3D(panel2));
        String last = Global.getParameter("printscaler.changed", "");
        if (last.equals("scale")) {
            this.doAction("scale");
        } else if (last.equals("widthheight")) {
            this.doAction("width");
        } else {
            this.doAction("w");
        }
        if (this.Middle.getState()) {
            this.Sizes.setState(false);
        }
        this.pack();
        this.center(f2);
        this.setVisible(true);
    }

    public double round(double x) {
        return (double)Math.round(x * 100.0) / 100.0;
    }

    public void doAction(String o) {
        if (o.equals("width") || o.equals("height")) {
            double w = this.getValue(this.Width, 5.0, 1.0, 100.0);
            double h = this.getValue(this.Height, 5.0, 1.0, 100.0);
            this.Width.setText("" + this.round(w));
            this.Height.setText("" + this.round(h));
            if (this.Aspect.getState()) {
                if (o.equals("width")) {
                    this.Height.setText("" + this.round(w * (double)this.F.ZC.IH / (double)this.F.ZC.IW));
                } else if (o.equals("height")) {
                    this.Width.setText("" + this.round(h * (double)this.F.ZC.IW / (double)this.F.ZC.IH));
                }
            }
            this.setWHS();
            Global.setParameter("printscaler.changed", "widthheight");
        } else {
            if (o.equals("dpi")) {
                String last = Global.getParameter("printscaler.changed", "");
                if (last.equals("wh") || last.equals("scale")) {
                    this.doAction("w");
                } else {
                    this.doAction("width");
                }
                return;
            }
            if (o.equals("w") || o.equals("h")) {
                double w = this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0);
                double h = this.getValue(this.H, this.F.ZC.IW, 50.0, 5000.0);
                this.W.setText("" + (int)w);
                this.H.setText("" + (int)h);
                if (this.Aspect.getState()) {
                    if (o.equals("w")) {
                        this.H.setText("" + (int)(w * (double)this.F.ZC.IH / (double)this.F.ZC.IW));
                    } else if (o.equals("h")) {
                        this.W.setText("" + (int)(h * (double)this.F.ZC.IW / (double)this.F.ZC.IH));
                    }
                }
                this.Scale.setText("" + w / (double)this.F.ZC.IW);
                Global.setParameter("printscaler.changed", "wh");
                this.setWidthHeight();
            } else if (o.equals("scale")) {
                double scale = this.getValue(this.Scale, 1.0, 0.1, 100.0);
                this.W.setText("" + (int)((double)this.F.ZC.IW * scale));
                this.H.setText("" + (int)((double)this.F.ZC.IH * scale));
                if (Global.getParameter("printscaler.changed", "").equals("scaled")) {
                    double dpi = this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0) / (this.getValue(this.Width, 5.0, 1.0, 100.0) / 2.54);
                    this.DPI.setText("" + this.round(dpi));
                }
                Global.setParameter("printscaler.changed", "scale");
                this.setWidthHeight();
            } else if (o.equals("OK")) {
                if (this.Width.isChanged() || this.Height.isChanged() || this.DPI.isChanged()) {
                    this.setWHS();
                    Global.setParameter("printscaler.changed", "widthheight");
                } else if (this.W.isChanged() || this.H.isChanged()) {
                    this.setWidthHeight();
                    Global.setParameter("printscaler.changed", "wh");
                } else if (this.Scale.isChanged()) {
                    double scale = this.getValue(this.Scale, 1.0, 0.1, 100.0);
                    this.W.setText("" + (int)((double)this.F.ZC.IW * scale));
                    this.H.setText("" + (int)((double)this.F.ZC.IH * scale));
                    Global.setParameter("printscaler.changed", "scale");
                    this.setWidthHeight();
                }
                Global.setParameter("printscale.w", this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0));
                Global.setParameter("printscale.h", this.getValue(this.H, this.F.ZC.IW, 50.0, 5000.0));
                Global.setParameter("printscale.scale", this.getValue(this.Scale, 1.0, 0.1, 100.0));
                Global.setParameter("printscale.width", this.getValue(this.Width, 5.0, 1.0, 100.0));
                Global.setParameter("printscale.height", this.getValue(this.Height, 5.0, 1.0, 100.0));
                Global.setParameter("printscale.dpi", this.getValue(this.DPI, 300.0, 50.0, 1200.0));
                Global.setParameter("printscale.linewidth", this.getValue(this.LineWidth, 0.02, 0.005, 0.5));
                Global.setParameter("printscale.pointsize", this.getValue(this.PointSize, 0.07, 0.01, 2.0));
                Global.setParameter("printscale.textsize", this.getValue(this.TextSize, 0.3, 0.05, 2.0));
                Global.setParameter("printscale.middle", this.Middle.getState());
                Global.setParameter("printscale.sizes", this.Sizes.getState());
                Global.setParameter("printscale.aspect", this.Aspect.getState());
                Global.setParameter("printscale.latex", this.Latex.getState());
                this.doclose();
            } else {
                super.doAction(o);
            }
        }
    }

    public void itemAction(String o, boolean flag) {
        if (o.equals("middle")) {
            this.Sizes.setState(false);
        } else if (o.equals("sizes")) {
            this.Middle.setState(false);
        }
    }

    public void setWHS() {
        double width = this.getValue(this.Width, 5.0, 1.0, 100.0);
        double height = this.getValue(this.Height, 5.0, 1.0, 100.0);
        double dpi = this.getValue(this.DPI, 300.0, 50.0, 4800.0);
        this.W.setText("" + (int)(width / 2.54 * dpi));
        this.H.setText("" + (int)(height / 2.54 * dpi));
        this.Scale.setText("" + width / 2.54 * dpi / (double)this.F.ZC.IW);
    }

    public void setWidthHeight() {
        int w = (int)this.getValue(this.W, this.F.ZC.IW, 50.0, 5000.0);
        int h = (int)this.getValue(this.H, this.F.ZC.IW, 50.0, 5000.0);
        double dpi = this.getValue(this.DPI, 300.0, 50.0, 4800.0);
        this.Width.setText("" + this.round((double)w / dpi * 2.54));
        this.Height.setText("" + this.round((double)h / dpi * 2.54));
    }

    double getValue(TextField f2, double def, double min, double max) {
        try {
            String s = f2.getText();
            double factor = 1.0;
            if (s.endsWith("pt")) {
                factor = 0.035;
                s = s.substring(0, s.length() - 2);
            } else if (s.endsWith("cm")) {
                factor = 1.0;
                s = s.substring(0, s.length() - 2);
            } else if (s.endsWith("mm")) {
                factor = 0.1;
                s = s.substring(0, s.length() - 2);
            } else if (s.endsWith("cm")) {
                factor = 1.0;
                s = s.substring(0, s.length() - 2);
            } else if (s.endsWith("''")) {
                factor = 0.39370078740157477;
                s = s.substring(0, s.length() - 2);
            } else if (s.endsWith("cm")) {
                factor = 1.0;
                s = s.substring(0, s.length() - 2);
            } else if (s.endsWith("in")) {
                factor = 0.39370078740157477;
                s = s.substring(0, s.length() - 2);
            }
            double x = new Double(s) * factor;
            if (x > max) {
                x = max;
            }
            if (x < min) {
                x = min;
            }
            return x;
        }
        catch (Exception e2) {
            return def;
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        switch (this.Presets.getSelectedIndex()) {
            case 1: {
                this.DPI.setText("300");
                this.Width.setText("" + this.round(this.F.ZC.DX));
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(true);
                this.LineWidth.setText("0.02");
                this.PointSize.setText("0.07");
                this.TextSize.setText("0.3");
                this.Latex.setState(false);
                this.doAction("width");
                Global.setParameter("printscaler.changed", "scaled");
                break;
            }
            case 2: {
                this.DPI.setText("300");
                this.Width.setText("12.0");
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(true);
                this.LineWidth.setText("0.02");
                this.PointSize.setText("0.07");
                this.TextSize.setText("0.3");
                this.Latex.setState(false);
                this.doAction("width");
                break;
            }
            case 3: {
                this.Scale.setText("1.0");
                this.DPI.setText("100");
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(false);
                this.Latex.setState(false);
                this.doAction("scale");
                break;
            }
            case 4: {
                this.Scale.setText("0.5");
                this.DPI.setText("100");
                this.Middle.setState(true);
                this.Aspect.setState(false);
                this.Sizes.setState(false);
                this.Latex.setState(false);
                this.doAction("scale");
                break;
            }
            case 5: {
                this.DPI.setText("300");
                this.Width.setText("12.0");
                this.Middle.setState(false);
                this.Aspect.setState(true);
                this.Sizes.setState(true);
                this.LineWidth.setText("0.02");
                this.PointSize.setText("0.07");
                this.TextSize.setText("0.35");
                this.Latex.setState(true);
                this.doAction("width");
            }
        }
    }
}

