/*
 * Decompiled with CFR 0.152.
 */
package rene.lister;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.Global;
import rene.gui.MyPanel;
import rene.lister.Element;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.lister.Wheel;
import rene.lister.WheelListener;
import rene.util.MyVector;

public class ListerPanel
extends MyPanel
implements WheelListener {
    private MyVector V;
    int Top;
    Image I;
    int W;
    int H;
    Graphics IG;
    Font F;
    FontMetrics FM;
    int Leading;
    int Height;
    int Ascent;
    int Descent;
    int PageSize;
    int HOffset;
    boolean ShowLast;
    Lister LD;
    String Name;
    public Color ListingBackground = null;
    public boolean MultipleSelection = true;
    public boolean EasyMultipleSelection = false;
    public boolean ReportSingleClick = false;
    public boolean RightMouseClick = false;
    int State = 0;
    Vector VAL = new Vector();
    MyVector Selected = new MyVector();

    public ListerPanel(Lister ld, String name) {
        this.LD = ld;
        this.Name = name;
        this.V = new MyVector();
        this.Top = 0;
        Wheel W = new Wheel(this);
        this.addMouseWheelListener(W);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ListerPanel.this.clicked(e2);
            }
        });
    }

    public ListerPanel(Lister ld) {
        this(ld, "");
    }

    public synchronized void paint(Graphics g) {
        Dimension d2 = this.getSize();
        if (this.I == null || this.I.getWidth(this) != d2.width || this.I.getHeight(this) != d2.height) {
            this.W = d2.width;
            this.H = d2.height;
            this.I = this.createImage(this.W, this.H);
            if (this.I == null) {
                return;
            }
            this.IG = this.I.getGraphics();
            this.init();
        }
        this.dopaint(this.IG);
        g.drawImage(this.I, 0, 0, this.W, this.H, this);
        double vp = this.V.size() > 1 ? (double)this.Top / (double)this.V.size() : 0.0;
        double vs = this.V.size() > 2 * this.PageSize ? (double)this.PageSize / (double)this.V.size() : 0.5;
        double hp = this.HOffset < 10 * this.W ? (double)this.HOffset / (double)(10 * this.W) : 0.9;
        double hs = 0.1;
        this.LD.setScrollbars(vp, vs, hp, hs);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    synchronized void init() {
        this.F = this.getFont();
        this.FM = this.getFontMetrics(this.F);
        this.Leading = this.FM.getLeading() + Global.getParameter("fixedfont.spacing", -1);
        this.Height = this.FM.getHeight();
        this.Ascent = this.FM.getAscent();
        this.Descent = this.FM.getDescent();
        if (Global.Background != null) {
            this.setBackground(Global.Background);
        }
        this.PageSize = this.Height + this.Leading > 0 ? this.H / (this.Height + this.Leading) : 10;
        this.antialias(true);
        this.Top = 0;
    }

    public void antialias(boolean flag) {
        if (Global.getParameter("font.smooth", true)) {
            this.IG = (Graphics2D)this.IG;
            ((Graphics2D)this.IG).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, flag ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void dopaint(Graphics g) {
        if (this.ShowLast) {
            this.Top = this.V.size() - this.PageSize + 1;
            if (this.Top < 0) {
                this.Top = 0;
            }
            this.ShowLast = false;
        }
        if (this.ListingBackground != null) {
            g.setColor(this.ListingBackground);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, this.W, this.H);
        g.setColor(Color.black);
        h = this.Leading + this.Ascent;
        totalh = this.getSize().height - this.Descent;
        line = this.Top;
        if (line >= 0) ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            el = (Element)this.V.elementAt(line);
            if (this.isSelected(line)) {
                g.setColor(this.getBackground().darker());
                g.fillRect(0, h - this.Ascent, this.W, this.Height);
                g.setColor(Color.black);
            }
            if ((col = el.getElementColor()) != null) {
                g.setColor(col);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(el.getElementString(this.State), 2 - this.HOffset, h);
            h += this.Leading + this.Height;
            ++line;
lbl29:
            // 2 sources

            ** while (line - this.Top < this.PageSize && line < this.V.size())
        }
lbl30:
        // 1 sources

    }

    public void setState(int s) {
        this.State = s;
    }

    public synchronized void add(Element e2) {
        this.V.addElement(e2);
    }

    public synchronized void up(int n) {
        this.Top += n;
        if (this.Top >= this.V.size()) {
            this.Top = this.V.size() - 1;
        }
        if (this.Top < 0) {
            this.Top = 0;
        }
        this.repaint();
    }

    public synchronized void down(int n) {
        this.Top -= n;
        if (this.Top < 0) {
            this.Top = 0;
        }
        this.repaint();
    }

    public synchronized void pageUp() {
        this.up(this.PageSize - 1);
        this.repaint();
    }

    public synchronized void pageDown() {
        this.down(this.PageSize - 1);
        this.repaint();
    }

    public synchronized void setVerticalPos(double x) {
        this.Top = (int)(x * (double)this.V.size());
        if (this.Top >= this.V.size()) {
            this.Top = this.V.size() - 1;
        }
        this.repaint();
    }

    public synchronized void setHorizontalPos(double x) {
        this.HOffset = (int)(x * 10.0 * (double)this.W);
        this.repaint();
    }

    public synchronized void clear() {
        this.Selected.removeAllElements();
        this.V.removeAllElements();
        this.Top = 0;
    }

    public synchronized void showLast() {
        this.ShowLast = true;
    }

    public synchronized boolean isSelected(int sel) {
        Enumeration e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            int n = (Integer)e2.nextElement();
            if (n != sel) continue;
            return true;
        }
        return false;
    }

    public synchronized void toggleSelect(int sel) {
        Enumeration e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            Integer i = (Integer)e2.nextElement();
            if (i != sel) continue;
            this.Selected.removeElement(i);
            return;
        }
        this.Selected.addElement(new Integer(sel));
    }

    public synchronized void expandSelect(int sel) {
        int i;
        int i2;
        int max = -1;
        Enumeration e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            i2 = (Integer)e2.nextElement();
            if (i2 <= max || i2 >= sel) continue;
            max = i2;
        }
        if (max >= 0) {
            i2 = max + 1;
            while (i2 <= sel) {
                this.select(i2);
                ++i2;
            }
            return;
        }
        int min = this.V.size();
        e2 = this.Selected.elements();
        while (e2.hasMoreElements()) {
            i = (Integer)e2.nextElement();
            if (i >= min || i <= sel) continue;
            min = i;
        }
        if (min < this.V.size()) {
            i = sel;
            while (i <= min) {
                this.select(i);
                ++i;
            }
        }
    }

    public synchronized void select(int sel) {
        if (!this.isSelected(sel)) {
            this.Selected.addElement(new Integer(sel));
        }
    }

    public void addActionListener(ActionListener al) {
        this.VAL.addElement(al);
    }

    public void removeActionListener(ActionListener al) {
        this.VAL.removeElement(al);
    }

    public void clicked(MouseEvent e2) {
        block12: {
            int n;
            block11: {
                n = e2.getY() / (this.Leading + this.Height);
                if (!e2.isMetaDown() || !this.RightMouseClick) break block11;
                Enumeration en = this.VAL.elements();
                while (en.hasMoreElements()) {
                    ((ActionListener)en.nextElement()).actionPerformed(new ListerMouseEvent((Object)this.LD, this.Name, e2));
                }
                break block12;
            }
            if (this.Top + n >= this.V.size()) {
                return;
            }
            int sel = n + this.Top;
            if (e2.getClickCount() >= 2) {
                if (!this.MultipleSelection) {
                    this.Selected.removeAllElements();
                }
                this.select(sel);
            } else if (this.MultipleSelection && (e2.isControlDown() || this.EasyMultipleSelection || e2.isShiftDown())) {
                if (e2.isControlDown() || this.EasyMultipleSelection) {
                    this.toggleSelect(sel);
                } else if (e2.isShiftDown()) {
                    this.expandSelect(sel);
                }
            } else {
                this.Selected.removeAllElements();
                this.Selected.addElement(new Integer(sel));
            }
            Graphics g = this.getGraphics();
            this.paint(g);
            g.dispose();
            if (e2.getClickCount() < 2 && !this.ReportSingleClick) break block12;
            Enumeration en = this.VAL.elements();
            while (en.hasMoreElements()) {
                ((ActionListener)en.nextElement()).actionPerformed(new ListerMouseEvent((Object)this.LD, this.Name, e2));
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 300);
    }

    public synchronized Element getElementAt(int n) {
        return (Element)this.V.elementAt(n);
    }

    public synchronized void save(PrintWriter o) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Element el = (Element)e2.nextElement();
            o.println(el.getElementString());
        }
    }

    public void setListingBackground(Color c2) {
        this.ListingBackground = c2;
    }
}

