/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyVector<klasse>
implements Enumeration<klasse>,
Iterator<klasse>,
Iterable<klasse> {
    klasse[] O;
    int OSize;
    int ON;
    int OLast;
    int Gap;
    int EN = 0;

    public MyVector(int initsize) {
        this.O = new Object[initsize];
        this.OSize = initsize;
        this.ON = 0;
        this.OLast = 0;
        this.Gap = -1;
    }

    public MyVector() {
        this(8);
    }

    public void addElement(klasse o) {
        if (this.OLast >= this.OSize) {
            this.extend();
        }
        this.O[this.OLast++] = o;
        ++this.ON;
    }

    public void extend() {
        if (this.ON < this.OLast / 2) {
            this.compress();
            return;
        }
        Object[] o = new Object[2 * this.OSize];
        System.arraycopy(this.O, 0, o, 0, this.OLast);
        this.OSize *= 2;
        this.O = o;
    }

    public void compress() {
        if (this.Gap < 0) {
            return;
        }
        int k = this.Gap;
        int i = this.Gap;
        while (i < this.OLast) {
            if (this.O[i] != null) {
                this.O[k++] = this.O[i];
            }
            ++i;
        }
        this.ON = k;
        i = k;
        while (i < this.OLast) {
            this.O[i] = null;
            ++i;
        }
        this.Gap = -1;
        this.OLast = this.ON;
    }

    public Enumeration<klasse> elements() {
        this.compress();
        this.EN = 0;
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        while (this.EN < this.OLast && this.O[this.EN] == null) {
            ++this.EN;
        }
        return this.EN < this.OLast;
    }

    @Override
    public klasse nextElement() {
        if (!this.hasMoreElements()) {
            throw new ArrayIndexOutOfBoundsException(this.OLast);
        }
        return this.O[this.EN++];
    }

    @Override
    public boolean hasNext() {
        while (this.EN < this.OLast && this.O[this.EN] == null) {
            ++this.EN;
        }
        return this.EN < this.OLast;
    }

    @Override
    public klasse next() {
        if (!this.hasMoreElements()) {
            throw new ArrayIndexOutOfBoundsException(this.OLast);
        }
        return this.O[this.EN++];
    }

    @Override
    public void remove() {
        int i = this.EN - 1;
        if (this.EN < 0) {
            return;
        }
        this.O[i] = null;
        --this.ON;
        if (this.Gap < 0 || this.Gap > i) {
            this.Gap = i;
        }
        if (i == this.OLast - 1) {
            --this.OLast;
        }
        while (this.OLast > 0 && this.O[this.OLast - 1] == null) {
            --this.OLast;
        }
        if (this.Gap >= this.OLast) {
            this.Gap = -1;
        }
    }

    @Override
    public Iterator<klasse> iterator() {
        return this;
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.OLast) {
            this.O[i] = null;
            ++i;
        }
        this.OLast = 0;
        this.ON = 0;
        this.Gap = -1;
    }

    public void removeElement(klasse o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return;
        }
        this.O[i] = null;
        --this.ON;
        if (this.Gap < 0 || this.Gap > i) {
            this.Gap = i;
        }
        if (i == this.OLast - 1) {
            --this.OLast;
        }
        while (this.OLast > 0 && this.O[this.OLast - 1] == null) {
            --this.OLast;
        }
        if (this.Gap >= this.OLast) {
            this.Gap = -1;
        }
    }

    public int indexOf(klasse o) {
        if (this.EN > 0 && this.EN <= this.OLast && this.O[this.EN - 1].equals(o)) {
            return this.EN - 1;
        }
        if (this.Gap < 0) {
            int i = 0;
            while (i < this.OLast) {
                if (this.O[i].equals(o)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < this.Gap) {
            if (this.O[i].equals(o)) {
                return i;
            }
            ++i;
        }
        int k = this.Gap;
        int i2 = this.Gap;
        while (i2 < this.OLast) {
            if (this.O[i2] != null) {
                if (this.O[i2].equals(o)) {
                    this.Gap = k;
                    return i2;
                }
                this.O[k++] = this.O[i2];
                this.O[i2] = null;
            }
            ++i2;
        }
        this.ON = k;
        i2 = k;
        while (i2 < this.OLast) {
            this.O[i2] = null;
            ++i2;
        }
        this.Gap = -1;
        this.OLast = this.ON;
        return -1;
    }

    public int size() {
        return this.ON;
    }

    public klasse elementAt(int n) {
        if (n < 0 || n >= this.ON) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.Gap < 0 || n < this.Gap) {
            return this.O[n];
        }
        int k = this.Gap;
        int i = this.Gap;
        while (i < this.OLast) {
            if (this.O[i] != null) {
                this.O[k] = this.O[i];
                this.O[i] = null;
                if (k == n) {
                    klasse ret = this.O[k];
                    this.Gap = ++k;
                    if (this.Gap >= this.ON) {
                        int j = this.Gap;
                        while (j < this.OLast) {
                            this.O[j] = null;
                            ++j;
                        }
                        this.OLast = this.ON;
                        this.Gap = -1;
                    }
                    return ret;
                }
                ++k;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public Object[] getArray() {
        this.compress();
        return this.O;
    }

    public void copyInto(Object[] o) {
        this.compress();
        System.arraycopy(this.O, 0, o, 0, this.ON);
    }

    public boolean equals(MyVector V) {
        if (V.ON != this.ON) {
            return false;
        }
        V.compress();
        this.compress();
        int i = 0;
        while (i < this.ON) {
            if (!V.O[i].equals(this.O[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIdentical(MyVector V) {
        if (V.ON != this.ON) {
            return false;
        }
        V.compress();
        this.compress();
        int i = 0;
        while (i < this.ON) {
            if (V.O[i] != this.O[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void truncate(int n) {
        if (n >= this.ON) {
            return;
        }
        this.compress();
        int i = n;
        while (i < this.OLast) {
            this.O[i] = null;
            ++i;
        }
        this.OLast = this.ON = n;
    }

    public static void main(String[] args) {
        MyVector<String> V = new MyVector<String>();
        int i = 1;
        while (i <= 10) {
            V.addElement("Element " + i);
            ++i;
        }
        i = 4;
        while (i <= 9) {
            V.removeElement("Element " + i);
            ++i;
        }
        System.out.println("--> " + V.elementAt(3));
        System.out.println(String.valueOf(V.ON) + " elements, " + V.OLast + " used, " + V.Gap + " gap.");
        System.out.println("--> " + V.elementAt(3));
        System.out.println(String.valueOf(V.ON) + " elements, " + V.OLast + " used, " + V.Gap + " gap.");
        i = 11;
        while (i <= 20) {
            V.addElement("Element " + i);
            ++i;
        }
        System.out.println(String.valueOf(V.ON) + " elements, " + V.OLast + " used ," + V.Gap + " gap.");
        Enumeration E = V.elements();
        while (E.hasMoreElements()) {
            System.out.println((String)E.nextElement());
        }
        System.out.println(String.valueOf(V.ON) + " elements, " + V.OLast + " used, " + V.Gap + " gap.");
    }
}

