/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.EPSGraphics;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;

public class MyGraphicsEPS
extends MyGraphics {
    EPSGraphics G;
    public static int MaxR = 1000000;
    double LineWidth = 1.0;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsEPS(OutputStream out, int w, int h) {
        this.G = new EPSGraphics(out, w, h, 0, true);
    }

    public void setLineWidth(double w) {
        this.LineWidth = w;
        this.G.setLineWidth(w);
    }

    public void clearRect(int x, int y, int w, int h, Color c2) {
        this.G.setColor(c2);
        this.G.fillRect(x, y, w, h);
    }

    public void setColor(Color c2) {
        this.G.setColor(c2);
    }

    public void setColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.getColorType() == 2) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    public void setFillColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.getColorType() != 1) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
    }

    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            this.setColor(o);
            o.setColorType(type);
        } else {
            this.setColor(o);
        }
    }

    public void drawRect(double x, double y, double w, double h) {
        this.G.drawRect(x, y, w, h);
    }

    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        if (o.getColorType() == 1) {
            this.drawThickLine(x, y, x1, y1);
        } else if (o.getColorType() == 2) {
            this.drawThinLine(x, y, x1, y1);
        } else {
            this.drawLine(x, y, x1, y1);
        }
    }

    public void drawLine(double x, double y, double x1, double y1) {
        this.G.drawLine(x, y, x1, y1);
    }

    public void drawThickLine(double c1, double r1, double c2, double r2) {
        this.G.setLineWidth(3.0 * this.LineWidth);
        this.G.drawLine(c1, r1, c2, r2);
        this.G.setLineWidth(this.LineWidth);
    }

    public void drawThinLine(double c1, double r1, double c2, double r2) {
        this.G.setDash(4.0, 4.0);
        this.G.drawLine(c1, r1, c2, r2);
        this.G.clearDash();
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        this.G.drawArc(x, y, w, h, a2, b2);
    }

    public void drawThickArc(double x, double y, double w, double h, double a2, double b2) {
        this.G.setLineWidth(3.0 * this.LineWidth);
        this.drawArc(x + 1.0, y + 1.0, w - 2.0, w - 2.0, a2, b2);
        this.G.setLineWidth(this.LineWidth);
    }

    public void drawThinArc(double x, double y, double w, double h, double a2, double b2) {
        this.G.setDash(4.0, 4.0);
        this.drawArc(x + 1.0, y + 1.0, w - 2.0, w - 2.0, a2, b2);
        this.G.clearDash();
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        if (o.getColorType() == 1) {
            this.drawThickArc(x, y, w, h, a2, b2);
        } else if (o.getColorType() == 2) {
            this.drawThinArc(x, y, w, h, a2, b2);
        } else {
            this.drawArc(x, y, w, h, a2, b2);
        }
    }

    public void drawString(String s, double x, double y) {
        this.G.drawString(s, x, y);
    }

    public void drawOval(double x, double y, double w, double h) {
        if (w < (double)MaxR) {
            this.G.drawOval(x, y, w, h);
        }
    }

    public void drawThickOval(double x, double y, double w, double h) {
        this.drawOval(x, y, w, h);
        this.drawOval(x - 1.0, y - 1.0, w + 2.0, h + 2.0);
        this.drawOval(x + 1.0, y + 1.0, w - 2.0, h - 2.0);
    }

    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        this.setColor(o);
        if (o.getColorType() == 1) {
            this.drawThickOval(x, y, w, h);
        } else {
            this.drawOval(x, y, w, h);
        }
    }

    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setFillColor(o);
        this.G.fillRect(x, y, w, h);
        if (outline) {
            this.setColor(o);
            this.G.drawRect(x, y, w, h);
        }
    }

    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arc, ConstructionObject o) {
        this.setFillColor(o);
        if (arc) {
            this.G.fillArc(x, y, w, h, a2, b2);
        } else {
            this.G.fillChord(x, y, w, h, a2, b2);
        }
        if (outline) {
            this.setColor(o);
            this.G.drawArc(x, y, w, h, a2, b2);
        }
    }

    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        if (w >= (double)MaxR) {
            return;
        }
        this.setFillColor(o);
        this.G.fillOval(x, y, w, h);
        if (outline) {
            this.setColor(o);
            this.G.drawOval(x, y, w, h);
        }
    }

    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean transparent, ConstructionObject o) {
        if (o.getColorType() != 3) {
            this.setFillColor(o);
            this.G.fillPolygon(x, y, n);
        }
        if (outline) {
            this.setColor(o);
            this.G.drawPolygon(x, y, n);
        }
    }

    public void drawImage(Image i, int x, int y, ImageObserver o) {
    }

    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
    }

    public void close() throws IOException {
        this.G.close();
    }

    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.setFont(large, bold);
    }

    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    public void setFont(int h, boolean bold) {
        this.G.setFont(new Font(Global.getParameter("font.name", "dialog"), bold ? 1 : 0, h));
    }

    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String s) {
        return this.getFontMetrics().stringWidth(s);
    }

    public int stringHeight(String s) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String s, double x, double y) {
        this.drawString(s, x, y + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String s) {
        return this.getFontMetrics().getAscent();
    }
}

