/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import rene.dialogs.ColorEditor;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.util.FileName;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.HelpCloseDialog;

public class ExportDialog
extends HelpCloseDialog {
    ZirkelFrame ZF;
    Construction C;
    TextField PageTitle;
    TextField CFile;
    TextField Jar;
    TextField Width;
    TextField Height;
    TextField Solution;
    TextField StyleSheet;
    Checkbox BackgroundColor;
    Checkbox AppletColor;
    Checkbox Job;
    Checkbox Comment;
    Checkbox SaveSolution;
    Checkbox LinkSolution;
    Checkbox JumpSolution;
    Checkbox Digits;
    Checkbox Colors;
    Checkbox Background;
    Checkbox Popup;
    Checkbox Zoom;
    Checkbox RestrictedMove;
    Checkbox CopyJar;
    Panel CP;
    Choice Style;
    boolean OK = false;
    IconBar IBa;
    IconBar IBb;
    boolean SaveDimensions = true;
    boolean Restrict;
    double Persp = 1.0;
    static String[] ISb = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "colors", "hidden", "macro0", "replay", "arrow", "obtuse", "solid", "grid", "thickness0", "fillbackground", "type0", "partial", "plines", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "ticks", "function"};
    static String[] ISb0 = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "colors", "hidden", "macro", "replay", "arrow", "obtuse", "solid", "grid", "thickness", "fillbackground", "type", "partial", "plines", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "ticks", "function"};
    static String[] ST = new String[]{"plain", "3D", "icons", "full", "nonvisual", "breaks"};
    static char[] A = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ExportDialog(ZirkelFrame zf, Construction c2, boolean restrict) {
        super(zf, Zirkel.name("export.title"), true);
        this.ZF = zf;
        this.C = c2;
        this.Restrict = restrict;
        this.setLayout(new BorderLayout());
        MyPanel p = new MyPanel();
        p.setLayout(new GridLayout(0, 2));
        p.add(new MyLabel(Zirkel.name("export.pagetitle")));
        this.PageTitle = new TextFieldAction((DoActionListener)this, "export.pagetitle", 32);
        p.add(this.PageTitle);
        this.PageTitle.setText(FileName.purefilename(zf.Filename));
        p.add(new MyLabel(Zirkel.name("export.stylesheet")));
        this.StyleSheet = new TextFieldAction((DoActionListener)this, "export.stylesheet", 32);
        p.add(this.StyleSheet);
        this.StyleSheet.setText(Global.getParameter("export.stylesheet", ""));
        p.add(new MyLabel(Zirkel.name("export.width")));
        this.Width = new TextFieldAction((DoActionListener)this, "export.width", 32);
        p.add(this.Width);
        this.Width.setText("" + Global.getParameter("export.width", 600));
        this.Width.addActionListener(this);
        p.add(new MyLabel(Zirkel.name("export.height")));
        this.Height = new TextFieldAction((DoActionListener)this, "export.height", 32);
        p.add(this.Height);
        this.Height.setText("" + Global.getParameter("export.height", 600));
        this.Height.addActionListener(this);
        p.add(new MyLabel(Zirkel.name("export.file")));
        this.CFile = new TextFieldAction((DoActionListener)this, "export.file", 32);
        p.add(this.CFile);
        this.CFile.setText(FileName.filename(zf.Filename));
        p.add(new MyLabel(Zirkel.name("export.jar")));
        this.Jar = new TextFieldAction((DoActionListener)this, "export.jar", 32);
        p.add(this.Jar);
        this.Jar.setText(Global.getParameter("export.jar", "zirkel.jar"));
        p.add(new MyLabel(""));
        this.CopyJar = new CheckboxAction(this, Zirkel.name("export.copyjar"));
        p.add(this.CopyJar);
        this.CopyJar.setState(false);
        if (this.ZF.ZC.isJob()) {
            p.add(new MyLabel(""));
            this.Job = new CheckboxAction(this, Zirkel.name("export.job"));
            p.add(this.Job);
            this.Job.setState(this.ZF.ZC.isJob());
        }
        if (this.ZF.ZC.isJob()) {
            p.add(new MyLabel(Zirkel.name("export.solution")));
            this.Solution = new TextFieldAction((DoActionListener)this, "export.solution", 32);
            p.add(this.Solution);
            this.Solution.setText(String.valueOf(FileName.purefilename(zf.Filename)) + "-sol.html");
            this.JumpSolution = new CheckboxAction(this, Zirkel.name("export.jumpsol"));
            p.add(this.JumpSolution);
            this.JumpSolution.setState(Global.getParameter("export.jumpsol", false));
            this.SaveSolution = new CheckboxAction(this, Zirkel.name("export.savesol"));
            p.add(this.SaveSolution);
            this.SaveSolution.setState(Global.getParameter("export.savesol", false));
            this.LinkSolution = new CheckboxAction(this, Zirkel.name("export.linksol"));
            p.add(this.LinkSolution);
            this.LinkSolution.setState(Global.getParameter("export.linksol", false));
            p.add(new MyLabel(""));
        }
        p.add(new MyLabel(Zirkel.name("export.color")));
        this.CP = new MyPanel();
        p.add(this.CP);
        this.CP.setBackground(Global.getParameter("export.color", this.ZF.ZC.getBackground()));
        this.BackgroundColor = new CheckboxAction(this, Zirkel.name("export.backgroundcolor"));
        p.add(this.BackgroundColor);
        this.BackgroundColor.setState(Global.getParameter("export.backgroundcolor", true));
        this.AppletColor = new CheckboxAction(this, Zirkel.name("export.appletcolor"));
        p.add(this.AppletColor);
        this.AppletColor.setState(Global.getParameter("export.appletcolor", true));
        this.Style = new MyChoice();
        int i = 0;
        while (i < ST.length) {
            this.Style.add(Global.name("export." + ST[i]));
            ++i;
        }
        int style = Global.getParameter("export.style", 0);
        if (style <= 1 && this.ZF.ZC.isJob()) {
            style = 3;
        }
        this.Style.select(style);
        p.add(new MyLabel(Zirkel.name("export.style")));
        p.add(this.Style);
        this.Digits = new CheckboxAction(this, Zirkel.name("export.digits"));
        p.add(this.Digits);
        this.Digits.setState(Global.getParameter("export.digits", true));
        this.Comment = new CheckboxAction(this, Zirkel.name("export.comment"));
        p.add(this.Comment);
        this.Comment.setState(Global.getParameter("export.comment", true));
        this.Colors = new CheckboxAction(this, Zirkel.name("export.colors"));
        p.add(this.Colors);
        this.Colors.setState(Global.getParameter("export.colors", true));
        this.Background = new CheckboxAction(this, Zirkel.name("export.background"));
        p.add(this.Background);
        this.Background.setState(Global.getParameter("export.background", false));
        this.Popup = new CheckboxAction(this, Zirkel.name("export.popup"));
        p.add(this.Popup);
        this.Popup.setState(Global.getParameter("export.popup", true));
        this.Zoom = new CheckboxAction(this, Zirkel.name("export.zoom"));
        p.add(this.Zoom);
        this.Zoom.setState(Global.getParameter("export.zoom", false));
        this.RestrictedMove = new CheckboxAction(this, Zirkel.name("export.restrictedmove"));
        p.add(this.RestrictedMove);
        this.RestrictedMove.setState(Global.getParameter("export.restrictedmove", false));
        p.add(new MyLabel(""));
        this.add("North", new Panel3D(p));
        MyPanel icons = new MyPanel();
        icons.setLayout(new GridLayout(0, 1));
        this.IBa = new IconBar(this.ZF);
        String ica = restrict ? Global.getParameter("restrictedicons", " point line segment ray circle circle3 fixedcircle fixedangle intersection ") : Global.getParameter("export.icons", " point line segment ray circle circle3 fixedcircle fixedangle intersection ");
        int i2 = 0;
        while (i2 < 26) {
            String s = ZirkelFrame.ObjectStrings[i2];
            this.IBa.addToggleLeft(s);
            if (ica.equals("full") || ica.indexOf(" " + s + " ") >= 0) {
                this.IBa.setState(s, true);
            }
            ++i2;
        }
        icons.add(new Panel3D(this.IBa));
        this.IBb = new IconBar(this.ZF);
        String icb = restrict ? Global.getParameter("restrictedicons", " back hidden color indicate twolines ") : Global.getParameter("export.tools", " back hidden color indicate twolines ");
        int i3 = 0;
        while (i3 < ISb.length) {
            String s = ISb[i3];
            if (s.equals("qintersection")) {
                this.IBb.addSeparatorLeft();
            }
            if (s.equals("twolines")) {
                this.IBb.addSeparatorLeft();
            }
            if (s.equals("draw")) {
                this.IBb.addSeparatorLeft();
            }
            this.IBb.addToggleLeft(s);
            if (icb.equals("full") || icb.indexOf(ISb[i3]) >= 0) {
                this.IBb.setState(s, true);
            }
            ++i3;
        }
        icons.add(new Panel3D(this.IBb));
        this.IBb.setState("qchoice", Global.getParameter("options.choice", false));
        this.IBb.setState("qintersection", Global.getParameter("options.intersection", false));
        this.IBb.setState("qpointon", Global.getParameter("options.pointon", false));
        this.IBb.setState("indicate", !Global.getParameter("options.indicate.simple", false));
        this.add("Center", icons);
        MyPanel buttons = new MyPanel();
        buttons.add(new ButtonAction(this, Zirkel.name("export.setsize"), "setsize"));
        buttons.add(new ButtonAction(this, Zirkel.name("export.setcolor"), "setcolor"));
        buttons.add(new MyLabel(" "));
        buttons.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        buttons.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(buttons, "htmlexport");
        this.add("South", buttons);
        this.pack();
        if (this.getSize().width > 750) {
            this.setSize(750, this.getSize().height);
        }
        Dimension d2 = this.ZF.ZC.getSize();
        if (d2.width > 0) {
            this.Persp = (double)d2.height / (double)d2.width;
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.Width) {
            int w = this.getWidth();
            this.Width.setText("" + w);
            this.Height.setText("" + (int)((double)w * this.Persp));
        } else if (e2.getSource() == this.Height && this.Persp > 0.0) {
            int h = this.getHeight();
            this.Height.setText("" + h);
            this.Width.setText("" + (int)((double)h / this.Persp));
        }
    }

    public void doAction(String o) {
        this.OK = false;
        if (o.equals("OK")) {
            this.OK = true;
            Global.setParameter("export.stylesheet", this.StyleSheet.getText());
            Global.setParameter("export.jar", this.Jar.getText());
            if (this.SaveDimensions) {
                try {
                    Global.setParameter("export.height", Integer.parseInt(this.Height.getText()));
                    Global.setParameter("export.width", Integer.parseInt(this.Width.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Global.setParameter("export.color", this.CP.getBackground());
            Global.setParameter("export.backgroundcolor", this.BackgroundColor.getState());
            Global.setParameter("export.appletcolor", this.AppletColor.getState());
            if (this.JumpSolution != null) {
                Global.setParameter("export.jumpsol", this.JumpSolution.getState());
            }
            if (this.SaveSolution != null) {
                Global.setParameter("export.savesol", this.SaveSolution.getState());
            }
            if (this.LinkSolution != null) {
                Global.setParameter("export.linksol", this.LinkSolution.getState());
            }
            Global.setParameter("export.comment", this.Comment.getState());
            Global.setParameter("export.colors", this.Colors.getState());
            Global.setParameter("export.background", this.Background.getState());
            Global.setParameter("export.zoom", this.Zoom.getState());
            Global.setParameter("export.restrictedmove", this.RestrictedMove.getState());
            Global.setParameter("export.popup", this.Popup.getState());
            int i = this.Style.getSelectedIndex();
            if (i >= 0) {
                Global.setParameter("export.style", i);
            }
            Global.setParameter("export.digits", this.Digits.getState());
            this.getIcons();
            this.getTools();
            this.doclose();
        } else if (o.equals("setcolor")) {
            ColorEditor d2 = new ColorEditor((Frame)this.ZF, "export.color", this.CP.getBackground());
            d2.center(this.ZF);
            d2.setVisible(true);
            this.CP.setBackground(Global.getParameter("export.color", this.CP.getBackground()));
        } else if (o.equals("setsize")) {
            Dimension d3 = this.ZF.ZC.getSize();
            this.Height.setText("" + d3.height);
            this.Width.setText("" + d3.width);
        } else {
            super.doAction(o);
        }
    }

    public boolean isAborted() {
        return !this.OK;
    }

    public String getPageTitle() {
        return this.PageTitle.getText();
    }

    public String getStyleSheet() {
        return this.StyleSheet.getText();
    }

    public String getFile() {
        return this.CFile.getText();
    }

    public String getDezimalColor() {
        Color c2 = this.CP.getBackground();
        return String.valueOf(c2.getRed()) + "," + c2.getGreen() + "," + c2.getBlue();
    }

    public String getHexColor() {
        Color c2 = this.CP.getBackground();
        return "#" + this.hex(c2.getRed()) + this.hex(c2.getGreen()) + this.hex(c2.getBlue());
    }

    String hex(int n) {
        return "" + A[n / 16] + A[n % 16];
    }

    public boolean useForBackground() {
        return this.BackgroundColor.getState();
    }

    public boolean useForApplet() {
        return this.AppletColor.getState();
    }

    public boolean isJob() {
        if (this.Job == null) {
            return false;
        }
        return this.Job.getState();
    }

    public String getIcons() {
        StringBuffer b2 = new StringBuffer();
        b2.append(" ");
        int i = 0;
        while (i < 26) {
            String s = ZirkelFrame.ObjectStrings[i];
            if (this.IBa.getState(s)) {
                b2.append(s);
                b2.append(" ");
            }
            ++i;
        }
        if (!this.Restrict) {
            Global.setParameter("export.icons", b2.toString());
        }
        return b2.toString();
    }

    public String getTools() {
        StringBuffer b2 = new StringBuffer();
        StringBuffer b1 = new StringBuffer();
        b2.append(" ");
        b1.append(" ");
        int i = 0;
        while (i < ISb.length) {
            String s = ISb[i];
            if (this.IBb.getState(s)) {
                b1.append(s);
                b1.append(" ");
            }
            if (s.equals("indicate") && !this.IBb.getState(s)) {
                b2.append("noindicate ");
            } else if (this.IBb.getState(s)) {
                b2.append(ISb0[i]);
                b2.append(" ");
            }
            ++i;
        }
        if (!this.Restrict) {
            Global.setParameter("export.tools", b1.toString());
        }
        return b2.toString();
    }

    public String getStyle() {
        int n = this.Style.getSelectedIndex();
        if (n >= 0) {
            Global.setParameter("export.style", n);
        }
        if (n < 0) {
            return ST[0];
        }
        return ST[n];
    }

    public String getJar() {
        return this.Jar.getText();
    }

    public boolean getCopyJar() {
        return this.CopyJar.getState();
    }

    public String getSolution() {
        if (this.Solution == null) {
            return "";
        }
        return this.Solution.getText();
    }

    public boolean saveComment() {
        Global.setParameter("export.comment", this.Comment.getState());
        return this.Comment.getState();
    }

    public int getWidth() {
        try {
            int w = Integer.parseInt(this.Width.getText());
            return w;
        }
        catch (Exception e2) {
            return Global.getParameter("export.width", 550);
        }
    }

    public int getHeight() {
        try {
            int w = Integer.parseInt(this.Height.getText());
            return w;
        }
        catch (Exception e2) {
            return Global.getParameter("export.height", 550);
        }
    }

    public boolean jumpSolution() {
        if (this.JumpSolution == null) {
            return false;
        }
        return this.JumpSolution.getState();
    }

    public boolean saveSolution() {
        if (this.SaveSolution == null) {
            return false;
        }
        return this.SaveSolution.getState();
    }

    public boolean linkSolution() {
        if (this.LinkSolution == null) {
            return false;
        }
        return this.LinkSolution.getState();
    }

    public boolean saveDigits() {
        return this.Digits.getState();
    }

    public boolean saveColors() {
        return this.Colors.getState();
    }

    public boolean saveBackground() {
        return this.Background.getState();
    }

    public boolean allowZoom() {
        return this.Zoom.getState();
    }

    public boolean allowPopup() {
        return this.Popup.getState();
    }

    public boolean restrictedMove() {
        return this.RestrictedMove.getState();
    }

    public void setDimensions(int w, int h) {
        this.Height.setText("" + h);
        this.Height.setEnabled(false);
        this.Width.setText("" + w);
        this.Width.setEnabled(false);
        this.SaveDimensions = false;
    }
}

