/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.macro.Macro;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class LineConstructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    ConstructionObject O;
    boolean Fix;
    boolean ShowsValue;
    boolean ShowsName;
    boolean Moved;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.checkVisual()) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else {
            this.P2 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P2 != null) {
                if (this.P2 == this.P1) {
                    this.P2 = null;
                    return;
                }
                ConstructionObject o = this.create(zc.getConstruction(), this.P1, this.P2);
                zc.addObject(o);
                o.setDefaults();
                boolean bl = this.Fix = e2.isShiftDown() || this.isFixed();
                if (this.P2.moveable() && !this.P2.isPointOn() && zc.isNewPoint()) {
                    this.Dragging = true;
                    this.Moved = false;
                    this.O = o;
                    this.ShowsValue = o.showValue();
                    this.ShowsName = o.showName();
                    if (this.Fix && Global.getParameter("options.movefixname", true) || !this.Fix && Global.getParameter("options.movename", false)) {
                        o.setShowValue(true);
                        o.setShowName(true);
                    }
                } else {
                    this.Dragging = false;
                    if (this.Fix) {
                        this.setFixed(zc, o);
                    }
                    this.P2 = null;
                    this.P1 = null;
                    zc.clearSelected();
                    this.showStatus(zc);
                }
            } else {
                this.Dragging = false;
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 == null;
    }

    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        this.P2 = this.select(e2.getX(), e2.getY(), zc);
        if (this.P2 != null) {
            ConstructionObject o = this.create(zc.getConstruction(), this.P1, this.P2);
            zc.addObject(o);
            o.setDefaults();
            zc.validate();
            zc.repaint();
            this.P2 = null;
        }
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Moved = true;
        this.P2.move(zc.x(e2.getX()), zc.y(e2.getY()));
        zc.validate();
        zc.repaint();
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.setShowValue(this.ShowsValue);
        this.O.setShowName(this.ShowsName);
        if (this.Fix) {
            this.O.round();
        }
        zc.repaint();
        if (this.Fix && !this.Moved) {
            this.setFixed(zc, this.O);
        }
        this.reset(zc);
    }

    public boolean isFixed() {
        return false;
    }

    public void setFixed(ZirkelCanvas zc, ConstructionObject o) {
    }

    public PointObject select(int x, int y, ZirkelCanvas zc) {
        return zc.selectCreatePoint(x, y);
    }

    public ConstructionObject create(Construction c2, PointObject p1, PointObject p2) {
        return new LineObject(c2, p1, p2);
    }

    public void reset(ZirkelCanvas zc) {
        if (!zc.Visual) {
            zc.setPrompt(this.getPrompt());
        } else {
            zc.clearSelected();
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zc);
        }
    }

    public String getPrompt() {
        return Zirkel.name("prompt.line");
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.line.first", "Line: Set the first point!"));
        } else {
            zc.showStatus(Zirkel.name("message.line.second", "Line: Set the second point!"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Line")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("from") || !tag.hasParam("to")) {
            if (!(c2 instanceof Macro)) {
                throw new ConstructionException("Line points missing!");
            }
            PrimitiveLineObject o = new PrimitiveLineObject(c2);
            this.setName(tag, o);
            this.set(tree, o);
            c2.add(o);
            this.setConditionals(tree, c2, o);
        } else {
            try {
                PointObject p1 = (PointObject)c2.find(tag.getValue("from"));
                PointObject p2 = (PointObject)c2.find(tag.getValue("to"));
                LineObject o = new LineObject(c2, p1, p2);
                if (tag.hasParam("partial")) {
                    o.setPartial(true);
                }
                this.setName(tag, o);
                this.set(tree, o);
                c2.add(o);
                this.setConditionals(tree, c2, o);
            }
            catch (ConstructionException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new ConstructionException("Line points illegal!");
            }
        }
        return true;
    }

    public String getTag() {
        return "Line";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[1]);
        }
        if (!(P1 instanceof PointObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[0]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[1]);
        }
        LineObject s = new LineObject(c2, (PointObject)P1, (PointObject)P2);
        c2.add(s);
        s.setDefaults();
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
    }
}

