/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ImageObject;
import rene.zirkel.objects.PointObject;

public class ImageConstructor
extends ObjectConstructor {
    PointObject[] P;
    int NPoints;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.checkVisual()) {
            return;
        }
        PointObject p = zc.selectCreatePoint(e2.getX(), e2.getY());
        if (p != null) {
            this.P[this.NPoints++] = p;
            p.setSelected(true);
            zc.repaint();
        }
        this.showStatus(zc);
        if (this.NPoints == 3) {
            String filename = zc.loadImage();
            if (filename.equals("")) {
                this.reset(zc);
                return;
            }
            ImageObject o = new ImageObject(zc.getConstruction(), this.P, filename);
            zc.addObject(o);
            zc.clearSelected();
            this.reset(zc);
            zc.repaint();
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.NPoints <= 1) {
            zc.showStatus(ConstructionObject.text1(Zirkel.name("message.image"), "" + (this.NPoints + 1)));
        } else {
            zc.showStatus(Zirkel.name("message.image.last"));
        }
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P = new PointObject[3];
            this.NPoints = 0;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Zirkel.name("prompt.image"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Image")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        int i = 0;
        while (i < 3) {
            if (!tag.hasParam("point" + (i + 1))) {
                throw new ConstructionException("Image points missing!");
            }
            ++i;
        }
        if (!tag.hasParam("filename")) {
            throw new ConstructionException("Image filename missing!");
        }
        try {
            PointObject[] P = new PointObject[3];
            int i2 = 0;
            while (i2 < 3) {
                P[i2] = (PointObject)c2.find(tag.getValue("point" + (i2 + 1)));
                ++i2;
            }
            String filename = tag.getValue("filename");
            ImageObject p = new ImageObject(c2, P, filename);
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Image points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.image");
    }

    public String getTag() {
        return "Image";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
    }
}

