// 12.8. Plik js współdzielonego przez różne strony wątku roboczego do obliczania średniej liczb 

// inicjalizuj tablicę przechowującą porty połączeń
var count = 0;
var connections = new Array();

// inicjalizuj zmienne wzoru na średnią
var average = 0;
var numValues = 0;
var sumValues = 0;

// zdarzenie onconnect współdzielonego wątku roboczego
onconnect = function(msg) {

   // pobierz odwołanie do tego połączenia
   var port = msg.ports[0];

   // zapisz to odwołanie do połączenia dla przyszłych komunikatów
   connections[count] = port;

   // powiększ liczbę połączeń, które mamy
   count += 1;

   // odpowiedz klientowi i inicjalizuj jego średnią
   port.postMessage({msgType:'LOG',msgText:'[WWR] Teraz połączony [' + count + '].'});
   port.postMessage({msgType:'AVE',msgText:'[WWR] Średnia zaktualizowana: ' + average + '.', aveValue:average});

   // utwórz procedurę obsługi dla przypadku otrzymania komunikatu od klienta
   port.onmessage = function(msg) {
      // ustaw wartość przekazaną do współdzielonego wątku roboczego
      var newValue = msg.data;
      // potwierdź otrzymanie wartości
      port.postMessage({msgType:'LOG',msgText:'[WWR] Otrzymano: ' + newValue + '.'});
      // zastąp średnią nową wartością
      updateAverage(newValue);
   }
}

// funkcja pomocnicza do wysyłania wiadomości do wszystkich klientów
function sendAllConnections(msgTypeVal,msgVal) {

   // przejdź w pętli przez klientów i wykonaj postMessage
   for (var i=0; i<count; i++) {

      // wyślij wiadomość do klienta z komunikatem w formacie JSON zawierającym rodzaj wiadomości, tekst i aktualną średnią
      connections[i].postMessage({msgType:msgTypeVal,
                                  msgText:msgVal,
                                  aveValue:average});
  }
}

// prosta funkcja aktualizująca średnią
function updateAverage(newValue) {

   // popraw zmienne wzoru na średnią
   numValues++;
   sumValues += parseFloat(newValue);

   // utwórz nową średnią
   average = Math.round((sumValues / numValues)*100)/100;

   // aktualizuj we wszystkich klientach nową średnią
   sendAllConnections('AVE','[WWR] Średnia zaktualizowana: ' + average + '.');
}
