/*
 * logowanie zdarze uruchamianych przez window.applicationCache
 */

window.applicationCache.onchecking = function(e) {
    log("Sprawdzanie aktualizacji aplikacji");
}

window.applicationCache.onnoupdate = function(e) {
    log("Nie znaleziono aktualizacji aplikacji");
}

window.applicationCache.onupdateready = function(e) {
    log("Aktualizacja aplikacji dostpna");
}

window.applicationCache.onobsolete = function(e) {
    log("Aplikacja przestarzaa");
}

window.applicationCache.ondownloading = function(e) {
    log("Pobieranie aktualizacji aplikacji");
}

window.applicationCache.oncached = function(e) {
    log("Aplikacja zapisana w pamici podrcznej");
}

window.applicationCache.onerror = function(e) {
    log("Bd pamici podrcznej");
}

window.addEventListener("online", function(e) {
    log("Online");
}, true);

window.addEventListener("offline", function(e) {
    log("Offline");
}, true);


/*
 * Zamiana statusw applicationCache na wiadomoci
 */
showCacheStatus = function(n) {
    statusMessages = ["Niewykorzystywana","Bezczynna","Sprawdzanie","Pobieranie","Aktualizacja dostpna","Przestarzaa"];
    return statusMessages[n];
}

install = function() {
    log("Sprawdzanie aktualizacji");
    try {
        window.applicationCache.update();
    } catch (e) {
        applicationCache.onerror();
    }
}

onload = function(e) {
    // Sprawdzanie wymaganych moliwoci przegldarki
    if (!window.applicationCache) {
        log("Aplikacje lokalne nie s wspierane.");
        return;
    }

    if (!navigator.geolocation) {
        log("Geolokalizacja nie jest wspierana.");
        return;
    }

    if (!window.localStorage) {
        log("Magazyn lokalny nie jest wspierany.");
        return;
    }


    log("Pocztkowy status pamici podrcznej: " + showCacheStatus(window.applicationCache.status));
    document.getElementById("installButton").onclick = install;

    // Synchronizacja z serwerem, jeeli poczenie z internetem jest dostpne
    if(navigator.onLine) {
        uploadLocations();
    }
}