jewel.game = (function() {
    var dom = jewel.dom,
        $ = dom.$;

    /* ukrywa aktywny ekran i wywietla ekran 
     * o podanym identyfikatorze. */
    function showScreen(screenId) {
        var activeScreen = $("#game .screen.active")[0],
            screen = $("#" + screenId)[0];
        if (activeScreen) {
            dom.removeClass(activeScreen, "active");
        }
        // Uruchamia modu ekranw. 
        jewel.screens[screenId].run();
        // Wywietla ekran.
        dom.addClass(screen, "active");
    }

    function setup() {
        // Wycza wbudowane zdarzenie przewijania dotykiem. 
        // Zapobiega przewijaniu strony. 
        dom.bind(document, "touchmove", function(event) {
            event.preventDefault();
        });
        // Chowa pasek adresw w Androidzie.
        if (/Android/.test(navigator.userAgent)) {
            $("html")[0].style.height = "200%";
            setTimeout(function() {
                window.scrollTo(0, 1);
            }, 0);
        }
    }
    
    // Wyania metody publiczne.
    return {
        setup : setup,
        showScreen : showScreen
    };
})();
