/* notetoself.js
 * 
 * W tej wersji korzystamy z tablicy i dodaliśmy kolory notatek
 */


window.onload = init;

function init() {
	var button = document.getElementById("add_button");
	button.onclick = createSticky;
/*
	var clearButton = document.getElementById("clear_button");
	clearButton.onclick = clearStickyNotes;
*/

	var stickiesArray = getStickiesArray();
	for (var i = 0; i < stickiesArray.length; i++) {
		var key = stickiesArray[i];
		var value = JSON.parse(localStorage[key]);
		addStickyToDOM(key, value);
	}	
}
function getStickiesArray() {
	var stickiesArray = localStorage.getItem("stickiesArray");
	if (!stickiesArray) {
		stickiesArray = [];
		localStorage.setItem("stickiesArray", JSON.stringify(stickiesArray));
	} else {
		stickiesArray = JSON.parse(stickiesArray);
	}
	return stickiesArray;
}

function createSticky() {
	var stickiesArray = getStickiesArray();
	var value = document.getElementById("note_text").value;
	var colorSelectObj = document.getElementById("note_color");
	var index = colorSelectObj.selectedIndex;
	var color = colorSelectObj[index].value;

	// tworzymy notatkę za pomocą JSON-a, która przechowuje treść i kolor
	var currentDate = new Date();
	var key = "sticky_" + currentDate.getTime();
	var stickyObj = {
			"value": value,
			"color": color
	};
	localStorage.setItem(key, JSON.stringify(stickyObj));

	// dodajemy nową notatkę do tablicy i aktualizujemy tablicę w obiekcie localStorage
	stickiesArray.push(key);
	localStorage.setItem("stickiesArray", JSON.stringify(stickiesArray));
	
	addStickyToDOM(key, stickyObj);
}

function deleteSticky(e) {
	var key = e.target.id;
	if (e.target.tagName.toLowerCase() == "span") {
		key = e.target.parentNode.id;
	}
	var stickiesArray = getStickiesArray();
	if (stickiesArray) {
		for (var i = 0; i < stickiesArray.length; i++) {
			if (key == stickiesArray[i]) {
				stickiesArray.splice(i,1);
			}
		}
		localStorage.removeItem(key);
		localStorage.setItem("stickiesArray", JSON.stringify(stickiesArray));
		removeStickyFromDOM(key);
	}
}

function addStickyToDOM(key, stickyObj) {
	var stickies = document.getElementById("stickies");

	var sticky = document.createElement("li");
	// atrybutowi id przypisujemy klucz, dzięki czemu będzie można znaleźć notatkę wśród
	// identyfikatorów (kluczy) zapisanych w tablicy
	sticky.setAttribute("id", key);
	// stylowi background-color przypisujemy wartość właściwości color obiektu stickyObj
	sticky.style.backgroundColor = stickyObj.color;

	var span = document.createElement("span");
	span.setAttribute("class", "sticky");

	// właściwość value obiektu stickyObj zawiera treść notatki 
	span.innerHTML = stickyObj.value;

	// dodajemy wszystko do struktury DOM
	sticky.appendChild(span);
	stickies.appendChild(sticky);

	// definiujemy funkcję obsługi zdarzenia, tak by po kliknięciu notatka była usuwana
	sticky.onclick = deleteSticky;
}

function removeStickyFromDOM(key) {
	var sticky = document.getElementById(key);
	sticky.parentNode.removeChild(sticky);
}

function clearStickyNotes() {
	localStorage.clear();
	var stickyList = document.getElementById("stickies");
	var stickies = stickyList.childNodes;
	for (var i = stickies.length-1; i >= 0; i--) {
		stickyList.removeChild(stickies[i]);
	}

	// przywraca tablicę notatek
	var stickiesArray = getStickiesArray();
}

