/* addremove.js
 * 
 * 
 */


window.onload = init;

function init() {
	var addButton = document.getElementById("addButton");
	addButton.onclick = addItem;
	var removeButton = document.getElementById("removeButton");
	removeButton.onclick = removeItem;
	var clearButton = document.getElementById("clearButton");
	clearButton.onclick = clearItems;

	for (key in localStorage) {
		addItemToDOM(key, localStorage[key]);
	}	

	// dodajemy zdarzenie obserwujące zmiany w localStorage w innych
	// oknach otwartych z tej samej domeny.
	// UWAGA: nie działa w IE8 i wcześniejszych wersjach. Jest obsługiwane od IE9.
	window.addEventListener("storage", "storageChanged", false);
}

function addItem(e) {
	var key = document.getElementById("key").value;
	var value = document.getElementById("value").value;

	localStorage.setItem(key, value);

	addItemToDOM(key, value);
}

function removeItem(e) {
	var key = document.getElementById("key").value;
	var value = document.getElementById("value").value;
	localStorage.removeItem(key);
	removeItemFromDOM(key);
}

function addItemToDOM(key, value) {
	var items = document.getElementById("items");

	var item = document.createElement("li");
	// atrybutowi id przypisujemy klucz, dzięki czemu będzie można znaleźć notatkę wśród
	// identyfikatorów (kluczy) zapisanych w tablicy
	item.setAttribute("id", key);

	var span = document.createElement("span");
	span.setAttribute("class", "note");

	// właściwość value obiektu noteObj zawiera treść notatki
	//var textNode = document.createTextNode(key + ": " + value);
	span.innerHTML = key + ": " + value;

	// wstawia wszystko do struktury DOM
	//span.appendChild(textNode);
	item.appendChild(span);
	items.appendChild(item);
}

// Dodaj tę funkcję, jeżeli jesteś gotowy na usuwanie elementów
function removeItemFromDOM(key) {
	var item = document.getElementById(key);
	item.parentNode.removeChild(item);
}

// Aby wstawić na *początku* listy:
//stickyList.insertBefore(newSticky, stickyList.firstChild);


function clearItems() {
	localStorage.clear();
	var itemsList = document.getElementById("items");
	var items = itemsList.childNodes;
	for (var i = items.length-1; i >= 0; i--) {
		itemsList.removeChild(items[i]);
	}

}

function storageChanged(e) {
	console.log("Zdarzenie: klucz to " + e.key);
	console.log("Zdarzenie: wartość to " + e.value);
}

