﻿var canvas;
var context;

// Współrzędne ikonki.
var x = 0;
var y = 0;

// Prędkość ikonki (w dwóch wymiarach).
var dx = 0;
var dy = 0;

window.onload = function() {
  // Konfiguruje płótno.
  canvas = document.getElementById("canvas");
  context = canvas.getContext("2d");

  // ** Kod zapisujący współrzędne w magazynie lokalnym. **
  var x = 268;
  var y = 5;
  if (localStorage) {
    var savedX = localStorage["mazeGame_currentX"];
    var savedY = localStorage["mazeGame_currentY"];
    if (savedX != null) x = Number(savedX);
    if (savedY != null) y = Number(savedY);
  }

  // Rysuje labirynt w tle.
  drawMaze("maze.png", x, y);

  // Po wciśnięciu jednego z klawiszy strzełek uruchamia funkcję processKey(). 
  window.onkeydown = processKey;
};

window.onbeforeunload = function(e) {
  if (localStorage) {
    if (confirm("Czy zapisać pozycję ikonki w labiryncie na następną grę?")) {
      localStorage["mazeGame_currentX"] = x;
      localStorage["mazeGame_currentY"] = y;
    }
  }
}

// Śledzi czas, po to aby rysowanie zostało zakończone i ponownie uruchomione 
// wraz z załadowaniem nowego labiryntu. 
var timer;

function drawMaze(mazeFile, startingX, startingY) {
  // Zatrzymuje rysowanie.
  clearTimeout(timer);

  // Zatrzymuje ikonkę (jeśli się porusza).
  dx = 0;
  dy = 0;

  // Ładuje grafikę labiryntu.
  var imgMaze = new Image();
  imgMaze.onload = function() {
    // Dostosowuje wielkość płótna do wymiarów obrazka.
    canvas.width = imgMaze.width;
    canvas.height = imgMaze.height;

    // Rysuje labirynt.
    context.drawImage(imgMaze, 0,0);

    // Rysuje twarz.
    x = startingX;
    y = startingY;

    var imgFace = document.getElementById("face");
    context.drawImage(imgFace, x, y);
    context.stroke();

    // Wywołuje funkcję rysującą z 10 milisekundowym opóźnieniem.
    timer = setTimeout("drawFrame()", 10);
  };
  imgMaze.src = mazeFile;
}


function processKey(e) {
  // Zatrzymuje ikonkę, jeśli ta się porusza. 
  dx = 0;
  dy = 0;

  // Jeśli wciśnięto strzałkę zmienia prędkość, a tym samym kierunek ruchu ikonki 
  // (ignoruje inne klawisze).

  // Naduszono strzałkę w górę - ikona przemieszcza się w górę. 
  if (e.keyCode == 38) {
    dy = -1;
  }

  // Naduszono strzałkę w dół - ikona przemieszcza się w dół. 
  if (e.keyCode == 40) {
    dy = 1;
  }

  // Naduszono strzałkę w lewo - ikona przemieszcza się w lewo. 
  if (e.keyCode == 37) {
    dx = -1;
  }

  // Naduszono strzałkę w prawo - ikona przemieszcza się w prawo. 
  if (e.keyCode == 39) {
    dx = 1;
  }
}

function checkForCollision() {
  // Pobiera piksele z lokalizacji ikonki z drobną poprawką na krawędzie. 
  var imgData = context.getImageData(x-1, y-1, 15+2, 15+2);
  var pixels = imgData.data;

  // Cyklicznie analizuje kolejne piksele.
  for (var i = 0; n = pixels.length, i < n; i += 4) {
    var red = pixels[i];
    var green = pixels[i+1];
    var blue = pixels[i+2];
    var alpha = pixels[i+3];

    // Szuka czarnych ścian (co wskazuje na zderzenie).
    if (red == 0 && green == 0 && blue == 0) {
      return true;
    }
    // Szuka szarych krawędzi (co wskazuje na zderzenie).
    if (red == 169 && green == 169 && blue == 169) {
      return true;
    }
  }
  // Nie stwierdzono zderzenia.
  return false;
}


function drawFrame() {
  // Rysuj klatkę tylko jeśli ikonka się przemieszcza.
  if (dx != 0 || dy != 0) {
    // Czyści poprzednią pozycję ikonki (lecz zostawia ścieżkę, 
    // dzięki czemu powstaje efekt tropu.)
    context.beginPath();
    context.fillStyle = "rgb(254,244,207)";
    context.rect(x, y, 15, 15);
    context.fill()

    // Zmienia lokalizację ikonki.
    x += dx;
    y += dy;

    // Zatrzymuje ikonkę gdy uderzy w ścianę i przywraca jej poprzednie współrzędne.
    if (checkForCollision()) {
      x -= dx;
      y -= dy;
      dx = 0;
      dy = 0;
    }

    // Rysuje ikonę w nowym miejscu.
    var imgFace = document.getElementById("face");
    context.drawImage(imgFace, x, y);

    // Sprawdza czy użytkownik przeszedł przez labirynt (dotarł do dolnej krawędzi).
    // Jeśli tak, przeglądarka wyświetla komunikat i kończy funkcję - kolejne klatki nie będą rysowane. 
    if (y > (canvas.height - 17)) {
      alert("Wygrałeś!");
      return;
    }
  }

  // Rysuje kolejną klatkę po upływie 10 milisekund. 
  timer = setTimeout("drawFrame()", 10);
}

function resetPosition() {
  drawMaze('maze.png', 268, 5);
}