/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.TwoPointLineObject;
import rene.zirkel.structures.Coordinates;

public class RayObject
extends TwoPointLineObject {
    static Count N = new Count();

    public RayObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2, p1, p2);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Ray";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(RayObject.text2(Zirkel.name("text.ray"), this.P1.getName(), this.P2.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X1 = this.P1.getX();
        this.Y1 = this.P1.getY();
        this.X2 = this.P2.getX();
        this.Y2 = this.P2.getY();
        this.DX = this.X2 - this.X1;
        this.DY = this.Y2 - this.Y1;
        this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
        if (this.R < 1.0E-10) {
            this.Valid = false;
            return;
        }
        this.DX /= this.R;
        this.DY /= this.R;
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        String s;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double xm = (zc.minX() + zc.maxX()) / 2.0;
        double ym = (zc.minY() + zc.maxY()) / 2.0;
        double d2 = (xm - this.X1) * this.DY - (ym - this.Y1) * this.DX;
        double x = xm - d2 * this.DY;
        double y = ym + d2 * this.DX;
        double a2 = Math.max(zc.maxX() - zc.minX(), zc.maxY() - zc.minY());
        if (Math.abs(d2) > a2) {
            return;
        }
        double b2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        this.k1 = b2 - a2;
        this.k2 = b2 + a2;
        this.k12valid = true;
        if (this.k1 < 0.0) {
            this.k1 = 0.0;
        }
        if (this.k1 >= this.k2) {
            return;
        }
        if (this.Partial && !zc.showHidden() && this.Dep != null) {
            double dd = (zc.maxX() - zc.minX()) / 20.0;
            double dmin = -dd;
            double dmax = this.R + dd;
            int i = 0;
            while (i < this.NDep) {
                if (this.Dep[i].valid() && !this.Dep[i].mustHide(zc)) {
                    double s2 = this.project(this.Dep[i].getX(), this.Dep[i].getY());
                    if (s2 - dd < dmin) {
                        dmin = s2 - dd;
                    } else if (s2 + dd > dmax) {
                        dmax = s2 + dd;
                    }
                }
                ++i;
            }
            if (this.k1 < dmin) {
                this.k1 = dmin;
            }
            if (this.k2 > dmax) {
                this.k2 = dmax;
            }
        }
        double c1 = zc.col(this.X1 + this.k1 * this.DX);
        double c2 = zc.col(this.X1 + this.k2 * this.DX);
        double r1 = zc.row(this.Y1 + this.k1 * this.DY);
        double r2 = zc.row(this.Y1 + this.k2 * this.DY);
        if (this.isStrongSelected() && g instanceof MyGraphics13) {
            ((MyGraphics13)g).drawMarkerLine(c1, r1, c2, r2);
        }
        g.setColor(this);
        if (this.visible(zc)) {
            g.drawLine(c1, r1, c2, r2, this);
        }
        if (!(s = this.getDisplayText()).equals("")) {
            g.setLabelColor(this);
            this.DisplaysText = true;
            double c3 = -b2 + a2 / 5.0;
            if (c3 < -a2 / 5.0) {
                c3 = -a2 / 5.0;
            } else if (c3 > a2 / 5.0) {
                c3 = a2 / 5.0;
            }
            if (c3 < -b2 + a2 / 10.0) {
                c3 = -b2 + a2 / 10.0;
            }
            if (this.KeepClose) {
                double side = this.YcOffset < 0.0 ? 1 : -1;
                this.drawLabel(g, s, zc, this.X1 + this.XcOffset * (this.X2 - this.X1), this.Y1 + this.XcOffset * (this.Y2 - this.Y1), side * this.DX, side * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(g, s, zc, x + c3 * this.DX, y + c3 * this.DY, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = (x - this.X1) / this.R * this.DX + (y - this.Y1) / this.R * this.DY;
        this.YcOffset = (x - this.X1) / this.R * this.DY - (y - this.Y1) / this.R * this.DX;
    }

    public String getDisplayValue() {
        return "" + this.round(this.R, ZirkelCanvas.LengthsFactor);
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        double s;
        if (!this.displays(zc)) {
            return false;
        }
        double x = zc.x(c2);
        double y = zc.y(r);
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        double o = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        double o1 = (this.X2 - this.X1) * this.DX + (this.Y2 - this.Y1) * this.DY;
        if (o1 > 0.0) {
            if (o < 0.0) {
                d2 = Math.sqrt((x - this.X1) * (x - this.X1) + (y - this.Y1) * (y - this.Y1));
            }
        } else if (o > 0.0) {
            d2 = Math.sqrt((x - this.X1) * (x - this.X1) + (y - this.Y1) * (y - this.Y1));
        }
        if ((s = this.project(x, y)) < this.k1 || s > this.k2) {
            return false;
        }
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX()));
        return this.Value < zc.selectionSize() * 2.0;
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("from", this.P1.getName());
        xml.printArg("to", this.P2.getName());
        super.printArgs(xml);
    }

    public boolean contains(double x, double y) {
        double a2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        return !(a2 < 1.0E-9);
    }

    public double project(double x, double y) {
        double h = super.project(x, y);
        if (h < 0.0) {
            return 0.0;
        }
        return h;
    }

    public boolean equals(ConstructionObject o) {
        if (!(o instanceof RayObject) || !o.valid()) {
            return false;
        }
        RayObject l = (RayObject)o;
        return this.equals(this.X1, l.X1) && this.equals(this.Y1, l.Y1) && this.equals(this.DX, l.DX) && this.equals(this.DY, l.DY);
    }

    public static Coordinates intersect(PrimitiveLineObject l1, PrimitiveLineObject l2) {
        double det = -l1.DX * l2.DY + l1.DY * l2.DX;
        if (Math.abs(det) < 1.0E-10) {
            return null;
        }
        double a2 = (-(l2.X1 - l1.X1) * l2.DY + (l2.Y1 - l1.Y1) * l2.DX) / det;
        return new Coordinates(l1.X1 + a2 * l1.DX, l1.Y1 + a2 * l1.DY);
    }

    public static Coordinates intersect(PrimitiveLineObject l, PrimitiveCircleObject c2) {
        double x = c2.getX();
        double y = c2.getY();
        double r = c2.getR();
        double d2 = (x - l.X1) * l.DY - (y - l.Y1) * l.DX;
        if (Math.abs(d2) > r + 1.0E-10) {
            return null;
        }
        double h = r * r - d2 * d2;
        h = h > 0.0 ? Math.sqrt(h) : 0.0;
        return new Coordinates((x -= d2 * l.DY) + h * l.DX, (y += d2 * l.DX) + h * l.DY, x - h * l.DX, y - h * l.DY);
    }
}

