/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.FileFilter;
import rene.util.SortFile;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;

public class FileList {
    Vector V = new Vector();
    Vector Vdir = new Vector();
    boolean Stop = false;
    boolean Recurse;
    String Dir;
    String Filter;
    boolean UseCase = false;

    public FileList(String dir, String filter, boolean recurse) {
        this.Recurse = recurse;
        this.Dir = dir;
        this.Filter = filter;
        if (this.Dir.equals("-")) {
            this.Dir = ".";
            this.Recurse = false;
        } else if (this.Dir.startsWith("-")) {
            this.Dir = this.Dir.substring(1);
            this.Recurse = false;
        }
    }

    public FileList(String dir, String filter) {
        this(dir, filter, true);
    }

    public FileList(String dir) {
        this(dir, "*", true);
    }

    public void setCase(boolean usecase) {
        this.UseCase = usecase;
    }

    public void search() {
        this.Stop = false;
        File file = new File(this.Dir);
        if (!this.UseCase) {
            this.Filter = this.Filter.toLowerCase();
        }
        if (file.isDirectory()) {
            this.find(file, new FileFilter(this.Filter));
        }
    }

    void find(File dir, FileFilter filter) {
        if (!this.directory(dir)) {
            return;
        }
        String[] list = dir.list();
        int i = 0;
        block0: while (i < list.length) {
            SortFile file = new SortFile(dir, list[i]);
            if (file.isDirectory()) {
                this.Vdir.addElement(file);
                if (this.Recurse) {
                    this.find(file, filter);
                }
            } else {
                String filename = file.getName();
                if (!this.UseCase) {
                    filename = filename.toLowerCase();
                }
                char[] fn = filename.toCharArray();
                int j = 0;
                while (j < filter.filterCount()) {
                    if (this.match(fn, 0, filter.filter(j), 0)) {
                        boolean bl = this.Stop = !this.file(file);
                        if (this.Stop) break block0;
                        this.V.addElement(file);
                    }
                    ++j;
                }
            }
            if (this.Stop) break;
            ++i;
        }
        this.parsed(dir);
    }

    boolean match(char[] filename, int n, char[] filter, int m) {
        if (filter == null) {
            return true;
        }
        if (m >= filter.length) {
            return n >= filename.length;
        }
        if (n >= filename.length) {
            return m == filter.length - 1 && filter[m] == '*';
        }
        if (filter[m] == '?') {
            return this.match(filename, n + 1, filter, m + 1);
        }
        if (filter[m] == '*') {
            if (m == filter.length - 1) {
                return true;
            }
            int i = n;
            while (i < filename.length) {
                if (this.match(filename, i, filter, m + 1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (filter[m] == filename[n]) {
            return this.match(filename, n + 1, filter, m + 1);
        }
        return false;
    }

    public Enumeration files() {
        return this.V.elements();
    }

    public Enumeration dirs() {
        return this.Vdir.elements();
    }

    public int size() {
        return this.V.size();
    }

    public void sort() {
        int n = this.V.size();
        SortObject[] v = new SortObject[n];
        int i = 0;
        while (i < n) {
            v[i] = (SortFile)this.V.elementAt(i);
            ++i;
        }
        Sorter.sort(v);
        i = 0;
        while (i < n) {
            this.V.setElementAt(v[i], i);
            ++i;
        }
        n = this.Vdir.size();
        v = new SortObject[n];
        i = 0;
        while (i < n) {
            v[i] = (SortFile)this.Vdir.elementAt(i);
            ++i;
        }
        Sorter.sort(v);
        i = 0;
        while (i < n) {
            this.Vdir.setElementAt(v[i], i);
            ++i;
        }
    }

    public void sort(int type) {
        SortFile.SortBy = type;
        this.sort();
        SortFile.SortBy = 0;
    }

    protected boolean directory(File dir) {
        return true;
    }

    protected boolean file(File file) {
        return true;
    }

    protected void parsed(File dir) {
    }

    public void stopIt() {
        this.Stop = true;
    }

    public String getDir() {
        File dir = new File(this.Dir);
        try {
            return dir.getCanonicalPath();
        }
        catch (Exception e2) {
            return "Dir does not exist!";
        }
    }
}

