/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.PointObject;

public class SetFixedAngle
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    FixedAngleObject A;
    PointObject P1;
    PointObject P2;
    PointObject P3;

    public SetFixedAngle(ZirkelCanvas zc, FixedAngleObject a2, ObjectConstructor oc) {
        this.A = a2;
        this.OC = oc;
        a2.setSelected(true);
        zc.repaint();
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P1 == null) {
            ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
            if (o == null) {
                return;
            }
            if (o instanceof PointObject) {
                this.P1 = (PointObject)o;
                this.P1.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
            } else if (o instanceof AngleObject || o instanceof FixedAngleObject || o instanceof ExpressionObject) {
                this.A.setFixed(o.getName());
                this.A.setDragable(false);
                this.A.updateText();
                this.reset(zc);
            }
        } else if (this.P2 == null) {
            this.P2 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P2 != null) {
                this.P2.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
            }
        } else {
            this.P3 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P3 == null) {
                return;
            }
            this.A.setFixed("a(" + this.P1.getName() + "," + this.P2.getName() + "," + this.P3.getName() + ")");
            this.reset(zc);
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.setfixedangle.first"));
        } else if (this.P2 == null) {
            zc.showStatus(Zirkel.name("message.setfixedangle.second"));
        } else {
            zc.showStatus(Zirkel.name("message.setfixedangle.third"));
        }
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
        zc.check();
    }

    public boolean useSmartBoard() {
        return this.P2 != null;
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return (o instanceof PointObject || o instanceof AngleObject || o instanceof FixedAngleObject || o instanceof ExpressionObject) && !zc.getConstruction().dependsOn(o, this.A);
    }
}

