/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.macro;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.ConstructionObject;

public class Macro
extends Construction
implements Cloneable {
    public String Name;
    public String[] Prompts;
    public ConstructionObject[] Params;
    public String[] PromptFor = new String[0];
    public String[] PromptName = new String[0];
    public String[] LastParams;
    public boolean[] Fixed;
    boolean Protected = false;
    boolean HideDuplicates = true;

    public Macro(ZirkelCanvas zc, String name, String comment, String[] s) {
        this.Name = name;
        this.Comment = comment;
        this.Prompts = s;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getComment() {
        return this.Comment;
    }

    public String[] getPrompts() {
        return this.Prompts;
    }

    public void setParams(ConstructionObject[] p) {
        this.Params = p;
    }

    public ConstructionObject[] getParams() {
        return this.Params;
    }

    public void initLast() {
        this.LastParams = new String[this.Params.length];
    }

    public void setLast(String name, int i) {
        try {
            this.LastParams[i] = name;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLast(int i) {
        if (this.LastParams != null && this.LastParams[i] != null) {
            return this.LastParams[i];
        }
        return "";
    }

    public void setPromptFor(String[] s) {
        this.PromptFor = s;
        this.PromptName = new String[this.PromptFor.length];
        int i = 0;
        while (i < this.PromptFor.length) {
            this.PromptName[i] = this.PromptFor[i];
            ++i;
        }
    }

    public void setPromptName(int i, String s) {
        this.PromptName[i] = s;
    }

    public boolean promptFor(String s) {
        return this.getPromptFor(s) >= 0;
    }

    public int getPromptFor(String s) {
        int i = 0;
        while (i < this.PromptFor.length) {
            if (this.PromptFor[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getPromptName(String s) {
        int i = 0;
        while (i < this.PromptFor.length) {
            if (this.PromptFor[i].equals(s)) {
                return this.PromptName[i];
            }
            ++i;
        }
        return "";
    }

    public int countPrompts() {
        return this.PromptFor.length;
    }

    public void saveMacro(XmlWriter xml) {
        xml.startTagStart("Macro");
        xml.printArg("Name", this.Name);
        if (!this.HideDuplicates) {
            xml.printArg("showduplicates", "true");
        }
        xml.startTagEndNewLine();
        int i = 0;
        while (i < this.Params.length) {
            xml.startTagStart("Parameter");
            xml.printArg("name", this.Params[i].getName());
            if (this.Fixed != null && this.Fixed[i] && this.LastParams != null && this.LastParams[i] != null) {
                xml.printArg("fixed", this.LastParams[i]);
            }
            xml.startTagEnd();
            xml.print(this.Prompts[i]);
            xml.endTagNewLine("Parameter");
            ++i;
        }
        if (!this.getComment().equals("")) {
            xml.startTagNewLine("Comment");
            xml.printParagraphs(this.getComment(), 60);
            xml.endTagNewLine("Comment");
        }
        xml.startTagNewLine("Objects");
        this.save(xml);
        xml.endTagNewLine("Objects");
        if (this.PromptFor.length > 0) {
            xml.startTagStart("PromptFor");
            i = 0;
            while (i < this.PromptFor.length) {
                xml.printArg("object" + i, this.PromptFor[i]);
                xml.printArg("prompt" + i, this.PromptName[i]);
                ++i;
            }
            xml.finishTagNewLine();
        }
        xml.endTagNewLine("Macro");
    }

    public Macro(ZirkelCanvas zc, XmlTree tree) throws ConstructionException {
        XmlTag tag = tree.getTag();
        if (!tag.name().equals("Macro")) {
            throw new ConstructionException("No macro!");
        }
        if (!tag.hasParam("Name")) {
            throw new ConstructionException("Name missing!");
        }
        this.Name = tag.getValue("Name");
        if (tag.hasParam("showduplicates")) {
            this.HideDuplicates = false;
        }
        Enumeration<XmlTree> e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            XmlTree t = e2.nextElement();
            tag = t.getTag();
            if (tag.name().equals("Objects")) {
                this.readConstruction(t);
                break;
            }
            if (!tag.name().equals("Comment")) continue;
            try {
                this.setComment(t.parseComment());
            }
            catch (Exception ex) {
                throw new ConstructionException("Illegal Comment");
            }
        }
        int ParamCount = 0;
        e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            XmlTree t = e2.nextElement();
            tag = t.getTag();
            if (tag.name().equals("Parameter")) {
                if (!tag.hasParam("name")) {
                    throw new ConstructionException("Parameter name missing!");
                }
                ++ParamCount;
                continue;
            }
            if (!tag.name().equals("PromptFor")) continue;
            if (tag.hasParam("object")) {
                String[] s = new String[]{tag.getValue("object")};
                this.setPromptFor(s);
                if (!tag.hasParam("prompt")) continue;
                this.setPromptName(0, tag.getValue("prompt"));
                continue;
            }
            int n = 0;
            while (tag.hasParam("object" + n)) {
                ++n;
            }
            String[] s = new String[n];
            int i = 0;
            while (i < n) {
                s[i] = tag.getValue("object" + i);
                ++i;
            }
            this.setPromptFor(s);
            i = 0;
            while (i < n) {
                if (tag.hasParam("prompt" + i)) {
                    this.setPromptName(i, tag.getValue("prompt" + i));
                }
                ++i;
            }
        }
        this.Params = new ConstructionObject[ParamCount];
        this.initLast();
        this.Prompts = new String[ParamCount];
        int pr = 0;
        while (pr < ParamCount) {
            this.Prompts[pr] = "";
            ++pr;
        }
        int i = 0;
        e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            XmlTree t = e2.nextElement();
            tag = t.getTag();
            if (!tag.name().equals("Parameter")) continue;
            this.Params[i] = this.find(tag.getValue("name"));
            if (this.Params[i] == null) {
                throw new ConstructionException("Illegal parameter " + tag.getValue("name") + "!");
            }
            if (tag.hasParam("fixed")) {
                if (this.Fixed == null) {
                    this.Fixed = new boolean[ParamCount];
                    int j = 0;
                    while (j < ParamCount) {
                        this.Fixed[j] = false;
                        ++j;
                    }
                }
                this.Fixed[i] = true;
                this.LastParams[i] = tag.getValue("fixed");
            }
            Enumeration<XmlTree> en = t.getContent();
            while (en.hasMoreElements()) {
                tree = en.nextElement();
                if (!(tree.getTag() instanceof XmlTagText)) continue;
                this.Prompts[i] = ((XmlTagText)tree.getTag()).getContent();
            }
            ++i;
        }
    }

    public Vector getTargets() {
        Vector<ConstructionObject> v = new Vector<ConstructionObject>();
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isTarget()) continue;
            v.addElement(o);
        }
        return v;
    }

    public boolean hasFixed() {
        int i = 0;
        while (i < this.Prompts.length) {
            if (this.Prompts[i].startsWith("=")) {
                return true;
            }
            ++i;
        }
        if (this.Fixed == null) {
            return false;
        }
        i = 0;
        while (i < this.Fixed.length) {
            if (this.Fixed[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFixed(int i) {
        if (this.Fixed == null) {
            return false;
        }
        return this.Fixed[i];
    }

    public void setFixed(int i, boolean f2) {
        if (this.Fixed == null) {
            return;
        }
        this.Fixed[i] = f2;
    }

    public boolean canIterate() {
        int count = 0;
        int j = 0;
        int i = 0;
        while (i < this.Params.length) {
            if (!this.isFixed(i) && !this.Prompts[i].startsWith("=")) {
                ++count;
                j = i;
            }
            ++i;
        }
        if (count != 1) {
            return false;
        }
        Iterator iterator = this.V.iterator();
        if (iterator.hasNext()) {
            ConstructionObject o = (ConstructionObject)iterator.next();
            if (!o.isTarget() || o.canBeReplacedBy(this.Params[j])) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public int getIterationParam() {
        boolean count = false;
        int i = 0;
        while (i < this.Params.length) {
            if (!this.isFixed(i) && !this.Prompts[i].startsWith("=")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.Protected;
    }

    public void setProtected(boolean flag) {
        this.Protected = flag;
    }

    public boolean hideDuplicates() {
        return this.HideDuplicates;
    }

    public void hideDuplicates(boolean flag) {
        this.HideDuplicates = flag;
    }
}

