/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import rene.zirkel.graphics.EpsFontMetrics;
import rene.zirkel.graphics.EpsPoint;

public class EPSGraphics {
    private Color _currentColor = Color.black;
    private Font _currentFont;
    private double _width;
    private double _height;
    int _orientation;
    private Hashtable _linepattern = new Hashtable();
    private OutputStream _out;
    private StringBuffer _buffer = new StringBuffer();
    private Clipboard _clipboard;
    private double LineWidth = 1.0;
    private static String[] _patterns = new String[]{"[]", "[1 1]", "[4 4]", "[4 4 1 4]", "[2 2]", "[4 2 1 2 1 2]", "[5 3 2 3]", "[3 3]", "[4 2 1 2 2 2]", "[1 2 5 2 1 2 1 2]", "[4 1 2 1]"};
    private int _patternIndex = 0;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private FontMetrics FM;

    public EPSGraphics(OutputStream out, double width, double height, int orientation, boolean clip) {
        this._width = width;
        this._height = height;
        this._orientation = orientation;
        this._out = out;
        this._buffer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this._buffer.append("%%Creator: QCircuitBuilder\n");
        this._buffer.append("%%BoundingBox: 50 50 " + (int)(50.0 + width) + " " + (int)(50.0 + height) + "\n");
        this._buffer.append("%%Pages: 1\n");
        this._buffer.append("%%Page: 1 1\n");
        this._buffer.append("%%LanguageLevel: 2\n");
        if (clip) {
            this.clipRect(0.0, 0.0, width, height);
        }
        this._buffer.append("/Helvetica findfont 10 scalefont setfont\n");
    }

    public void clearRect(int x, int y, int width, int height) {
    }

    public void clipRect(double x, double y, double width, double height) {
        EpsPoint start = this._convert(x, y);
        this._buffer.append("newpath " + this.round(start.x) + " " + this.round(start.y) + " moveto\n");
        this._buffer.append("0 " + this.round(-height) + " rlineto\n");
        this._buffer.append(this.round(width) + " 0 rlineto\n");
        this._buffer.append("0 " + this.round(height) + " rlineto\n");
        this._buffer.append(this.round(-width) + " 0 rlineto\n");
        this._buffer.append("closepath clip\n");
    }

    private double round(double x) {
        return (double)Math.round(x * 1000.0) / 1000.0;
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        EpsPoint start = this._convert(x1, y1);
        EpsPoint end = this._convert(x2, y2);
        this._buffer.append("newpath " + this.round(start.x) + " " + this.round(start.y) + " moveto\n");
        this._buffer.append(this.round(end.x) + " " + this.round(end.y) + " lineto\n");
        this._buffer.append("stroke\n");
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (!this._polygon(xPoints, yPoints, nPoints)) {
            return;
        }
        this._buffer.append("closepath stroke\n");
    }

    public void drawOval(double x, double y, double width, double height) {
        double radius = width / 2.0;
        this._buffer.append("newpath " + this._convertX(x + radius) + " " + this._convertY(y + radius) + " " + this.round(radius) + " 0 360 arc closepath stroke\n");
    }

    public void drawRect(double x, double y, double width, double height) {
        EpsPoint start = this._convert(x, y);
        this._buffer.append("newpath " + this.round(start.x) + " " + this.round(start.y) + " moveto\n");
        this._buffer.append("0 " + this.round(-height) + " rlineto\n");
        this._buffer.append(this.round(width) + " 0 rlineto\n");
        this._buffer.append("0 " + this.round(height) + " rlineto\n");
        this._buffer.append(this.round(-width) + " 0 rlineto\n");
        this._buffer.append("closepath stroke\n");
    }

    public void drawRoundRect(double x, double y, double width, double height, int arcWidth, int arcHeight) {
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    public void drawString(String str, double x, double y) {
        FontMetrics fm = this.getFontMetrics();
        EpsPoint start = this._convert(x, y);
        this._buffer.append(start.x + " " + start.y + " moveto\n");
        this._buffer.append("(" + str + ") show\n");
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        double radius = width / 2.0;
        this._buffer.append("newpath " + this._convertX(x + radius) + " " + this._convertY(y + radius) + " " + this.round(radius) + " " + this.round(startAngle) + " " + " " + this.round(startAngle + arcAngle) + " arc stroke\n");
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        double radius = width / 2.0;
        this._buffer.append("newpath " + this._convertX(x + radius) + " " + this._convertY(y + radius) + " " + " moveto " + this._convertX(x + radius) + " " + this._convertY(y + radius) + " " + radius + " " + this.round(startAngle) + " " + this.round(startAngle + arcAngle) + " arc closepath fill\n");
    }

    public void fillChord(double x, double y, double width, double height, double startAngle, double arcAngle) {
        double radius = width / 2.0;
        this._buffer.append("newpath " + this._convertX(x + radius) + " " + this._convertY(y + radius) + " " + this.round(radius) + " " + this.round(startAngle) + " " + this.round(startAngle + arcAngle) + " arc fill\n");
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (!this._polygon(xPoints, yPoints, nPoints)) {
            return;
        }
        this._buffer.append("closepath fill\n");
    }

    public void fillOval(double x, double y, double width, double height) {
        double radius = width / 2.0;
        this._buffer.append("newpath " + this._convertX(x + radius) + " " + this._convertY(y + radius) + " " + radius + " 0 360 arc closepath fill\n");
    }

    public void fillRect(double x, double y, double width, double height) {
        EpsPoint start = this._convert(x, y);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append("0 " + this.round(-height) + " rlineto\n");
        this._buffer.append(this.round(width) + " 0 rlineto\n");
        this._buffer.append("0 " + this.round(height) + " rlineto\n");
        this._buffer.append(this.round(-width) + " 0 rlineto\n");
        this._buffer.append("closepath gsave fill grestore\n");
        this._buffer.append("0.5 setlinewidth 0 setgray [] 0 setdash stroke\n");
        this._buffer.append(String.valueOf(this.round(this.LineWidth)) + " setlinewidth\n");
    }

    public void fillRoundRect(double x, double y, double width, double height, int arcWidth, int arcHeight) {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public Color getColor() {
        return this._currentColor;
    }

    public Font getFont() {
        return this._currentFont;
    }

    public FontMetrics getFontMetrics(Font f2) {
        if (this.FM == null) {
            this.FM = new EpsFontMetrics(new Font("dialog", 0, 20));
        }
        return this.FM;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this._currentFont);
    }

    public void setFont(Font font) {
        int size = font.getSize();
        boolean bold = font.isBold();
        if (bold) {
            this._buffer.append("/Helvetica-Bold findfont\n");
        } else {
            this._buffer.append("/Helvetica findfont\n");
        }
        this._buffer.append(size + " scalefont setfont\n");
        this._currentFont = font;
        this.FM = new EpsFontMetrics(font);
    }

    public void setClip(Shape clip) {
    }

    public void setClip(int x, int y, int width, int height) {
    }

    public void setColor(Color c2) {
        this._buffer.append((double)c2.getRed() / 255.0);
        this._buffer.append(" ");
        this._buffer.append((double)c2.getGreen() / 255.0);
        this._buffer.append(" ");
        this._buffer.append((double)c2.getBlue() / 255.0);
        this._buffer.append(" setrgbcolor\n");
        this._currentColor = c2;
    }

    public void setLineWidth(double w) {
        this._buffer.append(String.valueOf(this.round(w)) + " setlinewidth\n");
        this.LineWidth = w;
    }

    public void setDash(double a2, double b2) {
        this._buffer.append("[" + this.round(a2) + " " + this.round(b2) + " ] 0 setdash\n");
    }

    public void clearDash() {
        this._buffer.append("[ ] 0 setdash\n");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void showpage(String name) {
        try {
            this._buffer.append("%%EOF");
            PrintWriter output = new PrintWriter(new FileWriter(name));
            output.println(this._buffer.toString());
            output.flush();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void close() throws IOException {
        this._buffer.append("showpage\n");
        this._buffer.append("%%EOF");
        PrintWriter output = new PrintWriter(this._out);
        output.println(this._buffer.toString());
        output.flush();
    }

    private EpsPoint _convert(double x, double y) {
        return new EpsPoint(this.round(x + 50.0), this.round(this._height + 50.0 - y));
    }

    private double _convertX(double x) {
        return this.round(x + 50.0);
    }

    private double _convertY(double y) {
        return this.round(this._height + 50.0 - y);
    }

    private boolean _polygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints < 3 || xPoints.length < nPoints || yPoints.length < nPoints) {
            return false;
        }
        EpsPoint start = this._convert(xPoints[0], yPoints[0]);
        this._buffer.append("newpath " + this.round(start.x) + " " + this.round(start.y) + " moveto\n");
        int i = 1;
        while (i < nPoints) {
            EpsPoint vertex = this._convert(xPoints[i], yPoints[i]);
            this._buffer.append(this.round(vertex.x) + " " + this.round(vertex.y) + " lineto\n");
            ++i;
        }
        return true;
    }

    private void _fillPattern() {
        int red = this._currentColor.getRed();
        int green = this._currentColor.getGreen();
        int blue = this._currentColor.getBlue();
        double bluescale = 0.6;
        double redscale = 0.8;
        double greenscale = 1.0;
        double fullscale = Math.sqrt(65025.0 * (bluescale * bluescale + redscale * redscale + greenscale * greenscale));
        double graylevel = Math.sqrt((double)(red * red) * redscale * redscale + (double)(blue * blue) * bluescale * bluescale + (double)(green * green) * greenscale * greenscale) / fullscale;
        this._buffer.append(graylevel + " setgray\n");
        this._buffer.append("rgb: " + red + " " + green + " " + blue + "\n");
    }
}

