/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import rene.gui.CloseFrame;
import rene.gui.Global;
import rene.gui.Panel3D;
import rene.util.MyVector;
import rene.viewer.TextDisplay;
import rene.viewer.TextPosition;
import rene.viewer.Viewer;
import rene.viewer.Wheel;
import rene.viewer.WheelListener;

public class ExtendedViewer
extends Viewer
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener,
WheelListener {
    TextDisplay TD = new TextDisplay(this);
    Scrollbar Vertical;
    TextPosition Start;
    TextPosition End;
    PopupMenu PM;
    int X;
    int Y;
    Panel P3D;
    MyVector V;
    StringBuffer B;
    boolean Changed = false;
    boolean Dragging = false;

    public ExtendedViewer() {
        this.setLayout(new BorderLayout());
        this.P3D = new Panel3D(this.TD);
        this.add("Center", this.P3D);
        this.Vertical = new Scrollbar(1, 0, 100, 0, 1100);
        this.add("East", this.Vertical);
        this.Vertical.addAdjustmentListener(this);
        this.TD.addMouseListener(this);
        this.TD.addMouseMotionListener(this);
        this.End = null;
        this.Start = null;
        this.PM = new PopupMenu();
        MenuItem mi = new MenuItem(Global.name("block.copy", "Copy"));
        mi.addActionListener(this);
        this.PM.add(mi);
        this.PM.addSeparator();
        mi = new MenuItem(Global.name("block.begin", "Begin Block"));
        mi.addActionListener(this);
        this.PM.add(mi);
        mi = new MenuItem(Global.name("block.end", "End Block"));
        mi.addActionListener(this);
        this.PM.add(mi);
        this.add(this.PM);
        Wheel W = new Wheel(this);
        this.addMouseWheelListener(W);
        this.V = new MyVector();
        this.B = new StringBuffer();
    }

    public void setFont(Font f2) {
        this.TD.init(f2);
    }

    public void appendLine(String s) {
        this.B.append(s);
        this.V.addElement(this.B.toString());
        this.B.setLength(0);
        this.Changed = true;
    }

    public void newLine() {
        this.V.addElement(this.B.toString());
        this.B.setLength(0);
        this.Changed = true;
    }

    public void appendLine(String s, Color c2) {
        this.appendLine(s);
    }

    public void append(String s) {
        this.B.append(s);
    }

    public void append(String s, Color c2) {
        this.append(s);
    }

    public void doUpdate(boolean showlast) {
    }

    public void update() {
        this.resized();
        this.showFirst();
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        if (e2.getSource() == this.Vertical) {
            switch (e2.getAdjustmentType()) {
                case 1: {
                    this.TD.verticalUp();
                    break;
                }
                case 2: {
                    this.TD.verticalDown();
                    break;
                }
                case 4: {
                    this.TD.verticalPageUp();
                    break;
                }
                case 3: {
                    this.TD.verticalPageDown();
                    break;
                }
                default: {
                    int v = this.Vertical.getValue();
                    this.Vertical.setValue(v);
                    this.TD.setVertical(v);
                    return;
                }
            }
            this.setVerticalScrollbar();
        }
    }

    public void setVerticalScrollbar() {
        if (this.Vertical == null) {
            return;
        }
        int h = this.TD.computeVerticalSize();
        this.Vertical.setValues(this.TD.computeVertical(), h, 0, 1000 + h);
    }

    public void setText(String S) {
        this.TD.unmark();
        this.End = null;
        this.Start = null;
        this.TD.setText(S);
        this.V.removeAllElements();
        this.B.setLength(0);
        this.setVerticalScrollbar();
    }

    public void save(PrintWriter fo) {
        this.TD.save(fo);
    }

    public void appendLine0(String s) {
        this.appendLine(s);
    }

    public void appendLine0(String s, Color c2) {
        this.appendLine(s);
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger() || e2.isMetaDown()) {
            this.PM.show(e2.getComponent(), e2.getX(), e2.getY());
            this.X = e2.getX();
            this.Y = e2.getY();
        } else {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(e2.getX(), e2.getY());
            this.Start.oneleft();
            this.End = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 200);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 200);
    }

    public void mouseReleased(MouseEvent e2) {
        this.Dragging = false;
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void mouseDragged(MouseEvent e2) {
        this.TD.unmark(this.Start, this.End);
        TextPosition h = this.TD.getposition(e2.getX(), e2.getY());
        if (h != null) {
            this.End = h;
        }
        this.TD.mark(this.Start, this.End);
    }

    public void actionPerformed(ActionEvent e2) {
        String o = e2.getActionCommand();
        if (o.equals(Global.name("block.copy", "Copy"))) {
            this.TD.copy(this.Start, this.End);
        } else if (o.equals(Global.name("block.begin", "Begin Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(this.X, this.Y);
            this.Start.oneleft();
            if (this.End == null && this.TD.L.last() != null) {
                this.End = this.TD.lastpos();
            }
            this.TD.mark(this.Start, this.End);
        } else if (o.equals(Global.name("block.end", "End Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.End = this.TD.getposition(this.X, this.Y);
            if (this.Start == null && this.TD.L.first() != null) {
                this.Start = new TextPosition(this.TD.L.first(), 0, 0);
            }
            this.TD.mark(this.Start, this.End);
        }
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        if (e2.isControlDown() && e2.getKeyCode() == 67 && this.Start != null && this.End != null) {
            this.TD.copy(this.Start, this.End);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void setTabWidth(int t) {
        this.TD.setTabWidth(t);
    }

    public void showFirst() {
        this.TD.showFirst();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public void showLast() {
        this.TD.showlast();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public boolean hasFocus() {
        return false;
    }

    public void setBackground(Color c2) {
        this.TD.setBackground(c2);
        this.P3D.setBackground(c2);
        super.setBackground(c2);
    }

    public void up(int n) {
        int i = 0;
        while (i < n) {
            this.TD.verticalUp();
            ++i;
        }
        this.setVerticalScrollbar();
    }

    public void down(int n) {
        int i = 0;
        while (i < n) {
            this.TD.verticalDown();
            ++i;
        }
        this.setVerticalScrollbar();
    }

    public void pageUp() {
        this.TD.verticalPageUp();
        this.setVerticalScrollbar();
    }

    public void pageDown() {
        this.TD.verticalPageDown();
        this.setVerticalScrollbar();
    }

    public void paint(Graphics G) {
        super.paint(G);
    }

    public void doAppend(String s) {
        char[] a2 = s.toCharArray();
        int[] w = this.TD.getwidth(a2);
        int start = 0;
        int end = 0;
        int W = this.TD.getSize().width;
        while (start < a2.length && a2[start] == ' ') {
            ++start;
        }
        if (start >= a2.length) {
            this.TD.appendLine("");
            return;
        }
        int blanks = 0;
        String sblanks = "";
        int offset = 0;
        if (start > 0) {
            blanks = start;
            sblanks = new String(a2, 0, blanks);
            offset = blanks + w[0];
        }
        while (start < a2.length) {
            int tw = this.TD.Offset + offset;
            end = start;
            int goodbreak = start;
            while (end < a2.length && tw < W) {
                tw += w[end];
                if (a2[end] == ' ') {
                    goodbreak = end;
                }
                ++end;
            }
            if (tw < W) {
                goodbreak = end;
            }
            if (goodbreak == start) {
                goodbreak = end;
            }
            if (blanks > 0) {
                this.TD.appendLine(String.valueOf(sblanks) + new String(a2, start, goodbreak - start));
            } else {
                this.TD.appendLine(new String(a2, start, goodbreak - start));
            }
            start = goodbreak;
            while (start < a2.length && a2[start] == ' ') {
                ++start;
            }
        }
    }

    public synchronized void resized() {
        if (this.TD.getSize().width <= 0) {
            return;
        }
        this.TD.setText("");
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            String s = (String)e2.nextElement();
            this.doAppend(s);
        }
        this.TD.repaint();
    }

    public static void main(String[] args) {
        CloseFrame f2 = new CloseFrame();
        f2.setLayout(new BorderLayout());
        ExtendedViewer v = new ExtendedViewer();
        f2.add("Center", v);
        f2.setSize(300, 300);
        f2.setVisible(true);
        v.append("test1 test test test test test test ");
        v.append("Donaudampfschifffahrtsgesellschaftskapit\u00e4n ");
        v.append("test2 test test test test test test ");
        v.append("test3 test test test test test test ");
        v.append("test4 test test test test test test ");
        v.append("test5 test test test test test test ");
        v.append("test6 test test test test test test ");
        v.append("test7 test test test test test test ");
        v.append("test8 test test test test test test ");
        v.appendLine("");
        v.appendLine("");
        v.appendLine("  affe affe affe affe affe affe affe test test test test test last");
        v.appendLine("");
        v.appendLine("test affe affe affe test test test test test last ");
        v.appendLine("  ");
        v.appendLine("test test test test affe affe affe test test last");
        v.repaint();
        v.resized();
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
    }
}

