/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarElement;
import rene.gui.SaveColor;

class BasicIcon
extends Panel
implements MouseListener,
IconBarElement,
Runnable {
    IconBar Bar;
    String Name;
    boolean Enabled;
    boolean On;
    boolean Focus = false;
    public static int Size = 22;
    boolean MouseOver;
    boolean MouseDown;
    boolean Unset;
    Thread T;
    boolean Control;

    public BasicIcon(IconBar bar, String name) {
        this.Bar = bar;
        this.Name = name;
        this.Enabled = true;
        this.On = false;
        this.addMouseListener(this);
        this.enableEvents(8L);
        this.setSize(Size, Size);
    }

    public void processKeyEvent(KeyEvent e2) {
        this.Bar.getKey(e2);
    }

    public void paint(Graphics g) {
        Color c2;
        if (this.MouseDown) {
            g.setColor(this.getBackground());
            g.fill3DRect(0, 0, Size, Size, false);
        } else if (this.MouseOver) {
            if (this.On) {
                c2 = this.getBackground();
                g.setColor(new SaveColor(c2.getRed() - 30, c2.getGreen() - 30, c2.getBlue()));
            } else {
                g.setColor(this.getBackground());
            }
            g.fill3DRect(0, 0, Size, Size, true);
        } else if (this.On) {
            c2 = this.getBackground();
            g.setColor(c2);
            g.fillRect(0, 0, Size, Size);
            g.setColor(new SaveColor(c2.getRed() - 100, c2.getGreen() - 100, c2.getBlue()));
            g.fillRect(3, 3, Size - 2, Size - 2);
            g.setColor(new SaveColor(c2.getRed() - 50, c2.getGreen() - 50, c2.getBlue()));
            g.fillRect(1, 1, Size - 2, Size - 2);
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, Size, Size);
        }
        this.dopaint(g);
        if (this.Unset) {
            c2 = this.getBackground();
            g.setColor(new SaveColor(c2.getRed() - 100, c2.getGreen(), c2.getBlue()));
            g.drawLine(0, 0, Size, Size);
        }
        if (this.Focus) {
            this.showFocus(g);
        }
    }

    public void showFocus(Graphics g) {
        g.setColor(Color.white);
        g.drawRect(4, 4, 1, 1);
        g.drawRect(Size - 5, 4, 1, 1);
        g.drawRect(4, Size - 5, 1, 1);
        g.drawRect(Size - 5, Size - 5, 1, 1);
    }

    public void dopaint(Graphics g) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mousePressed(MouseEvent e2) {
        if (!this.Enabled) {
            return;
        }
        this.MouseDown = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e2) {
        if (!this.Enabled) {
            return;
        }
        this.MouseDown = false;
        Dimension d2 = this.getSize();
        if (e2.getX() < 0 || e2.getX() > d2.width || e2.getY() < 0 || e2.getY() > d2.height) {
            this.repaint();
            return;
        }
        this.Unset = false;
        this.pressed(e2);
        this.repaint();
        this.T = null;
        long time = System.currentTimeMillis();
        this.Bar.iconPressed(this.Name, e2.isShiftDown(), e2.isControlDown());
        time = System.currentTimeMillis() - time;
        if (this.MouseOver && time > 1000L) {
            this.MouseOver = false;
            this.repaint();
        }
    }

    public void pressed(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public synchronized void mouseEntered(MouseEvent e2) {
        if (this.T != null) {
            return;
        }
        if (this.Enabled) {
            this.MouseOver = true;
        }
        this.repaint();
        if (!Global.getParameter("iconbar.showtips", true)) {
            return;
        }
        this.Control = e2.isControlDown();
        this.T = new Thread(this);
        this.T.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.T != null) {
            BasicIcon basicIcon = this;
            synchronized (basicIcon) {
                try {
                    String hc;
                    Point P = this.getLocationOnScreen();
                    String help = Global.name("iconhelp." + this.Name, "");
                    if (help.equals("") && this.Name.length() > 1) {
                        help = Global.name("iconhelp." + this.Name.substring(0, this.Name.length() - 1) + "?", "");
                    }
                    if (help.equals("")) {
                        help = this.Bar.getHelp(this.Name);
                    }
                    if (help.equals("")) {
                        help = Global.name("iconhelp.nohelp", "No help available");
                    }
                    if (this.Control && !(hc = Global.name("iconhelp.control." + this.Name, "")).equals("")) {
                        help = hc;
                    }
                    this.Bar.displayHelp(this, help);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.T != null) {
                this.Bar.removeHelp();
            }
            this.T = null;
        }
    }

    public synchronized void mouseExited(MouseEvent e2) {
        this.T = null;
        this.MouseOver = false;
        this.repaint();
        this.Bar.removeHelp();
    }

    public int width() {
        return Size;
    }

    public void setPosition(int x, int y) {
        this.setLocation(x, y);
    }

    public Point getPosition() {
        return this.getLocationOnScreen();
    }

    public void setEnabled(boolean flag) {
        if (this.Enabled == flag) {
            return;
        }
        this.Enabled = flag;
        this.repaint();
    }

    public String getName() {
        return this.Name;
    }

    public boolean hasFocus() {
        return this.Focus;
    }

    public void setFocus(boolean flag) {
        this.Focus = flag;
        this.repaint();
    }

    public boolean isSet() {
        return !this.Unset;
    }

    public void unset(boolean flag) {
        this.Unset = flag;
        this.repaint();
    }

    public void unset() {
        this.unset(true);
        this.repaint();
    }

    public void setOn(boolean flag) {
        this.On = flag;
        this.repaint();
    }
}

