/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Properties;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.help.Help;

public class Zirkel
extends Applet
implements ActionListener {
    public static final long Version = 110L;
    public static boolean IsApplet = false;

    public static String name(String tag, String def) {
        return Global.name(tag, def);
    }

    public static String name(String tag) {
        return Global.name(tag);
    }

    public void init() {
        String s = this.getParameter("Language");
        if (s != null) {
            Locale.setDefault(new Locale(s, ""));
        }
        Global.initBundle("rene/zirkel/docs/ZirkelProperties");
        this.setLayout(new BorderLayout());
        Button StartButton = new Button("Start");
        this.add("Center", StartButton);
        StartButton.addActionListener(this);
        IsApplet = true;
        Global.setParameter("iconpath", "/rene/zirkel/icons/");
        Global.setParameter("icontype", "png");
        if (this.getParameter("smallicons") != null) {
            Global.setParameter("iconsize", 24);
        } else {
            Global.setParameter("iconsize", 32);
        }
    }

    public static void main(String[] args) {
        String oldversion;
        int i = 0;
        String filename = "";
        boolean simple = false;
        boolean restricted = false;
        String Home = null;
        if (Global.getJavaVersion() < 1.4) {
            Frame f2 = new Frame();
            Warning w = new Warning(f2, "Please update to Java 1.4!", "Warning");
            w.center();
            w.setVisible(true);
            System.exit(0);
        }
        while (i < args.length) {
            if (args[i].startsWith("-l") && i < args.length - 1) {
                Locale.setDefault(new Locale(args[i + 1], ""));
                i += 2;
                continue;
            }
            if (args[i].startsWith("-h") && i < args.length - 1) {
                Home = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].startsWith("-s")) {
                simple = true;
                ++i;
                continue;
            }
            if (args[i].startsWith("-r")) {
                restricted = true;
                ++i;
                continue;
            }
            if (args[i].startsWith("-d")) {
                Properties p = System.getProperties();
                try {
                    PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(p.getProperty("user.home")) + p.getProperty("file.separator") + "zirkel.log"));
                    System.setErr(out);
                    System.setOut(out);
                }
                catch (Exception e2) {
                    System.out.println("Could not open log file!");
                }
                ++i;
                continue;
            }
            filename = args[i];
            ++i;
        }
        if (new File(".zir.cfg").exists()) {
            Global.loadProperties(".zir.cfg");
        } else if (Home != null) {
            Global.loadProperties(Home, ".zir.cfg");
        } else {
            Global.loadPropertiesInHome(".zir.cfg");
        }
        Global.initBundle("rene/zirkel/docs/ZirkelProperties", true);
        if (simple) {
            Global.setParameter("simplegraphics", simple);
        }
        if (restricted) {
            Global.setParameter("restricted", true);
        }
        if (!(oldversion = Global.getParameter("program.version", "1")).equals(Zirkel.name("program.version"))) {
            Global.setParameter("program.newversion", true);
            Global.setParameter("icons", " new load save back undo delete color type thickness hidden showcolor macro grid comment replay point line segment ray circle fixedcircle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide expression area text quadric runmacro edit animate  info zoom draw function rename ticks ");
            if (Global.getVersion() < 8.0) {
                Global.removeAllParameters("minpointsize");
                Global.removeAllParameters("minfontsize");
                Global.removeAllParameters("minlinesize");
                Global.removeAllParameters("arrowsize");
                Global.removeAllParameters("selectionsize");
            }
            Global.setParameter("program.version", Zirkel.name("program.version"));
        }
        Global.setParameter("iconpath", "/rene/zirkel/icons/");
        Global.setParameter("icontype", "png");
        if (Global.getParameter("options.smallicons", false)) {
            Global.setParameter("iconsize", 24);
        } else {
            Global.setParameter("iconsize", 32);
        }
        Help.CodePage = Global.name("codepage.help", "");
        ZirkelFrame f3 = new ZirkelFrame(false);
        if (!filename.equals("")) {
            f3.load(filename);
        }
        if (!Global.haveParameter("options.germanpoints") && Locale.getDefault().getLanguage().equals("de")) {
            Global.setParameter("options.germanpoints", true);
        }
        if (!Global.haveParameter("options.update.ticks") && Global.haveParameter("icons")) {
            Global.setParameter("options.update.ticks", true);
            String s = String.valueOf(Global.getParameter("icons", "")) + "ticks ";
            Global.setParameter("icons", s);
        }
    }

    public void actionPerformed(ActionEvent e2) {
        ZirkelFrame F = new ZirkelFrame(true);
        F.setVisible(true);
    }
}

