/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.constructors.ObjectConstructor;

public class ZoomerTool
extends ObjectConstructor {
    boolean Dragging = false;
    boolean Zoom = false;
    double X;
    double Y;
    double W;
    double X0;
    double Y0;
    ObjectConstructor OC;

    public ZoomerTool() {
    }

    public ZoomerTool(ObjectConstructor oc, MouseEvent e2, ZirkelCanvas zc) {
        this.OC = oc;
        this.X0 = zc.x(e2.getX());
        this.Y0 = zc.y(e2.getY());
        Construction c2 = zc.getConstruction();
        this.X = c2.getX();
        this.Y = c2.getY();
        this.W = c2.getW();
        this.Zoom = false;
        zc.setCursor(new Cursor(13));
        this.Dragging = true;
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        this.X0 = zc.x(e2.getX());
        this.Y0 = zc.y(e2.getY());
        Construction c2 = zc.getConstruction();
        this.X = c2.getX();
        this.Y = c2.getY();
        this.W = c2.getW();
        boolean bl = this.Zoom = Math.abs(this.X - this.X0) > this.W / 4.0 || Math.abs(this.Y - this.Y0) > this.W / 4.0;
        if (!this.Zoom) {
            zc.setCursor(new Cursor(13));
        }
        this.Dragging = true;
        this.OC = null;
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        Construction c2 = zc.getConstruction();
        c2.setXYW(this.X, this.Y, this.W);
        zc.recompute();
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        if (this.Zoom) {
            c2.setXYW(this.X, this.Y, Math.sqrt((this.X0 - this.X) * (this.X0 - this.X) + (this.Y0 - this.Y) * (this.Y0 - this.Y)) / Math.sqrt((x - this.X) * (x - this.X) + (y - this.Y) * (y - this.Y)) * this.W);
        } else {
            c2.setXYW(this.X - (x - this.X0), this.Y - (y - this.Y0), this.W);
        }
        zc.recompute();
        zc.validate();
        zc.repaint();
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        this.Zoom = false;
        this.Dragging = false;
        zc.setCursor(Cursor.getDefaultCursor());
        zc.repaint();
        if (this.OC != null) {
            zc.setTool(this.OC);
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.zoom"));
    }

    public void reset(ZirkelCanvas zc) {
        zc.clearSelected();
        zc.setCursor(new Cursor(0));
        this.Dragging = false;
        this.Zoom = false;
    }

    public void invalidate(ZirkelCanvas zc) {
        zc.setCursor(new Cursor(0));
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean flag) {
        this.X0 = zc.x(e2.getX());
        this.Y0 = zc.y(e2.getY());
        Construction c2 = zc.getConstruction();
        this.X = c2.getX();
        this.Y = c2.getY();
        this.W = c2.getW();
        boolean bl = this.Zoom = Math.abs(this.X - this.X0) > this.W / 4.0 || Math.abs(this.Y - this.Y0) > this.W / 4.0;
        if (!this.Zoom) {
            zc.setCursor(new Cursor(13));
        } else {
            zc.setCursor(new Cursor(0));
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

