/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.Evaluator;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.UserFunctionEditDialog;

public class UserFunctionObject
extends ConstructionObject
implements MoveableObject,
Evaluator {
    Expression EY = null;
    double[] X = new double[]{0.0};
    String[] Var = new String[]{"x y"};
    protected double Xpos;
    protected double Ypos;
    protected boolean Fixed;
    protected Expression EXpos;
    protected Expression EYpos;
    boolean DrawZeros;
    double C;
    double R;
    double W;
    double H;
    double[] x;
    double[] y;
    double[][] z;
    int xn = 20;
    int yn = 20;
    double[] xv = new double[2];
    public boolean EditAborted;
    double oldx;
    double oldy;
    double startx;
    double starty;

    public UserFunctionObject(Construction c2) {
        super(c2);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Function";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(this.getDisplayValue());
    }

    public void validate() {
        this.Valid = this.EY != null ? this.EY.isValid() : false;
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            try {
                this.Xpos = this.EXpos.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            try {
                this.Ypos = this.EYpos.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    public void setExpressions(String t, String ey) {
        StringTokenizer tok = new StringTokenizer(t);
        this.Var = new String[tok.countTokens()];
        this.X = new double[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.Var[i++] = tok.nextToken();
        }
        this.EY = new Expression(ey, this.getConstruction(), this, this.Var);
        this.validate();
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    public double fix(double x1, double y1, double z1, double x2, double y2, double z2, double l1) {
        try {
            double z = this.evaluateF(x1 * l1 + x2 * (1.0 - l1), y1 * l1 + y2 * (1.0 - l1));
            if (Math.abs(z) > (Math.abs(z1) + Math.abs(z2)) * 1.0E-5) {
                double mu = 1.0 - l1;
                double mu2 = mu * mu;
                double mu3 = mu2 * mu;
                double mu4 = mu3 * mu;
                double h = Math.sqrt(mu4 * z2 * z2 + ((-2.0 * mu4 + 4.0 * mu3 - 2.0 * mu2) * z1 - 2.0 * mu2 * z) * z2 + (mu4 - 4.0 * mu3 + 6.0 * mu2 - 4.0 * mu + 1.0) * z1 * z1 + (-2.0 * mu2 + 4.0 * mu - 2.0) * z * z1 + z * z);
                double h1 = (mu2 * z2 - mu2 * z1 + z1 - z + h) / (2.0 * (mu * z2 - mu * z1 + z1 - z));
                double h2 = (mu2 * z2 - mu2 * z1 + z1 - z - h) / (2.0 * (mu * z2 - mu * z1 + z1 - z));
                if (h1 >= 0.0 && h1 <= 1.0) {
                    l1 = 1.0 - h1;
                } else if (h2 >= 0.0 && h2 <= 1.0) {
                    l1 = 1.0 - h2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l1;
    }

    public void drawZeros(MyGraphics g, ZirkelCanvas zc, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        if (z1 * z2 < 0.0) {
            double l1 = z2 / (z2 - z1);
            double m1 = 1.0 - l1;
            if (z1 * z3 < 0.0) {
                double l2 = z3 / (z3 - z1);
                double m2 = 1.0 - l2;
                g.drawLine(zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x1 + m2 * x3), zc.row(l2 * y1 + m2 * y3));
            } else {
                double l2 = z3 / (z3 - z2);
                double m2 = 1.0 - l2;
                g.drawLine(zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
            }
        } else if (z1 * z3 < 0.0) {
            double l1 = z3 / (z3 - z1);
            double m1 = 1.0 - l1;
            double l2 = z3 / (z3 - z2);
            double m2 = 1.0 - l2;
            g.drawLine(zc.col(l1 * x1 + m1 * x3), zc.row(l1 * y1 + m1 * y3), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
        }
    }

    public void drawZeros(MyGraphics g, ZirkelCanvas zc, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, int level) {
        if (level == 0) {
            this.drawZeros(g, zc, x1, y1, z1, x2, y2, z2, x3, y3, z3);
        } else if (z1 * z2 <= 0.0 || z2 * z3 <= 0.0) {
            double x12 = (x1 + x2) / 2.0;
            double y12 = (y1 + y2) / 2.0;
            double x23 = (x2 + x3) / 2.0;
            double y23 = (y2 + y3) / 2.0;
            double x13 = (x1 + x3) / 2.0;
            double y13 = (y1 + y3) / 2.0;
            double x1l = x1 + (x2 - x3) / 2.0;
            double y1l = y1 + (y2 - y3) / 2.0;
            double x1r = x1 + (x3 - x2) / 2.0;
            double y1r = y1 + (y3 - y2) / 2.0;
            double x2l = x2 + (x3 - x1) / 2.0;
            double y2l = y2 + (y3 - y1) / 2.0;
            double x2r = x2 + (x1 - x3) / 2.0;
            double y2r = y2 + (y1 - y3) / 2.0;
            double x3l = x3 + (x1 - x2) / 2.0;
            double y3l = y3 + (y1 - y2) / 2.0;
            double x3r = x3 + (x2 - x1) / 2.0;
            double y3r = y3 + (y2 - y1) / 2.0;
            try {
                double z12 = this.evaluateF(x12, y12);
                double z23 = this.evaluateF(x23, y23);
                double z13 = this.evaluateF(x13, y13);
                this.drawZeros(g, zc, x1, y1, z1, x13, y13, z13, x12, y12, z12, level - 1);
                this.drawZeros(g, zc, x2, y2, z2, x12, y12, z12, x23, y23, z23, level - 1);
                this.drawZeros(g, zc, x3, y3, z3, x23, y23, z23, x13, y13, z13, level - 1);
                this.drawZeros(g, zc, x12, y12, z12, x13, y13, z13, x23, y23, z23, level - 1);
                if (z2 * z1 <= 0.0) {
                    double z1l = this.evaluateF(x1l, y1l);
                    this.drawZeros(g, zc, x1l, y1l, z1l, x1, y1, z1, x12, y12, z12, level - 1);
                    double z2r = this.evaluateF(x2r, y2r);
                    this.drawZeros(g, zc, x2r, y2r, z2r, x12, y12, z12, x1, y1, z1, level - 1);
                }
                if (z3 * z1 <= 0.0) {
                    double z1r = this.evaluateF(x1r, y1r);
                    this.drawZeros(g, zc, x1, y1, z1, x1r, y1r, z1r, x13, y13, z13, level - 1);
                    double z3l = this.evaluateF(x3l, y3l);
                    this.drawZeros(g, zc, x13, y13, z13, x3l, y3l, z3l, x3, y3, z3, level - 1);
                }
                if (z3 * z2 <= 0.0) {
                    double z2l = this.evaluateF(x2l, y2l);
                    this.drawZeros(g, zc, x2, y2, z2, x23, y23, z23, x2l, y2l, z2l, level - 1);
                    double z3r = this.evaluateF(x3r, y3r);
                    this.drawZeros(g, zc, x23, y23, z23, x3, y3, z3, x3r, y3r, z3r, level - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        int steps = 50;
        if (this.DrawZeros && this.X.length == 2) {
            double xmin = zc.Xmin;
            double xmax = zc.Xmin + zc.DX;
            double ymin = zc.Ymin;
            double ymax = zc.Ymin + zc.DY;
            double dx = (xmax - xmin) / (double)steps;
            double dy = dx * Math.sqrt(3.0) / 2.0;
            this.xn = (int)((xmax - xmin) / dx) + 2;
            this.yn = (int)((ymax - ymin) / dy) + 1;
            if (this.x == null || this.x.length != this.xn || this.y.length != this.yn) {
                this.x = new double[this.xn + 1];
                this.y = new double[this.yn + 1];
                this.z = new double[this.xn + 1][this.yn + 1];
            }
            int i = 0;
            while (i <= this.xn) {
                this.x[i] = xmin - dx + (double)i * dx;
                ++i;
            }
            int j = 0;
            while (j <= this.yn) {
                this.y[j] = ymin + (double)j * dy;
                ++j;
            }
            i = 0;
            while (i <= this.xn) {
                int j2 = 0;
                while (j2 <= this.yn) {
                    this.xv[0] = this.x[i];
                    this.xv[1] = this.y[j2];
                    if (j2 % 2 == 0) {
                        this.xv[0] = this.xv[0] + dx / 2.0;
                    }
                    try {
                        this.z[i][j2] = this.evaluateF(this.xv);
                    }
                    catch (Exception e2) {
                        this.z[i][j2] = 1.0;
                    }
                    ++j2;
                }
                ++i;
            }
            g.setColor(this);
            int maxlevel = 2;
            int i2 = 0;
            while (i2 <= this.xn - 1) {
                int j3 = 0;
                while (j3 <= this.yn - 1) {
                    if (j3 % 2 == 0) {
                        this.drawZeros(g, zc, this.x[i2] + dx / 2.0, this.y[j3], this.z[i2][j3], this.x[i2], this.y[j3 + 1], this.z[i2][j3 + 1], this.x[i2 + 1], this.y[j3 + 1], this.z[i2 + 1][j3 + 1], maxlevel);
                        this.drawZeros(g, zc, this.x[i2] + dx / 2.0, this.y[j3], this.z[i2][j3], this.x[i2 + 1], this.y[j3 + 1], this.z[i2 + 1][j3 + 1], this.x[i2 + 1] + dx / 2.0, this.y[j3], this.z[i2 + 1][j3], maxlevel);
                    } else {
                        this.drawZeros(g, zc, this.x[i2], this.y[j3], this.z[i2][j3], this.x[i2] + dx / 2.0, this.y[j3 + 1], this.z[i2][j3 + 1], this.x[i2 + 1], this.y[j3], this.z[i2 + 1][j3], maxlevel);
                        this.drawZeros(g, zc, this.x[i2 + 1], this.y[j3], this.z[i2 + 1][j3], this.x[i2 + 1] + dx / 2.0, this.y[j3 + 1], this.z[i2 + 1][j3 + 1], this.x[i2 + 1] - dx / 2.0, this.y[j3 + 1], this.z[i2][j3 + 1], maxlevel);
                    }
                    ++j3;
                }
                ++i2;
            }
        }
        FontMetrics fm = g.getFontMetrics();
        this.W = this.H = (double)fm.getHeight();
        this.C = zc.col(this.Xpos);
        this.R = zc.row(this.Ypos);
        g.setColor(this);
        this.setFont(g);
        g.drawString(AngleObject.translateToUnicode(this.getDisplayValue()), this.C, this.R);
        this.R -= this.H;
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String var) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        int i = 0;
        while (i < this.Var.length) {
            if (var.equals(this.Var[i])) {
                return this.X[i];
            }
            ++i;
        }
        return this.X[0];
    }

    public String getDisplayValue() {
        String s = "";
        if (this.showName()) {
            if (this.getAlias() != null) {
                s = String.valueOf(this.getAlias()) + " : ";
            }
            s = String.valueOf(s) + this.getName() + "(" + this.Var[0];
            int i = 1;
            while (i < this.Var.length) {
                s = String.valueOf(s) + "," + this.Var[i];
                ++i;
            }
            s = String.valueOf(s) + ")";
            if (this.showValue()) {
                s = String.valueOf(s) + "=";
            }
        }
        if (this.showValue()) {
            s = String.valueOf(s) + (this.EY == null ? "" : this.EY.toString());
        }
        return s;
    }

    public boolean check(double size, double c2, double r, double c1, double r1, double c22, double r2) {
        return Math.abs(r - (r1 + r2) / 2.0) + Math.abs(c2 - (c1 + c22) / 2.0) < 2.0 * size;
    }

    public boolean nearto(ZirkelCanvas zc, int cc, int rr, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        int size = (int)zc.selectionSize();
        if (z1 * z2 < 0.0) {
            double l1 = z2 / (z2 - z1);
            l1 = this.fix(x1, y1, z1, x2, y2, z2, l1);
            double m1 = 1.0 - l1;
            if (z1 * z3 < 0.0) {
                double l2 = z3 / (z3 - z1);
                l2 = this.fix(x1, y1, z1, x3, y3, z3, l2);
                double m2 = 1.0 - l2;
                return this.check(size, cc, rr, zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x1 + m2 * x3), zc.row(l2 * y1 + m2 * y3));
            }
            double l2 = z3 / (z3 - z2);
            l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
            double m2 = 1.0 - l2;
            return this.check(size, cc, rr, zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
        }
        if (z1 * z3 < 0.0) {
            double l1 = z3 / (z3 - z1);
            l1 = this.fix(x1, y1, z1, x3, y3, z3, l1);
            double m1 = 1.0 - l1;
            double l2 = z3 / (z3 - z2);
            l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
            double m2 = 1.0 - l2;
            return this.check(size, cc, rr, zc.col(l1 * x1 + m1 * x3), zc.row(l1 * y1 + m1 * y3), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
        }
        return false;
    }

    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        if (this.C <= (double)cc && this.R <= (double)rr && (double)cc <= this.C + this.W && (double)rr <= this.R + this.H) {
            return true;
        }
        if (this.DrawZeros && this.X.length == 2 && this.z != null) {
            double xmin = zc.Xmin;
            double xmax = zc.Xmin + 2.0 * zc.DX;
            double ymin = zc.Ymin;
            double ymax = zc.Ymin + 2.0 * zc.DY;
            double dx = (xmax - xmin) / 50.0;
            double dy = dx * Math.sqrt(3.0) / 2.0;
            int i = 0;
            while (i <= this.xn - 1) {
                int j = 0;
                while (j <= this.yn - 1) {
                    if (j % 2 == 0) {
                        if (this.nearto(zc, cc, rr, this.x[i] + dx / 2.0, this.y[j], this.z[i][j], this.x[i], this.y[j + 1], this.z[i][j + 1], this.x[i + 1], this.y[j + 1], this.z[i + 1][j + 1])) {
                            return true;
                        }
                        if (this.nearto(zc, cc, rr, this.x[i] + dx / 2.0, this.y[j], this.z[i][j], this.x[i + 1] + dx / 2.0, this.y[j], this.z[i + 1][j], this.x[i + 1], this.y[j + 1], this.z[i + 1][j + 1])) {
                            return true;
                        }
                    } else {
                        if (this.nearto(zc, cc, rr, this.x[i], this.y[j], this.z[i][j], this.x[i + 1], this.y[j], this.z[i + 1][j], this.x[i] + dx / 2.0, this.y[j + 1], this.z[i][j + 1])) {
                            return true;
                        }
                        if (this.nearto(zc, cc, rr, this.x[i + 1], this.y[j], this.z[i + 1][j], this.x[i + 1] - dx / 2.0, this.y[j + 1], this.z[i][j + 1], this.x[i + 1] + dx / 2.0, this.y[j + 1], this.z[i + 1][j + 1])) {
                            return true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public void edit(ZirkelCanvas zc) {
        UserFunctionEditDialog d2;
        while (true) {
            Warning w;
            Frame F;
            d2 = new UserFunctionEditDialog(zc, this);
            d2.setVisible(true);
            this.EditAborted = false;
            if (d2.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (!this.EY.isValid()) {
                F = zc.getFrame();
                w = new Warning(F, this.EY.getErrorText(), Zirkel.name("warning"), true);
                w.center(F);
                w.setVisible(true);
            }
            if (this.EXpos != null && !this.EXpos.isValid()) {
                F = zc.getFrame();
                w = new Warning(F, this.EXpos.getErrorText(), Zirkel.name("warning"), true);
                w.center(F);
                w.setVisible(true);
                continue;
            }
            if (this.EYpos == null || this.EYpos.isValid()) break;
            F = zc.getFrame();
            w = new Warning(F, this.EYpos.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        this.updateText();
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("f", this.EY.toString());
        if (this.DrawZeros) {
            xml.printArg("drawzeros", "true");
        }
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            xml.printArg("x", this.EXpos.toString());
        } else {
            xml.printArg("x", "" + this.Xpos);
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            xml.printArg("y", this.EYpos.toString());
        } else {
            xml.printArg("y", "" + this.Ypos);
        }
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        xml.printArg("var", this.getVar());
    }

    public void translate() {
        try {
            this.EY = new Expression(this.EY.toString(), this.getConstruction(), this, this.Var);
            ConstructionObject O = this.getTranslation();
            this.setTranslation(this);
            this.EY.translate();
            if (this.Fixed) {
                try {
                    this.setFixed(this.EXpos.toString(), this.EYpos.toString());
                    this.EXpos.translate();
                    this.EYpos.translate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.validate();
            this.setTranslation(O);
        }
        catch (Exception e2) {
            System.out.println();
            System.out.println(this.getName());
            System.out.println(e2);
            e2.printStackTrace();
        }
    }

    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EYpos = null;
            this.EXpos = null;
        }
        this.updateText();
    }

    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EXpos = new Expression(x, this.getConstruction(), this);
        this.EYpos = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public String getEXpos() {
        if (this.EXpos != null) {
            return this.EXpos.toString();
        }
        return "" + this.round(this.Xpos);
    }

    public String getEYpos() {
        if (this.EYpos != null) {
            return this.EYpos.toString();
        }
        return "" + this.round(this.Ypos);
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    public boolean equals(ConstructionObject o) {
        return false;
    }

    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EY);
        if (this.Fixed) {
            this.addDepending(this.EXpos);
            this.addDepending(this.EYpos);
        }
        return DL.elements();
    }

    public void addDepending(Expression E) {
        if (E != null) {
            Enumeration e2 = E.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double x, double y) throws ConstructionException {
        this.xv[0] = x;
        this.xv[1] = y;
        return this.evaluateF(this.xv);
    }

    public double evaluateF(double[] x) throws ConstructionException {
        int n = x.length;
        if (n > this.X.length) {
            n = this.X.length;
        }
        int i = 0;
        while (i < n) {
            this.X[i] = x[i];
            ++i;
        }
        i = n;
        while (i < this.X.length) {
            this.X[i] = 0.0;
            ++i;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public double evaluateF(double x) throws ConstructionException {
        this.X[0] = x;
        int i = 1;
        while (i < this.X.length) {
            this.X[i] = 0.0;
            ++i;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean canDisplayName() {
        return true;
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public String getVar() {
        String vars = this.Var[0];
        int i = 1;
        while (i < this.Var.length) {
            vars = String.valueOf(vars) + " " + this.Var[i];
            ++i;
        }
        return vars;
    }

    public boolean dragTo(double x, double y) {
        this.move(this.oldx + (x - this.startx), this.oldy + (y - this.starty));
        return true;
    }

    public void move(double x, double y) {
        this.Xpos = x;
        this.Ypos = y;
    }

    public boolean moveable() {
        return !this.Fixed;
    }

    public boolean startDrag(double x, double y) {
        this.oldx = this.Xpos;
        this.oldy = this.Ypos;
        this.startx = x;
        this.starty = y;
        return true;
    }

    public double getX() {
        return this.Xpos;
    }

    public double getY() {
        return this.Ypos;
    }

    public boolean canFillBackground() {
        return false;
    }

    public boolean isDrawZeros() {
        return this.DrawZeros;
    }

    public void setDrawZeros(boolean drawZeros) {
        this.DrawZeros = drawZeros;
        if (this.X.length != 2 && this.EY != null && drawZeros) {
            this.setExpressions("x y", this.EY.toString());
        }
    }
}

