/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.TextObject;

class TextEditDialog
extends ObjectEditDialog {
    TextField X;
    TextField Y;
    Checkbox Fixed;
    IconBar TypeIB;

    public TextEditDialog(Frame f2, TextObject o) {
        super(f2, Zirkel.name("edit.text.title"), o);
    }

    public void addFirst(Panel P) {
        TextObject t = (TextObject)this.O;
        this.X = new TextFieldAction(this, "X", "" + t.getX(), 30);
        P.add(new MyLabel(Zirkel.name("edit.point.x")));
        P.add(this.X);
        this.Y = new TextFieldAction(this, "Y", "" + t.getY(), 30);
        P.add(new MyLabel(Zirkel.name("edit.point.y")));
        P.add(this.Y);
        this.Fixed = new Checkbox("");
        this.Fixed.setState(t.fixed());
        P.add(new MyLabel(Zirkel.name("edit.fixed")));
        P.add(this.Fixed);
        if (t.fixed()) {
            this.X.setText(t.getEX());
            this.Y.setText(t.getEY());
        }
    }

    public void doAction(String o) {
        if ((o.equals("Y") || o.equals("X")) && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else {
            super.doAction(o);
        }
    }

    public void setAction() {
        TextObject t = (TextObject)this.O;
        if (this.Fixed != null && this.Fixed.getState()) {
            t.setFixed(this.X.getText(), this.Y.getText());
        } else {
            try {
                double x = new Expression(this.X.getText(), t.getConstruction(), t).getValue();
                double y = new Expression(this.Y.getText(), t.getConstruction(), t).getValue();
                t.move(x, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.Fixed != null && !this.Fixed.getState()) {
            t.setFixed(false);
        }
    }

    public void focusGained(FocusEvent e2) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.X.requestFocus();
        } else {
            super.focusGained(e2);
        }
    }

    public boolean showsValue() {
        return false;
    }
}

