/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Quartic;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class QuadricObject
extends ConstructionObject
implements PointonObject,
MoveableObject {
    PointObject[] P;
    static Count N = new Count();
    double[] X;
    public static String[] Tags = new String[]{"x^2", "y^2", "x", "y", "xy"};
    double[] xd;
    double[] yd;
    double x1;
    double y1;

    public QuadricObject(Construction c2, PointObject[] p) {
        super(c2);
        this.P = p;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Quadric";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        try {
            String[] Names = new String[this.P.length];
            int i = 0;
            while (i < this.P.length) {
                Names[i] = this.P[i].getName();
                ++i;
            }
            this.setText(QuadricObject.textAny(Zirkel.name("text.quadric"), Names));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validate() {
        int i = 0;
        while (i < this.P.length) {
            if (!this.P[i].valid()) {
                this.Valid = false;
                return;
            }
            ++i;
        }
        this.Valid = true;
        double[][] A = new double[5][6];
        int i2 = 0;
        while (i2 < 5) {
            double x = this.P[i2].getX();
            double y = this.P[i2].getY();
            A[i2][0] = x * x;
            A[i2][1] = y * y;
            A[i2][2] = x;
            A[i2][3] = y;
            A[i2][4] = x * y;
            A[i2][5] = 1.0;
            double sum = 0.0;
            int j = 0;
            while (j < 6) {
                sum += A[i2][j] * A[i2][j];
                ++j;
            }
            sum = Math.sqrt(sum);
            j = 0;
            while (j < 6) {
                double[] dArray = A[i2];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
            ++i2;
        }
        int r = 0;
        int[] colindex = new int[6];
        int c2 = 0;
        while (c2 < 6) {
            if (r >= 5) {
                colindex[c2] = -1;
            } else {
                double max = Math.abs(A[r][c2]);
                int imax = r;
                int i3 = r + 1;
                while (i3 < 5) {
                    double h = Math.abs(A[i3][c2]);
                    if (h > max) {
                        max = h;
                        imax = i3;
                    }
                    ++i3;
                }
                if (max > 1.0E-13) {
                    if (imax != r) {
                        double[] h = A[imax];
                        A[imax] = A[r];
                        A[r] = h;
                    }
                    i3 = r + 1;
                    while (i3 < 5) {
                        double lambda = A[i3][c2] / A[r][c2];
                        int j = c2 + 1;
                        while (j < 6) {
                            double[] dArray = A[i3];
                            int n = j;
                            dArray[n] = dArray[n] - lambda * A[r][j];
                            ++j;
                        }
                        ++i3;
                    }
                    colindex[c2] = r++;
                } else {
                    colindex[c2] = -1;
                }
            }
            ++c2;
        }
        this.X = new double[6];
        int j = 5;
        while (j >= 0) {
            if (colindex[j] < 0) {
                this.X[j] = 1.0;
            } else {
                double h = 0.0;
                int i4 = colindex[j];
                int k = j + 1;
                while (k < 6) {
                    h += A[i4][k] * this.X[k];
                    ++k;
                }
                this.X[j] = -h / A[i4][j];
            }
            --j;
        }
        double sum = 0.0;
        int i5 = 0;
        while (i5 <= 5) {
            sum += Math.abs(this.X[i5]);
            ++i5;
        }
        if (sum < 1.0E-10) {
            this.Valid = false;
        }
        i5 = 0;
        while (i5 <= 5) {
            int n = i5++;
            this.X[n] = this.X[n] / sum;
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        int r;
        int c2;
        double y;
        double start;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        g.setColor(this);
        double x = start = zc.minX();
        double end = zc.maxX();
        double h = zc.dx(1);
        boolean valid = false;
        boolean ptext = false;
        int c0 = 0;
        int r0 = 0;
        int ctext = 20;
        int rtext = 20;
        PolygonDrawer pd = new PolygonDrawer(g, this);
        while (x <= end) {
            try {
                y = this.computeLower(x);
                c2 = (int)zc.col(x);
                r = (int)zc.row(y);
                if (valid) {
                    pd.drawTo(c2, r);
                    if (!ptext && r0 - r > c2 - c0 && zc.isInside(x, y)) {
                        ctext = c2;
                        rtext = r;
                        ptext = true;
                    }
                } else {
                    pd.startPolygon(c2, r);
                }
                c0 = c2;
                r0 = r;
                valid = true;
            }
            catch (RuntimeException e2) {
                valid = false;
            }
            x += h;
        }
        pd.finishPolygon();
        x = start - 2.0 * h;
        valid = false;
        while (x <= end + 2.0 * h) {
            try {
                y = this.computeUpper(x);
                c2 = (int)zc.col(x);
                r = (int)zc.row(y);
                if (valid) {
                    pd.drawTo(c2, r);
                    if (!ptext && r0 - r > c2 - c0 && zc.isInside(x, y)) {
                        ctext = c2;
                        rtext = r;
                        ptext = true;
                    }
                } else {
                    try {
                        double y1 = this.computeLower(x);
                        if (x >= start - h && x <= end + h) {
                            g.drawLine(c2, zc.row(y1), c2, r, this);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    pd.startPolygon(c2, r);
                }
                c0 = c2;
                r0 = r;
                valid = true;
            }
            catch (RuntimeException e3) {
                if (valid) {
                    try {
                        double y1 = this.computeLower(x - h);
                        if (x - h >= start - h && x - h <= end + h) {
                            g.drawLine(c0, zc.row(y1), c0, r0, this);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                valid = false;
            }
            x += h;
        }
        pd.finishPolygon();
        String s = this.getDisplayText();
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            this.TX1 = (double)ctext + zc.col(this.XcOffset) - zc.col(0.0);
            this.TY1 = (double)rtext + zc.row(this.YcOffset) - zc.row(0.0);
            this.drawLabel(g, s);
        }
    }

    public String getDisplayValue() {
        String s = "";
        int i = 0;
        while (i < 5) {
            s = String.valueOf(s) + this.helpDisplayValue(i == 0, -this.X[i], Tags[i]);
            ++i;
        }
        return String.valueOf(s) + "=" + this.roundDisplay(this.X[5]);
    }

    public String getEquation() {
        return this.getDisplayValue();
    }

    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        double start;
        if (!this.displays(zc)) {
            return false;
        }
        int size = (int)zc.selectionSize();
        double x = start = zc.minX();
        double end = zc.maxX();
        double h = zc.dx(1);
        while (x <= end) {
            double r;
            double c2;
            double y2;
            try {
                y2 = this.computeUpper(x);
                c2 = zc.col(x);
                r = zc.row(y2);
                if (Math.abs((double)cc - c2) <= (double)(size * 3 / 2) && Math.abs((double)rr - r) <= (double)(size * 3 / 2)) {
                    return true;
                }
            }
            catch (Exception y2) {
                // empty catch block
            }
            try {
                y2 = this.computeLower(x);
                c2 = zc.col(x);
                r = zc.row(y2);
                if (Math.abs((double)cc - c2) <= (double)(size * 3 / 2) && Math.abs((double)rr - r) <= (double)(size * 3 / 2)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            x += h;
        }
        return false;
    }

    public void edit(ZirkelCanvas zc) {
        ObjectEditDialog d2 = new ObjectEditDialog(zc.getFrame(), "", this);
        d2.setVisible(true);
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    double computeUpper(double x) {
        if (Math.abs(this.X[1]) > 1.0E-13) {
            double p = (this.X[3] + x * this.X[4]) / this.X[1];
            double q = (this.X[0] * x * x + this.X[2] * x + this.X[5]) / this.X[1];
            double h = p * p / 4.0 - q;
            if (h < 0.0) {
                throw new RuntimeException("");
            }
            return -p / 2.0 + Math.sqrt(h);
        }
        return -(this.X[0] * x * x + this.X[2] * x + this.X[5]) / (this.X[3] + this.X[4] * x);
    }

    double computeLower(double x) {
        if (Math.abs(this.X[1]) > 1.0E-13) {
            double p = (this.X[3] + x * this.X[4]) / this.X[1];
            double q = (this.X[0] * x * x + this.X[2] * x + this.X[5]) / this.X[1];
            double h = p * p / 4.0 - q;
            if (h < 0.0) {
                throw new RuntimeException("");
            }
            return -p / 2.0 - Math.sqrt(h);
        }
        throw new RuntimeException("");
    }

    public void printArgs(XmlWriter xml) {
        int i = 0;
        while (i < this.P.length) {
            xml.printArg("point" + (i + 1), this.P[i].getName());
            ++i;
        }
    }

    public Enumeration depending() {
        DL.reset();
        int i = 0;
        while (i < this.P.length) {
            DL.add(this.P[i]);
            ++i;
        }
        return DL.elements();
    }

    public void translate() {
        int i = 0;
        while (i < this.P.length) {
            this.P[i] = (PointObject)this.P[i].getTranslation();
            ++i;
        }
    }

    public ConstructionObject copy() {
        try {
            QuadricObject o = (QuadricObject)this.clone();
            this.setTranslation(o);
            o.P = new PointObject[this.P.length];
            int i = 0;
            while (i < this.P.length) {
                o.P[i] = this.P[i];
                ++i;
            }
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            o.setTarget(false);
            return o;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(ConstructionObject o) {
        if (!(o instanceof QuadricObject)) return false;
        if (!o.valid()) {
            return false;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= 6) {
                    return true;
                }
                if (!this.equals(this.X[i], ((QuadricObject)o).X[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (RuntimeException e2) {
            return false;
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public void project(PointObject P) {
        double yc;
        double a2 = this.X[0];
        double b2 = this.X[1];
        double c2 = this.X[2];
        double d2 = this.X[3];
        double e2 = this.X[4];
        double r = this.X[5];
        double xc = P.getX();
        if (Math.abs(a2 * xc * xc + b2 * (yc = P.getY()) * yc + c2 * xc + d2 * yc + e2 * xc * yc + r) < 1.0E-13) {
            return;
        }
        double[] t = new double[5];
        double[] s = new double[5];
        double[] si = new double[5];
        t[0] = a2 * e2 * e2 * d2 * d2 - 4.0 * a2 * b2 * b2 * c2 * c2 + 4.0 * a2 * e2 * d2 * b2 * c2 - 4.0 * b2 * a2 * a2 * d2 * d2 + b2 * c2 * c2 * e2 * e2 - c2 * Math.pow(e2, 3.0) * d2 + r * Math.pow(e2, 4.0) - 8.0 * r * e2 * e2 * b2 * a2 + 16.0 * r * b2 * b2 * a2 * a2;
        t[1] = 8.0 * b2 * b2 * c2 * c2 + 8.0 * a2 * a2 * d2 * d2 - 8.0 * e2 * d2 * b2 * c2 - 8.0 * a2 * d2 * c2 * e2 + 8.0 * r * e2 * e2 * b2 + 8.0 * a2 * b2 * c2 * c2 + 8.0 * b2 * a2 * d2 * d2 + 8.0 * r * e2 * e2 * a2 - 32.0 * r * b2 * b2 * a2 - 32.0 * r * b2 * a2 * a2;
        t[2] = 12.0 * e2 * d2 * c2 + 16.0 * r * b2 * b2 - 4.0 * b2 * d2 * d2 - 8.0 * r * e2 * e2 + 4.0 * e2 * e2 * d2 * yc + 16.0 * b2 * b2 * xc * c2 - 16.0 * b2 * c2 * c2 - 16.0 * a2 * d2 * d2 - 4.0 * a2 * c2 * c2 + 16.0 * r * a2 * a2 + 16.0 * a2 * a2 * d2 * yc + 4.0 * xc * e2 * e2 * c2 - 8.0 * e2 * d2 * b2 * xc - 8.0 * e2 * yc * b2 * c2 - 8.0 * a2 * d2 * xc * e2 - 8.0 * a2 * yc * c2 * e2 + 16.0 * a2 * b2 * b2 * xc * xc - 4.0 * a2 * e2 * e2 * yc * yc + 16.0 * b2 * a2 * a2 * yc * yc - 4.0 * b2 * xc * xc * e2 * e2 + 4.0 * Math.pow(e2, 3.0) * yc * xc + 64.0 * r * b2 * a2 - 16.0 * a2 * b2 * xc * e2 * yc;
        t[3] = -32.0 * r * b2 + 8.0 * d2 * d2 + 8.0 * c2 * c2 + 16.0 * e2 * d2 * xc + 8.0 * e2 * e2 * yc * yc + 8.0 * xc * xc * e2 * e2 - 32.0 * r * a2 - 32.0 * b2 * xc * c2 + 16.0 * e2 * yc * c2 - 32.0 * a2 * d2 * yc - 32.0 * a2 * b2 * xc * xc - 32.0 * b2 * a2 * yc * yc;
        t[4] = 16.0 * b2 * yc * yc + 16.0 * d2 * yc + 16.0 * c2 * xc + 16.0 * xc * e2 * yc + 16.0 * r + 16.0 * a2 * xc * xc;
        int k = Quartic.solve(t, s);
        double dmin = 1.0E30;
        double xmin = xc;
        double ymin = yc;
        int i = 0;
        while (i < k) {
            double l = s[i];
            double px = -(-e2 * d2 + 4.0 * b2 * l * xc - 2.0 * e2 * l * yc - 4.0 * l * l * xc + 2.0 * b2 * c2 - 2.0 * l * c2) / (-e2 * e2 + 4.0 * b2 * a2 - 4.0 * b2 * l - 4.0 * l * a2 + 4.0 * l * l);
            double py = -(2.0 * a2 * d2 + 4.0 * a2 * l * yc - 2.0 * l * d2 - 4.0 * l * l * yc - 2.0 * l * xc * e2 - c2 * e2) / (-e2 * e2 + 4.0 * b2 * a2 - 4.0 * b2 * l - 4.0 * l * a2 + 4.0 * l * l);
            double dist = (px - xc) * (px - xc) + (py - yc) * (py - yc);
            if (dist < dmin) {
                dmin = dist;
                xmin = px;
                ymin = py;
            }
            ++i;
        }
        P.move(xmin, ymin);
    }

    public void project(PointObject P, double alpha) {
        this.project(P);
    }

    public boolean dragTo(double x, double y) {
        int i = 0;
        while (i < 5) {
            this.P[i].move(this.xd[i] + (x - this.x1), this.yd[i] + (y - this.y1));
            ++i;
        }
        return true;
    }

    public void move(double x, double y) {
    }

    public boolean moveable() {
        int i = 0;
        while (i < 5) {
            if (!this.P[i].moveable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startDrag(double x, double y) {
        if (this.xd == null) {
            this.xd = new double[5];
            this.yd = new double[5];
        }
        int i = 0;
        while (i < 5) {
            this.xd[i] = this.P[i].getX();
            this.yd[i] = this.P[i].getY();
            ++i;
        }
        this.x1 = x;
        this.y1 = y;
        return true;
    }

    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            int i = 0;
            while (i < 5) {
                this.P[i].snap(zc);
                ++i;
            }
        }
    }

    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    public boolean canFillBackground() {
        return false;
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return o instanceof QuadricObject;
    }
}

