/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;

public class BMPFile
implements Runnable {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int linepad = 0;
    private int[] bitmap;
    private FileOutputStream fo;
    String parFilename;
    Image parImage;
    int parWidth;
    int parHeight;

    public BMPFile(String parFilename, Image parImage, int parWidth, int parHeight) {
        this.parFilename = parFilename;
        this.parImage = parImage;
        this.parWidth = parWidth;
        this.parHeight = parHeight;
    }

    public void saveBitmap() {
        this.run();
    }

    public void run() {
        try {
            this.fo = new FileOutputStream(this.parFilename);
            this.save(this.parImage, this.parWidth, this.parHeight);
            this.fo.close();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private void save(Image parImage, int parWidth, int parHeight) {
        try {
            this.convertImage(parImage, parWidth, parHeight);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private boolean convertImage(Image parImage, int parWidth, int parHeight) {
        this.bitmap = new int[parWidth * parHeight];
        PixelGrabber pg = new PixelGrabber(parImage, 0, 0, parWidth, parHeight, this.bitmap, 0, parWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
            return false;
        }
        this.linepad = 4 - parWidth * 3 % 4;
        if (this.linepad == 4) {
            this.linepad = 0;
        }
        this.biSizeImage = (parWidth * 3 + this.linepad) * parHeight;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        return true;
    }

    private void writeBitmap() {
        byte[] rgb = new byte[3];
        try {
            int i = this.biHeight - 1;
            while (i >= 0) {
                int j = 0;
                while (j < this.biWidth) {
                    int value = this.bitmap[i * this.biWidth + j];
                    rgb[0] = (byte)(value & 0xFF);
                    rgb[1] = (byte)(value >> 8 & 0xFF);
                    rgb[2] = (byte)(value >> 16 & 0xFF);
                    this.fo.write(rgb);
                    ++j;
                }
                int k = 0;
                while (k < this.linepad) {
                    this.fo.write(0);
                    ++k;
                }
                --i;
            }
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception wbfh) {
            wbfh.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception wbih) {
            wbih.printStackTrace();
        }
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

