/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class SetRangeTool
extends ObjectConstructor {
    ObjectConstructor OC;
    PrimitiveCircleObject C;
    PointObject P1;
    PointObject P2;

    public SetRangeTool(ZirkelCanvas zc, PrimitiveCircleObject c2, ObjectConstructor oc) {
        this.C = c2;
        this.OC = oc;
        this.C.setSelected(true);
        zc.repaint();
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P1 == null) {
            this.P1 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P1 != null) {
                this.P1.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
            }
        } else {
            this.P2 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P2 == null) {
                return;
            }
            this.C.setRange(this.P1.getName(), this.P2.getName());
            this.reset(zc);
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicatePointObjects(e2.getX(), e2.getY());
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.range.first"));
        } else {
            zc.showStatus(Zirkel.name("message.range.second"));
        }
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }
}

