/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.io.PrintWriter;
import rene.gui.Global;

public class LatexOutput {
    PrintWriter Out;
    double W;
    double H;
    boolean DoubleDollar;
    boolean Dollar;
    boolean NoDollar;

    public LatexOutput(PrintWriter out) {
        this.Out = out;
        this.DoubleDollar = Global.getParameter("options.doubledollar", true);
        this.Dollar = Global.getParameter("options.dollar", true);
        this.NoDollar = Global.getParameter("options.nodollar", false);
    }

    public void open(double w, double h, double dpi, String picfilename) {
        this.W = w;
        this.H = h;
        this.Out.println("\\setlength{\\unitlength}{" + 2.54 / dpi + "cm}");
        this.Out.println("\\begin{picture}(" + this.round(w) + "," + this.round(h) + ")");
        String s = picfilename.replace('\\', '/');
        this.Out.println("\\put(0,0){\\includegraphics[width=" + this.round(w / dpi * 2.54) + "cm]{" + s + "}}");
        this.Out.println("%\\put(0,0){\\includegraphics[width=" + this.round(w / dpi * 2.54) + "cm,bb=0 0 " + (int)w + " " + (int)h + "]{" + s + "}}");
    }

    public void close() {
        this.Out.println("\\end{picture}");
        this.Out.close();
    }

    public boolean println(String s, double x, double y, boolean force) {
        if (s.startsWith("$$")) {
            if (!this.DoubleDollar) {
                return false;
            }
            if ((s = s.substring(1)).endsWith("$$")) {
                s = s.substring(0, s.length() - 1);
            }
            if (!s.endsWith("$")) {
                s = String.valueOf(s) + "$";
            }
        } else if (!force && s.startsWith("$")) {
            if (!this.Dollar) {
                return false;
            }
            if (!s.endsWith("$")) {
                s = String.valueOf(s) + "$";
            }
        } else if (!force && !this.NoDollar) {
            return false;
        }
        this.Out.println("\\put(" + this.round(x) + "," + this.round(this.H - y) + "){" + s + "}");
        return true;
    }

    public boolean println(String s, double x, double y) {
        return this.println(s, x, y, false);
    }

    public double round(double x) {
        return Math.floor(x * 1000.0 + 0.5) / 1000.0;
    }

    public boolean printDollar() {
        return this.Dollar;
    }
}

