/*
 * Decompiled with CFR 0.152.
 */
package rene.util.xml;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import rene.util.list.ListElement;
import rene.util.list.Tree;
import rene.util.parser.StringParser;
import rene.util.xml.XmlReaderException;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTree
extends Tree
implements Enumeration<XmlTree>,
Iterator<XmlTree>,
Iterable<XmlTree> {
    ListElement Current;

    public XmlTree(XmlTag t) {
        super(t);
    }

    public XmlTag getTag() {
        return (XmlTag)this.content();
    }

    public XmlTree xmlFirstContent() {
        if (this.firstchild() != null) {
            return (XmlTree)this.firstchild();
        }
        return null;
    }

    public boolean isText() {
        if (!this.haschildren()) {
            return true;
        }
        if (this.firstchild() != this.lastchild()) {
            return false;
        }
        XmlTree t = (XmlTree)this.firstchild();
        XmlTag tag = t.getTag();
        return tag instanceof XmlTagText;
    }

    public String getText() {
        if (!this.haschildren()) {
            return "";
        }
        XmlTree t = (XmlTree)this.firstchild();
        XmlTag tag = t.getTag();
        return ((XmlTagText)tag).getContent();
    }

    public Enumeration<XmlTree> getContent() {
        this.Current = this.children().first();
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        return this.Current != null;
    }

    @Override
    public XmlTree nextElement() {
        if (this.Current == null) {
            return null;
        }
        XmlTree c2 = (XmlTree)this.Current.content();
        this.Current = this.Current.next();
        return c2;
    }

    public boolean isTag(String s) {
        return this.getTag().name().equals(s);
    }

    public String parseComment() throws XmlReaderException {
        StringBuffer s = new StringBuffer();
        Enumeration<XmlTree> e2 = this.getContent();
        while (e2.hasMoreElements()) {
            XmlTree tree = e2.nextElement();
            XmlTag tag = tree.getTag();
            if (tag.name().equals("P")) {
                if (!tree.haschildren()) {
                    s.append("\n");
                    continue;
                }
                XmlTree h = tree.xmlFirstContent();
                String k = ((XmlTagText)h.getTag()).getContent();
                k = k.replace('\n', ' ');
                StringParser p = new StringParser(k);
                Vector<String> v = p.wraplines(1000);
                int i = 0;
                while (i < v.size()) {
                    s.append(v.elementAt(i));
                    s.append("\n");
                    ++i;
                }
                continue;
            }
            if (tag instanceof XmlTagText) {
                String k = ((XmlTagText)tag).getContent();
                StringParser p = new StringParser(k);
                Vector<String> v = p.wraplines(1000);
                int i = 0;
                while (i < v.size()) {
                    s.append(v.elementAt(i));
                    s.append("\n");
                    ++i;
                }
                continue;
            }
            throw new XmlReaderException("<" + tag.name() + "> not proper here.");
        }
        return s.toString();
    }

    @Override
    public boolean hasNext() {
        return this.Current != null;
    }

    @Override
    public XmlTree next() {
        if (this.Current == null) {
            return null;
        }
        XmlTree c2 = (XmlTree)this.Current.content();
        this.Current = this.Current.next();
        return c2;
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator iterator() {
        this.Current = this.children().first();
        return this;
    }
}

