/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import rene.dialogs.DirFieldListener;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.CloseFrame;
import rene.gui.Global;
import rene.gui.HistoryTextField;
import rene.gui.HistoryTextFieldChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.util.FileList;
import rene.util.FileName;
import rene.util.MyVector;

public class MyFileDialog
extends CloseDialog
implements ItemListener,
FilenameFilter,
MouseListener {
    Lister Dirs;
    Lister Files;
    HistoryTextField DirField;
    HistoryTextField FileField;
    HistoryTextField PatternField;
    HistoryTextFieldChoice DirHistory;
    HistoryTextFieldChoice FileHistory;
    TextField Chosen;
    String CurrentDir = ".";
    boolean Aborted = true;
    String DirAppend = "";
    String PatternAppend = "";
    String FileAppend = "";
    Button Home;
    Frame F;
    FileDialog FD;
    boolean HomeShiftControl = false;
    MyVector Undo = new MyVector();

    public MyFileDialog(Frame f2, String title, String action, boolean saving, boolean help) {
        super(f2, title, true);
        this.F = f2;
        this.setLayout(new BorderLayout());
        this.Chosen = new TextFieldAction(this, "");
        this.add("North", new Panel3D(this.Chosen));
        this.Chosen.setEditable(false);
        MyPanel center = new MyPanel();
        center.setLayout(new GridLayout(1, 2, 5, 0));
        this.Dirs = new Lister();
        if (Global.NormalFont != null) {
            this.Dirs.setFont(Global.NormalFont);
        }
        this.Dirs.addActionListener(this);
        this.Dirs.setMode(false, false, false, false);
        center.add(this.Dirs);
        this.Files = new Lister();
        if (Global.NormalFont != null) {
            this.Files.setFont(Global.NormalFont);
        }
        this.Files.addActionListener(this);
        this.Files.setMode(false, false, true, false);
        center.add(this.Files);
        this.add("Center", new Panel3D(center));
        MyPanel south = new MyPanel();
        south.setLayout(new BorderLayout());
        MyPanel px = new MyPanel();
        px.setLayout(new BorderLayout());
        MyPanel p0 = new MyPanel();
        p0.setLayout(new GridLayout(0, 1));
        MyPanel p1 = new MyPanel();
        p1.setLayout(new BorderLayout());
        this.DirField = new HistoryTextField(this, "Dir", 32){

            public boolean filterHistory(String name) {
                if (name.length() < 2) {
                    return true;
                }
                return name.charAt(1) != ':' || !Character.isUpperCase(name.charAt(0));
            }
        };
        p1.add("North", this.linePanel(new MyLabel(Global.name("myfiledialog.dir")), this.DirField));
        this.DirField.setText(".");
        this.DirHistory = new HistoryTextFieldChoice(this.DirField);
        p1.add("South", this.linePanel(new MyLabel(Global.name("myfiledialog.olddirs", "")), this.DirHistory));
        p0.add(new Panel3D(p1));
        MyPanel p2 = new MyPanel();
        p2.setLayout(new BorderLayout());
        this.FileField = new HistoryTextField(this, "File");
        p2.add("North", this.linePanel(new MyLabel(Global.name("myfiledialog.file")), this.FileField));
        this.FileHistory = new HistoryTextFieldChoice(this.FileField);
        p2.add("South", this.linePanel(new MyLabel(Global.name("myfiledialog.oldfiles", "")), this.FileHistory));
        p0.add(new Panel3D(p2));
        px.add("Center", p0);
        this.PatternField = new HistoryTextField(this, "Pattern");
        px.add("South", new Panel3D(this.linePanel(new MyLabel(Global.name("myfiledialog.pattern")), this.PatternField)));
        this.PatternField.setText("*");
        south.add("Center", px);
        MyPanel buttons = new MyPanel();
        buttons.setLayout(new FlowLayout(2));
        this.Home = new ButtonAction(this, Global.name("myfiledialog.home", "Home"), "Home");
        buttons.add(this.Home);
        buttons.add(new ButtonAction(this, Global.name("myfiledialog.mkdir", "Create Directory"), "Create"));
        buttons.add(new ButtonAction(this, Global.name("myfiledialog.back", "Back"), "Back"));
        buttons.add(new MyLabel(""));
        buttons.add(new ButtonAction(this, action, "Action"));
        buttons.add(new ButtonAction(this, Global.name("abort"), "Close"));
        if (help) {
            this.addHelp(buttons, "filedialog");
        }
        south.add("South", buttons);
        this.add("South", new Panel3D(south));
        this.pack();
        this.setSize("myfiledialog");
        this.addKeyListener(this);
        this.DirField.addKeyListener(this);
        this.DirField.setTrigger(true);
        this.FileHistory.setDoActionListener(new DirFieldListener(this));
        this.PatternField.addKeyListener(this);
        this.PatternField.setTrigger(true);
        this.FileField.addKeyListener(this);
        this.FileField.setTrigger(true);
        this.Home.addMouseListener(this);
    }

    Panel linePanel(Component x, Component y) {
        MyPanel p = new MyPanel();
        p.setLayout(new GridLayout(1, 0));
        p.add(x);
        p.add(y);
        return p;
    }

    public MyFileDialog(Frame f2, String title, String action, boolean saving) {
        this(f2, title, action, saving, false);
    }

    public MyFileDialog(Frame f2, String title, boolean saving) {
        super(f2, "", true);
        this.FD = new FileDialog(f2, title, saving ? 1 : 0);
    }

    public void mousePressed(MouseEvent e2) {
        this.HomeShiftControl = e2.isShiftDown() && e2.isControlDown();
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void doAction(String o) {
        if (o.equals("Dir") || o.equals("Pattern")) {
            if (this.updateDir()) {
                this.updateFiles();
            }
            this.PatternField.remember(this.PatternField.getText());
        } else if (o.equals("File") || o.equals("Action")) {
            if (this.FileField.getText().equals("")) {
                return;
            }
            this.leave();
        } else if (o.equals("Home")) {
            String s;
            if (this.HomeShiftControl) {
                s = Global.getParameter("myfiledialog.homedir", "");
                if (s.equals("")) {
                    Global.setParameter("myfiledialog.homedir", this.DirField.getText());
                } else {
                    Global.setParameter("myfiledialog.homedir", "");
                }
            }
            try {
                s = Global.getParameter("myfiledialog.homedir", "");
                if (s.equals("")) {
                    String s1 = System.getProperty("user.home");
                    String s2 = Global.name("myfiledialog.windowshome", "");
                    String s3 = Global.name("myfiledialog.homedir", "");
                    String s4 = Global.name("Documents");
                    String sep = System.getProperty("file.separator");
                    if (new File(String.valueOf(s1) + sep + s4 + sep + s3).exists()) {
                        this.DirField.setText(String.valueOf(s1) + sep + s4 + sep + s3);
                    } else if (new File(String.valueOf(s1) + sep + s2 + sep + s3).exists()) {
                        this.DirField.setText(String.valueOf(s1) + sep + s2 + sep + s3);
                    } else if (new File(String.valueOf(s1) + sep + s4).exists()) {
                        this.DirField.setText(String.valueOf(s1) + sep + s4);
                    } else if (new File(String.valueOf(s1) + sep + s2).exists()) {
                        this.DirField.setText(String.valueOf(s1) + sep + s2);
                    } else if (new File(String.valueOf(s1) + sep + s3).exists()) {
                        this.DirField.setText(String.valueOf(s1) + sep + s3);
                    } else {
                        this.DirField.setText(s1);
                    }
                } else {
                    this.DirField.setText(s);
                }
                this.updateDir();
                this.updateFiles();
            }
            catch (Exception s2) {}
        } else if (o.equals("Create")) {
            try {
                File f2 = new File(this.DirField.getText());
                if (!f2.exists()) {
                    f2.mkdir();
                }
                this.updateDir();
                this.updateFiles();
            }
            catch (Exception f2) {}
        } else if (o.equals("Back")) {
            String dir = this.getUndo();
            if (!dir.equals("")) {
                this.DirField.setText(dir);
                this.updateDir();
                this.updateFiles();
            }
        } else {
            super.doAction(o);
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.Dirs) {
            String s = this.Dirs.getSelectedItem();
            if (s == null) {
                return;
            }
            if (s.equals("..")) {
                this.dirup();
            } else {
                this.dirdown(s);
            }
        }
        if (e2.getSource() == this.Files) {
            if (e2 instanceof ListerMouseEvent) {
                ListerMouseEvent em = (ListerMouseEvent)e2;
                if (em.clickCount() >= 2) {
                    this.leave();
                } else {
                    String s = this.Files.getSelectedItem();
                    if (s != null) {
                        this.FileField.setText(s);
                    }
                }
            }
        } else {
            super.actionPerformed(e2);
        }
    }

    public void setFile(String s) {
        this.DirField.setText(FileName.path(s));
        this.FileField.setText(FileName.filename(s));
        this.update(false);
    }

    public void dirup() {
        this.DirField.setText(FileName.path(this.CurrentDir));
        if (this.DirField.getText().equals("")) {
            this.DirField.setText("" + File.separatorChar);
        }
        if (this.updateDir()) {
            this.updateFiles();
        }
    }

    public void dirdown(String subdir) {
        this.DirField.setText(String.valueOf(this.CurrentDir) + File.separatorChar + subdir);
        if (this.updateDir()) {
            this.updateFiles();
        }
    }

    void leave() {
        if (this.FD != null) {
            return;
        }
        if (!this.FileField.getText().equals("")) {
            this.Aborted = false;
        }
        if (!this.Aborted) {
            this.noteSize("myfiledialog");
            this.DirField.remember(this.DirField.getText());
            this.DirField.saveHistory("myfiledialog.dir.history" + this.DirAppend);
            this.PatternField.saveHistory("myfiledialog.pattern.history" + this.PatternAppend);
            this.FileField.remember(this.getFilePath());
            this.FileField.saveHistory("myfiledialog.file.history" + this.FileAppend);
        }
        this.doclose();
    }

    public boolean updateDir() {
        if (this.FD != null) {
            return true;
        }
        File dir = new File(String.valueOf(this.DirField.getText()) + File.separatorChar);
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            String s = FileName.canonical(dir.getCanonicalPath());
            this.addUndo(s);
            this.DirField.setText(s);
            this.Chosen.setText(FileName.chop(16, String.valueOf(this.DirField.getText()) + File.separatorChar + this.PatternField.getText(), 48));
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public void addUndo(String dir) {
        if (this.Undo.size() > 0 && ((String)this.Undo.elementAt(this.Undo.size() - 1)).equals(dir)) {
            return;
        }
        this.Undo.addElement(dir);
    }

    public String getUndo() {
        if (this.Undo.size() < 2) {
            return "";
        }
        String s = (String)this.Undo.elementAt(this.Undo.size() - 2);
        this.Undo.truncate(this.Undo.size() - 1);
        return s;
    }

    public void updateFiles() {
        if (this.FD != null) {
            return;
        }
        File dir = new File(this.DirField.getText());
        if (!dir.isDirectory()) {
            return;
        }
        this.CurrentDir = this.DirField.getText();
        if (this.PatternField.getText().equals("")) {
            this.PatternField.setText("*");
        }
        try {
            File f2;
            this.Files.clear();
            this.Dirs.clear();
            FileList l = new FileList(this.DirField.getText(), this.PatternField.getText(), false);
            l.setCase(Global.getParameter("filedialog.usecaps", false));
            l.search();
            l.sort();
            Enumeration e2 = l.files();
            while (e2.hasMoreElements()) {
                f2 = (File)e2.nextElement();
                this.Files.addElement(FileName.filename(f2.getCanonicalPath()));
            }
            this.Dirs.addElement("..");
            e2 = l.dirs();
            while (e2.hasMoreElements()) {
                f2 = (File)e2.nextElement();
                this.Dirs.addElement(FileName.filename(f2.getCanonicalPath()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Dirs.updateDisplay();
        this.Files.updateDisplay();
        this.Files.requestFocus();
    }

    public void setDirectory(String dir) {
        if (this.FD != null) {
            this.FD.setDirectory(dir);
        } else {
            this.DirField.setText(dir);
        }
    }

    public void setPattern(String pattern) {
        if (this.FD != null) {
            this.FD.setFilenameFilter(this);
            String s = pattern.replace(' ', ';');
            this.FD.setFile(s);
        } else {
            this.PatternField.setText(pattern);
        }
    }

    public void setFilePath(String file) {
        if (this.FD != null) {
            this.FD.setFile(file);
            return;
        }
        String dir = FileName.path(file);
        if (!dir.equals("")) {
            this.DirField.setText(dir);
            this.FileField.setText(FileName.filename(file));
        } else {
            this.FileField.setText(file);
        }
    }

    public boolean isAborted() {
        if (this.FD != null) {
            return this.FD.getFile() == null || this.FD.getFile().equals("");
        }
        return this.Aborted;
    }

    public String getFilePath() {
        if (this.FD != null) {
            if (this.FD.getFile() != null) {
                return String.valueOf(this.FD.getDirectory()) + this.FD.getFile();
            }
            return "";
        }
        String file = this.FileField.getText();
        if (!FileName.path(file).equals("")) {
            return file;
        }
        return String.valueOf(this.CurrentDir) + File.separatorChar + this.FileField.getText();
    }

    public void update(boolean recent) {
        if (this.FD != null) {
            return;
        }
        this.loadHistories(recent);
        this.setFilePath(this.FileField.getText());
        if (this.updateDir()) {
            this.updateFiles();
        }
        this.Aborted = true;
    }

    public void update() {
        this.update(true);
    }

    public void setVisible(boolean flag) {
        if (this.FD != null) {
            this.FD.setVisible(flag);
        } else {
            super.setVisible(flag);
        }
    }

    public void center(Frame f2) {
        if (this.FD != null) {
            CloseDialog.center(f2, this.FD);
        } else {
            super.center(f2);
        }
    }

    public static void main(String[] args) {
        CloseFrame f2 = new CloseFrame(){

            public void doclose() {
                System.exit(0);
            }
        };
        f2.setSize(500, 500);
        f2.setLocation(400, 400);
        f2.setVisible(true);
        MyFileDialog d2 = new MyFileDialog((Frame)f2, "Title", "Save", false);
        d2.center(f2);
        d2.update();
        d2.setVisible(true);
    }

    public void focusGained(FocusEvent e2) {
        this.FileField.requestFocus();
    }

    public boolean accept(File dir, String file) {
        return true;
    }

    public void loadHistories(boolean recent) {
        if (this.FD != null) {
            return;
        }
        this.DirField.loadHistory("myfiledialog.dir.history" + this.DirAppend);
        this.DirHistory.update();
        if (recent) {
            this.setDirectory(this.DirHistory.getRecent());
        }
        if (this.updateDir()) {
            this.updateFiles();
        }
        this.PatternField.loadHistory("myfiledialog.pattern.history" + this.PatternAppend);
        this.FileField.loadHistory("myfiledialog.file.history" + this.FileAppend);
        this.FileHistory.update();
    }

    public void loadHistories() {
        this.loadHistories(true);
    }

    public void loadHistories(String dir, String pattern, String file) {
        this.setAppend(dir, pattern, file);
        this.loadHistories();
    }

    public void setAppend(String dir, String pattern, String file) {
        if (this.FD != null) {
            return;
        }
        this.DirAppend = !dir.equals("") ? "." + dir : ".default";
        this.PatternAppend = !pattern.equals("") ? "." + pattern : ".default";
        this.FileAppend = !file.equals("") ? "." + file : ".default";
    }

    public void itemStateChanged(ItemEvent e2) {
    }
}

