/*
 * Klasa HealthBar nie powinna nic wiedzieć
 * o klasach Actor oraz Level, w celu zapewnienia
 * ich separacji
 */
function HealthBar(config){
	this.controller = config.controller;
    this.maxHealth = config.maxHealth;
    this.x = config.x;
    this.y = config.y;
    this.maxWidth = config.maxWidth;
    this.height = config.height;
    
    this.health = this.maxHealth;
}

HealthBar.prototype.setHealth = function(health){
    this.health = health;
};

HealthBar.prototype.draw = function(){
	var context = this.controller.view.context;
    context.beginPath();
    context.rect(this.x, this.y, this.maxWidth, this.height);
    context.fillStyle = "black";
    context.fill();
    context.closePath();
    
    context.beginPath();
    var width = this.maxWidth * this.health / this.maxHealth;
    context.rect(this.x, this.y, width, this.height);
    context.fillStyle = "red";
    context.fill();
    context.closePath();
};
