function getNewTotals() {
  var url = "pobierzAktualneDane.php";
  url = url + "?dummy=" + new Date().getTime();
  request.open("GET", url, true);
  request.onreadystatechange = updatePage;
  request.send(null);
}

function updatePage() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      // Pobieramy aktualne dane z odpowiedzi w formacie JSON
      var jsonData = eval('(' + request.responseText + ')');
      
      var totalBoards = jsonData.totals[0].boardsSold + 
                        jsonData.totals[1].boardsSold +
                        jsonData.totals[2].boardsSold + 
                        jsonData.totals[3].boardsSold;
      var totalBoots = jsonData.totals[0].bootsSold + 
                       jsonData.totals[1].bootsSold +
                       jsonData.totals[2].bootsSold + 
                       jsonData.totals[3].bootsSold;
      var totalBindings = jsonData.totals[0].bindingsSold + 
                          jsonData.totals[1].bindingsSold +
                          jsonData.totals[2].bindingsSold + 
                          jsonData.totals[3].bindingsSold;

      // Wywietlenie nowych wartoci na stronie
      var boardsSoldEl = document.getElementById("deski-sprzedane");
      var bootsSoldEl = document.getElementById("buty-sprzedane");
      var bindingsSoldEl = document.getElementById("wiazania-sprzedane");
      var cashEl = document.getElementById("kasa");
      replaceText(boardsSoldEl, totalBoards);
      replaceText(bootsSoldEl, totalBoots);
      replaceText(bindingsSoldEl, totalBindings);

      // Okrelamy ile Kaka zarobia na deskach
      var boardsPriceEl = document.getElementById("deski-cena");
      var boardsPrice = getText(boardsPriceEl);
      var boardsCostEl = document.getElementById("deski-koszt");
      var boardsCost = getText(boardsCostEl);
      var cashPerBoard = boardsPrice - boardsCost;
      var cash = cashPerBoard * totalBoards;

      // Okrelamy ile Kaka zarobia na butach
      var bootsPriceEl = document.getElementById("buty-cena");
      var bootsPrice = getText(bootsPriceEl);
      var bootsCostEl = document.getElementById("buty-koszt");
      var bootsCost = getText(bootsCostEl);
      var cashPerBoot = bootsPrice - bootsCost;
      var cash = cash + (cashPerBoot * totalBoots);

      // Okrelamy ile Kaka zarobia na wizaniach
      var bindingsPriceEl = document.getElementById("wiazania-cena");
      var bindingsPrice = getText(bindingsPriceEl);
      var bindingsCostEl = document.getElementById("wiazania-koszt");
      var bindingsCost = getText(bindingsCostEl);
      var cashPerBinding = bindingsPrice - bindingsCost;
      var cash = cash + (cashPerBinding * totalBindings);

      // Aktualizujemy kwot wywietlon na stronie
      cash = Math.round(cash * 100) / 100;
      replaceText(cashEl, cash);
    } else {
      var message = request.getResponseHeader("Status");
      if ((message.length == null) || (message.length <= 0)) {
        alert("Bd! Status dania ma warto " + request.status);
      } else {
        alert(message);
      }
    }
  }
}
