package com.packtpub.hibernatesearch.startup;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Klasa powinna by opakowana w wtek i utworzona przez MasterNode Initializer... by monitorowa kolejk JMS oraz 
 * wykonywa aktualizacje indeksw zainicjowanie przez wzy podrzdne. Gdy nadchodzi wiadomo, instancja 
 * QueueController (dziedziczca po klasie Hibernate Search AbstractJMSHibernateSearchController) wykonuje operacje 
 * na Lucene.
 * 
 * W penym rodowisku JEE, mgby opakowa klas dziedziczc po AbstractJMSHibernateSearchController w bean sterowany  
 * wiadomociami lub  podobny mechanizm wbudowany w wybrany przez ciebie framework.  Uyte tutaj Runnable jest 
 * dobrym substytutem.
 */
public class QueueMonitor implements Runnable {
	
	Logger logger = LoggerFactory.getLogger(QueueMonitor.class);

	QueueController controller;
	
	QueueMonitor(QueueController controller) {
		this.controller = controller;
	}
	
	public void run() {
		try {
			ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
			Connection connection = connectionFactory.createConnection();
			connection.start();
			Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
			Queue queue = session.createQueue("DEMO");
			MessageConsumer consumer = session.createConsumer(queue);
			while(true) {
				Message message = consumer.receive(60000);
				if(message != null) {
					logger.info("QueueMonitor przetwarza wiadomo: " + message.toString());
					controller.onMessage(message);
				}
			}
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}

}
