package com.packtpub.hibernatesearch.rest;

import javax.ws.rs.ApplicationPath;

import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.json.JSONConfiguration;

/**
 * Klasa dziedziczy po "javax.ws.rs.core.Application". Rejestruje RESTowe usugi napisane w JAX-RS.
 * Nasza aplikacja ma tylko jedn usug sieciow, patrz klasa "AppResource".
 * 
 * Adnotacja @ApplicationPath deklaruje ciek, pod ktr s dostpne usugi.
 */
@ApplicationPath("/rest")
public class RestfulApplication extends PackagesResourceConfig {

	public RestfulApplication() {
		// Ta paczka Javy bdzie automatycznie przeszukiwana w celu odnalezienia usug JAX-RS do zarejestrowania.
		super("com.packtpub.hibernatesearch.rest");
		
		// Jersey jest implementacj JAX-RS uyt w tej aplikacji.  Jersey udostpnia parser
		// Jackson konwertujcy obiekty do formatu JSON.
		getFeatures().put(JSONConfiguration.FEATURE_POJO_MAPPING, Boolean.TRUE);
	}
	
}
