package com.packtpub.hibernatesearch.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Restrictions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.packtpub.hibernatesearch.domain.App;

/**
 * RESTowa usuga zaimplementowana w JAX-RS. Pobiera encj App na podstawie jej ID.  Dziki niej 
 * servlet wyszukujcy moe uy zapyta w oparciu o projekcje by pobrac potrzebne dane z Lucene.
 * Baza danych jest odpytywana wycznie gdy uytkownik nacinie przycisk "Szczegy".  Naciskajc 
 * przycisk uytkownik wywouje AJAXowe danie do tej usugi. Wynikiem jest encja przesana w formacie
 * JSON.
 * 
 * Klasa "RestfulApplication" rejestruje usug i udostpnia j uytkownikom.
 * 
 * Adnotacja @Path definiuje URL, ktry bdzie obsugiwany przez usug. W poczeniu z podstawow ciek
 * zdefiniowan w "RestfulApplication" pena cieka bdzie wyglda np. tak http://localhost:8080/rest/appById/1. 
 * 
 * Adnotacja @Produces instruuje JAX-RS by skonwertowa wynik do formatu JSON.
 */
@Path("/appById/{appId}")
@Produces(MediaType.APPLICATION_JSON)
public class AppResource {
	
	Logger logger = LoggerFactory.getLogger(AppResource.class);

	/**
	 * Adnotacja @GET powoduje, e ta metoda jest wywoywana zawsze, gdy danie HTTP GET przyjdzie pod 
	 * zarejestrowany URL. 
	 */
	@GET
	public App getAppData( @PathParam("appId") Long appId ) {
		// Zainicjalizuj Hibernate
		Configuration configuration = new Configuration();
		configuration.configure();
		ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(configuration.getProperties()).buildServiceRegistry();
		SessionFactory sessionFactory = configuration.buildSessionFactory(serviceRegistry);
		Session session = sessionFactory.openSession();
		session.beginTransaction();
		
		// Pobierz encj App na podstawie przesanego ID, uywajc zachannego pobierania. Konwersja do JSONa odbdzie 
		// si po zamkniciu sesji Hibernate... gdybymy uyli leniwego pobierania, konwerter JSONa nie zakoczyby operacji 
		// pomylnie po napotkaniu powizanych obiektw.
		Criteria criteria = session.createCriteria(App.class);
		criteria.add( Restrictions.eq("id", appId) );
		criteria.setFetchMode("supportedDevices", FetchMode.SELECT);
		criteria.setFetchMode("customerReviews", FetchMode.SELECT);
		App app = (App) criteria.uniqueResult();
		
		// Czyszczenie Hibernate
		session.getTransaction().commit();
		session.clear();
		session.close();
		sessionFactory.close();
		
		return app;
	}
	
}
