package com.packtpub.hibernatesearch.domain.test;

import java.util.Scanner;

import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.junit.Test;

/**
 * W tej klasie inicjalizujemy dwuwzowy klaster oparty o serwery Jetty. Kady z nich aduje zawarto projektu. 
 * Jest alternatyw dla jednowzowego pluginu Jetty uywanego w poprzednich rozdziaach.
 * 
 * Metoda "testCluster()" jest testem JUnit 4. W zwizku z tym Maven wywoa j automatycznie po wywoaniu komendy 
 * "clean compile war:exploded test".
 * 
 * Wzy nadrzdne i podrzdne uywaj osobnych deskryptorw ("web.xml" and "web-slave.xml", respectively).
 * Kady z deskryptorw deklaruje listener kontekstu servletu odpowiedniego typu (tj. MasterNodeInitializer lub 
 * SlaveNodeInitializer)... ktry buduje fabryk sesji Hibernate uywajc wasnego pliku konfiguracyjnego
 * (tj. "hibernate.cfg.xml" lub "hibernate-slave.cfg.xml").
 * 
 * W zalenoci od frameworka, ktrego uywasz (tj. Spring, JEE, itp), moesz uy rozmaitych technik wstrzykiwania zalenoci
 * lub innych technik do konfigurowania wzw.  Ujmujc w skrcie  "hibernate.cfg.xml" (lub "persistence.xml" dla JPA) 
 * ustawia wane parametry istotne dla Hibernate Search.
 */
public class ClusterTest {

	@Test
	public void testCluster() throws Exception {
		
		String projectBaseDirectory = System.getProperty("user.dir");
		
		//
		// Utwrz wze nadrzdny
		//
		Server masterServer = new Server(8080);

		WebAppContext masterContext = new WebAppContext();
		masterContext.setDescriptor(projectBaseDirectory + "/target/bazar/WEB-INF/web.xml");
		masterContext.setResourceBase(projectBaseDirectory + "/target/bazar");
		masterContext.setContextPath("/");
		masterContext.setConfigurations(
				new Configuration[] { 
						new WebInfConfiguration(),
						new WebXmlConfiguration(),
						new MetaInfConfiguration(), 
						new FragmentConfiguration(),
						new EnvConfiguration(),
						new PlusConfiguration(),
						new AnnotationConfiguration(), 
						new JettyWebXmlConfiguration(),
						new TagLibConfiguration()
				}
		);
		masterContext.setParentLoaderPriority(true);

		masterServer.setHandler(masterContext);
		masterServer.start();
		//masterServer.join();

		//
		// Utwrz wze podrzdny
		//
		Server slaveServer = new Server(8181);

		WebAppContext slaveContext = new WebAppContext();
		slaveContext.setDescriptor(projectBaseDirectory + "/target/bazar/WEB-INF/web-slave.xml");
		slaveContext.setResourceBase(projectBaseDirectory + "/target/bazar");
		slaveContext.setContextPath("/");
		slaveContext.setConfigurations(
				new Configuration[] { 
						new WebInfConfiguration(),
						new WebXmlConfiguration(),
						new MetaInfConfiguration(), 
						new FragmentConfiguration(),
						new EnvConfiguration(),
						new PlusConfiguration(),
						new AnnotationConfiguration(), 
						new JettyWebXmlConfiguration(),
						new TagLibConfiguration()
				}
		);
		slaveContext.setParentLoaderPriority(true);

		slaveServer.setHandler(slaveContext);
		slaveServer.start();
		//slaveServer.join();
		
		// Sprbuj zamkn serwer Jetty.  Ta metode nie zadziaa w rodowisku Eclipse ani innym w ktrym nie mona wczyta,  
		// parametrw ze standardowego wejcia.  Moesz rwnie zamkn proces mavena aby zakoczy prac serwera Jetty. 
		
		System.out.println("NACINIJ <ENTER> BY ZATRZYMA SERWERY (lub ubij proces mavena)...");
		Scanner scanner = new Scanner(System.in);
		String line = scanner.nextLine();
		System.out.println(line);
		scanner.close();
		masterServer.stop();
		slaveServer.stop();
		System.out.println("Serwery zatrzymane");
		
	}

}
