package com.packtpub.hibernatesearch.util;

import java.util.StringTokenizer;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.impl.CachingWrapperFilter;

/**
 * Klasa dostarcza logik filtrujc encje "App" na podstawie tego, czy encja Device znajduje si na ich licie 
 * "supportedDevices". Ta klasa fabryki jest powizana z encj App za porednictwem adnotacji
 * @FullTextFilterDef.
 */
public class DeviceFilterFactory {

	private String deviceName;
	
	/**
	 * Jeeli fabryka filtrw przyjmuje parametry (np. "deviceName"), albo nie wycza buforowania filtrw, ktre
	 * jest domylnie wczone, wtedy musi mie metod zawierajc adnotacj @Key, zwracajc obiekt typu 
	 * FilterKey. Ponisza metoda uywa klasy operujcej na paremetrze "deviceName" (patrz DeviceFilterKey).    
	 */
	@Key
	public FilterKey getKey() {
		DeviceFilterKey key = new DeviceFilterKey();
		key.setDeviceName(this.deviceName);
		return key;
	}
	
	/**
	 * Gdy adnotacja @FullTextFilterDef poczy fabryk z dan nazw a "FullTextQuery.enableFullTextFilter()" zostanie 
	 * wywoany z t nazw jako parametrem, ponisza metoda jest odpowiedzialna za zwrcenie filtru implementujcego logik filtrowania.
	 * Adnotacja @Factory wskazuje j jako odpowiedzialn za utworzenie filtru. 
	 */
	@Factory
	public Filter getFilter() {
		StringTokenizer tokenzier = new StringTokenizer(deviceName.toLowerCase());
		PhraseQuery query = new PhraseQuery();
		while(tokenzier.hasMoreTokens()) {
			// Standardowo wartoci pl miay zamienione wielkie litery na mae podczas indeksowania w Lucene. Pamitaj o  
			// przekonwertowaniu w ten sam sposb sw kluczowych.
			Term term = new Term("supportedDevices.name", tokenzier.nextToken().toLowerCase());
			query.add(term);
		}
		Filter filter = new QueryWrapperFilter(query);
		return new CachingWrapperFilter(filter);
	}
	
	public String getDeviceName() {
		return this.deviceName;
	}
	
	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName.toLowerCase();
	}
	
}
