<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<!--
Design by Free CSS Templates
http://www.freecsstemplates.org
Released for free under a Creative Commons Attribution 3.0 License

Name       : Unofficial Channels
Description: A two-column, fixed-width design with a bright color scheme.
Version    : 1.0
Released   : 20120723
-->
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta name="keywords" content="" />
		<meta name="description" content="" />
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<title>
			Bazar Aplikacji
		</title>

		<link type="text/css" href="css/custom-theme/jquery-ui-1.8.24.custom.css" rel="stylesheet" />
		<link href="http://fonts.googleapis.com/css?family=Arvo" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" type="text/css" href="style.css" />

		<script type="text/javascript" src="js/jquery-1.8.2.min.js"></script>
		<script type="text/javascript" src="js/jquery-ui-1.8.24.custom.min.js"></script>
		<script language="JavaScript">

			// JavaScript wykonywany po załadowaniu strony
			$(function() {

				// Ustaw aktywny kursor na okienku wyszukiwania po załadowaniu strony
				$("#searchString").focus();

			});		
			
			// Gdy zostanie wciśnięty przycisk "Szukaj", upewnij się że pole nie jest puste i wyślij formularz
			function submitSearchForm() {
				var searchString = $("#searchString").val();
				if(searchString == null || searchString.replace(/^\s+|\s+$/g, '') == "") {
					alert("Musisz wprowadzić jakieś słowa kluczowe");
				} else {
					$("#searchForm").submit();
				}
			}
			
			// Kiedy użytkownik wybierze nowy sposób sortowania, ponownie wykonaj operację wyszukiwania wg nowych kryteriów
			function submitSortedSearch() {
				$("#sortedSearchForm").submit();
			}

			// Gdy użytkownik kliknie przycisk "Szczegóły" dla danej aplikacji wywołaj RESTową usługę by pobrać wszystkie informacje 
			// dotyczące tej aplikacji (włącznie ze wspieranymi urządzeniami i opiniami użytkowników) i wyświetl je w okienku.
			function showAppDetails(appId) {
				
				// Wywołaj usługę RESTową przekazując jej ID aplikacji
				var request = $.ajax({
					url: "rest/appById/" + appId,
					dataType: "json",
					
					// Wyświetl okno z wynikami
					success: function(app) {
						
						// Zaktualizuj sekcje okna danymi pochodzącymi z RESTowej usługi
						$("#appDetailName").html(app.name);
						$("#appDetailPrice").html("$" + app.price);
						$("#appDetailDescription").html(app.description);
						$("#appDetailImg").attr("src", "images/apps/" + app.image);
						$("#appDetailInstallButton").attr("onclick", "installApp(" + app.price + ");");
						
						var supportedDevicesHTML = "";
						for(var deviceIndex = 0; deviceIndex < app.supportedDevices.length; deviceIndex++) {
							var device = app.supportedDevices[deviceIndex];
							supportedDevicesHTML += device.manufacturer + " " + device.name;
							if(deviceIndex + 1 < app.supportedDevices.length) {
								supportedDevicesHTML += ", ";
							}
						}
						$("#appDetailSupportedDevices").html(supportedDevicesHTML);
						
						var customerReviewsHTML = "";
						for(var reviewIndex = 0; reviewIndex < app.customerReviews.length; reviewIndex++) {
							var customerReview = app.customerReviews[reviewIndex];
							customerReviewsHTML += "<b>" + customerReview.stars + " na 5 gwiazdek</b> (Użytkownik: <i>" + customerReview.username + "</i>)<br/>" + customerReview.comments + "<br/><br/>";
						}
						$("#appDetailCustomerReviews").html(customerReviewsHTML);
						
						$("#appDetail").dialog({
							width: 650,
							modal: true
						});
					},
					
					fail: function(jqXHR, textStatus) {
						alert( "Nie udało się pobrać danych: " + textStatus );
					}
				});
			}
			
			// Kiedy zostanie kliknięty przycisk "Instaluj", wyświetl komunikat, że aplikacja została kupiona				
			function installApp(price) {
				alert("Dziękujemy za udawanie, że instalujesz tę udawaną aplikację!\nUdajmy, że " + price.toFixed(2) + "PLN zostało pobrane z Twojego udawanego konta.");
			}
		</script>
	</head>
	<body>
		<div id="bg1"></div>
		<div id="bg2"></div>
		<div id="outer">
			<div id="header">
				<div id="logo">
					<h1><a href="index.html"><i>Bazar</i> Aplikacji</a></h1>
				</div>
				<form id="searchForm" action="search" method="post">
					<div id="search">
						<div>
							<!-- Udostępnij filtrowanie aplikacji na podstawie wspieranych urządzeń. Jeżeli parametr jest już ustawiony wybierz go jako wartość początkową. -->
							<label for="selectedDevice">Szukaj wg urządzenia:</label>
							<select id="selectedDevice" name="selectedDevice">
								<option value="all" ${selectedDevice == 'all' ? 'selected="selected"' : ''}>Wszystkie urządzenia</option>
								<option value="xPhone" ${selectedDevice == 'xPhone' ? 'selected="selected"' : ''}>Orange xPhone</option>
								<option value="xTablet" ${selectedDevice == 'xTablet' ? 'selected="selected"' : ''}>Orange xTablet</option>
								<option value="Solar System Phone" ${selectedDevice == 'Solar System Phone' ? 'selected="selected"' : ''}>Song-Sung Solar System Phone</option>
								<option value="Flame Book Reader" ${selectedDevice == 'Flame Book Reader' ? 'selected="selected"' : ''}>Jungle Flame Book Reader</option>
								<option value="Pecet" ${selectedDevice == 'Pecet' ? 'selected="selected"' : ''}>Pecet</option>
							</select>
							<input class="text" id="searchString" name="searchString" size="32" maxlength="64" value='${fn:replace(searchString, "\"", "&quot;")}' />
							<img src="images/search.png" style="margin: -13px;" onclick="submitSearchForm()"/>
						</div>
					</div>
				</form>
			</div>
			<div id="banner">
				<div class="captions">
					<h2><i>Największe</i>&nbsp;&nbsp;źródło aplikacji, niekoniecznie ukończonych</h2>
				</div>
				<img src="images/banner.jpg" alt="" height="150" width="1180"/>
			</div>
			<div id="main">
				<div id="sidebar">
					<div class="box">
						<!-- 
							Dynamicznie zbuduj listę kategorii i liczbę wyszukanych elementów w danej kategorii. Każda kategoria 
							powinna być linkiem do tej strony zawierającym wszystkie dotychczasowe parametry oraz dodającym nowy
							parametr - category.
						-->
						<h3>Kategorie</h3>
							<ul>
								<c:forEach items="${categories}" var="category" varStatus="loop">
								<li ${loop.index == 0 ? 'class="first"' : ''}>
									<c:if test="${selectedCategory == category.key}"><b></c:if>
									<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="selectedDevice" value="${selectedDevice}"/>
										<c:param name="selectedCategory" value="${category.key}"/>
										<c:param name="selectedPriceRange" value="${selectedPriceRange}"/>
										<c:param name="sortField" value="${sortField}"/>
										</c:url>'>${category.key}</a> (${category.value})
									<c:if test="${selectedCategory == category.key}"></b></c:if>
								</li>								
								</c:forEach>
								<!-- Kategoria "wszystkie" kasuje sekcję category pozostawiając resztę parametrów nietkniętych. -->
								<li>
									<c:if test="${selectedCategory == 'wszystkie'}"><b></c:if>								
									<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="selectedDevice" value="${selectedDevice}"/>
										<c:param name="selectedPriceRange" value="${selectedPriceRange}"/>
										<c:param name="sortField" value="${sortField}"/>
										</c:url>'>wszystkie</a> 
									<c:if test="${selectedCategory == 'wszystkie'}"></b></c:if>								
								</li>								
							</ul>
						<!-- 
							Dynamicznie zbuduj listę zakresów cen dla bieżących wyników.  Każdy zakres cen powinien być linkiem 
							do tej strony, z parametrami odtwarzającymi bieżący stan oraz nowym parametrem priceRange.
						-->
						<h3>Zakres cen</h3>
							<ul>
								<c:forEach items="${priceRanges}" var="priceRange" varStatus="loop">
								<c:set var="readablePriceRange" scope="request"><c:if test="${priceRange.key == '[, 1.0)'}">poniżej 1 PLN</c:if><c:if test="${priceRange.key == '[1.0, 5.0]'}">1 PLN - 5 PLN</c:if><c:if test="${priceRange.key == '(5.0, ]'}">powyżej 5 PLN</c:if></c:set>
								<li ${loop.index == 0 ? 'class="first"' : ''}>
									<c:if test="${selectedPriceRange == priceRange.key}"><b></c:if>
									<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="selectedDevice" value="${selectedDevice}"/>
										<c:param name="selectedCategory" value="${selectedCategory}"/>
										<c:param name="selectedPriceRange" value="${priceRange.key}"/>
										<c:param name="sortField" value="${sortField}"/>
										</c:url>'>${readablePriceRange}</a>
									<c:if test="${selectedPriceRange == priceRange.key}"></b></c:if>
								</li>								
								</c:forEach>
								<!-- Sekcja "wszystkie ceny" kasuje wybrany zakres cen, zachowując pozostałe parametry. -->
								<li>
									<c:if test="${selectedPriceRange == 'wszystkie ceny'}"><b></c:if>
									<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="selectedDevice" value="${selectedDevice}"/>
										<c:param name="selectedCategory" value="${selectedCategory}"/>
										<c:param name="sortField" value="${sortField}"/>
										</c:url>'>wszystkie ceny</a>
									<c:if test="${selectedPriceRange == 'wszystkie ceny'}"></b></c:if>
								</li>								
							</ul>
					</div>
				</div>
				<div id="content">
					<div class="box">
						<table>
							<tr>
								<td valign="top"><h2>Wyniki wyszukiwania</h2></td>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
								<td valign="top">
								
									<!-- 
										Rozwijane menu <select> prezentujące dostępne opcje sortowania, jako domyśna wartość jest ustawiona aktualnie wybrana opcja.
										W razie zmiany opcji sortowania zostanie wykonana kolejna operacja wyszukiwania... wszystkie parametry zostaną zachowane.
									-->
									<form id="sortedSearchForm" action="search" method="post">
										<label for="sortField">Sortuj wg:</label>
										<select id="sortField" name="sortField" onchange="submitSortedSearch()">
											<option value="relevance" ${sortField == 'relevance' ? 'selected="selected"' : ''}>Ważności</option>
											<option value="name" ${sortField == 'name' ? 'selected="selected"' : ''}>Nazwy (A-Z)</option>
											<option value="name-reverse" ${sortField == 'name-reverse' ? 'selected="selected"' : ''}>Nazwy (Z-A)</option>
										</select>
										<input type="hidden" name="searchString" value='${fn:replace(searchString, "\"", "&quot;")}' />							
										<input type="hidden" name="selectedDevice" value="${selectedDevice}" />							
										<c:if test="${selectedCategory != null}"><input type="hidden" name="selectedCategory" value="${selectedCategory}" /></c:if>							
										<c:if test="${selectedPriceRange != null}"><input type="hidden" name="selectedPriceRange" value="${selectedPriceRange}" /></c:if>							
									</form>
								</td>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
								<td valign="top">
								
									<!-- 
										Stronicowanie. Jeżeli wynik wyszukiwania ma więcej niż 5 elementów, jest podzielony na strony. Kontroler przesyła do widoku tylko 
										5 wyników.  Poniższy kod prezentuje łączną liczbę wyników i gdzie znajdują się aktualnie wyświetlane wyniki. 
										Strony pod linkami "Poprzednie" i "Następne" prezentują poprzednie lub kolejne pięć wyników. 
									-->
									Wyniki ${firstResult+1}-${firstResult+5 < resultSize ? firstResult+5 : resultSize} z ${resultSize}
									&nbsp;&nbsp;&nbsp;
									<c:if test="${firstResult > 0}">
										(<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="selectedDevice" value="${selectedDevice}"/>
										<c:if test="${selectedCategory != null}"><c:param name="selectedCategory" value="${selectedCategory}"/></c:if>
										<c:param name="sortField" value="${sortField}"/>
										<c:param name="firstResult" value="${firstResult-5}"/>
										</c:url>'>Poprzednie</a>)
									</c:if>
									<c:if test="${firstResult+5 < resultSize}">
										(<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="selectedDevice" value="${selectedDevice}"/>
										<c:if test="${selectedCategory != null}"><c:param name="selectedCategory" value="${selectedCategory}"/></c:if>
										<c:param name="sortField" value="${sortField}"/>
										<c:param name="firstResult" value="${firstResult+5}"/>
										</c:url>'>Następne</a>)
									</c:if>
								</td>
							</tr>
						</table>
						
						<!-- Iteruj przez wyniki wyszukiwania umieszczone w żądaniu przez servlet, wyświetl każdy wynik w nowym wierszu. -->
						<table style="width: 100%; margin-left: auto; margin-right: auto;">
						<c:forEach items="${apps}" var="app" varStatus="loop">
						<tr>
							<td style="width: 25%; text-align: center; vertical-align: middle;" rowspan="2"><img src="images/apps/${app.image}"/></td>
							<td style="height: 1em; width: 75%; text-align: left; vertical-align: bottom; border-bottom: thin dotted black;">
								<b>${app.name}</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
								<input type="button" id="appDetailButton_${loop.index}" value="Szczegóły" onclick="showAppDetails(${app.id})" />
							</td>							
						</tr>
						<tr>
							<td style="text-align: left; vertical-align: top; padding-bottom: 30px;">${app.description}</td>
						</tr>
						</c:forEach>
						</table>
						
						<!-- 
							Pop-up prezentujący szczegółowe dane aplikacji.  Element <div> jest ukrywany podczas zdarzenia
							on page load, ale jest używany do zbudowania dialogu jQuery UI gdy zostanie kliknięty przycisk "Szczegóły".
						-->
						<div style="font-size:10px; display:none;">
							<div id="appDetail" title="Szczegóły">
								<img id="appDetailImg" src="" style="float:left; margin:10px;" />
								<b><span id="appDetailName"></span></b>&nbsp;&nbsp;&nbsp;&nbsp;<span id="appDetailPrice"></span>&nbsp;&nbsp;&nbsp;&nbsp;
								<input id="appDetailInstallButton" type="button" value="Instaluj" /><hr/>
								<br/><span id="appDetailDescription"></span><br/><br/><hr/>
								Wspierane urządzenia: <span id="appDetailSupportedDevices"></span>
								<hr/><br/>
								Komentarze użytkowników: <br/><br/><span id="appDetailCustomerReviews"></span><br/><br/>
							</div>
						</div>
						
					</div><br class="clear" />
				</div><br class="clear" />
			</div>
		</div>
		<div id="copyright">
			Ta aplikacja korzysta z plików HTML/CSS ze strony <a href="http://www.freecsstemplates.org/">freecsstemplates.org</a>, 
			oraz zdjęć z <a href="http://fotogrph.com/">Fotogrph</a>, obu dostępnych na licencji 
			<a href="http://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution license</a>.
		</div>
	</body>
</html>
