package com.packtpub.hibernatesearch.util;

import org.hibernate.search.filter.FilterKey;

/**
 * Zaimplementowany przez nas FilterKey uywany przez klas DeviceFilterFactory by rozrni nazwy aplikacji. Implementacje 
 * FilterKey musz implementowa "equals()" oraz "hashCode()". 
 */
public class DeviceFilterKey extends FilterKey {

	private String deviceName;
	
	@Override
	public boolean equals(Object otherKey) {
		if(this.deviceName == null || !(otherKey instanceof DeviceFilterKey)) {
			return false;
		}
		DeviceFilterKey otherDeviceFilterKey = (DeviceFilterKey) otherKey;
		return otherDeviceFilterKey.deviceName != null && this.deviceName.equals(otherDeviceFilterKey.deviceName);
	}

	@Override
	public int hashCode() {
		if(this.deviceName == null) {
			return 0;
		}
		return this.deviceName.hashCode();
	}

	public String getDeviceName() {
		return deviceName;
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}

}
