package com.packtpub.hibernatesearch.util;

import java.util.Arrays;
import java.util.HashSet;

import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.packtpub.hibernatesearch.domain.App;
import com.packtpub.hibernatesearch.domain.CustomerReview;
import com.packtpub.hibernatesearch.domain.Device;

/**
 * Klasa pomocniczna uywana do zapenienia wbudowanej bazy H2 testowymi danymi podczas startu aplikacji. Dziki adnotacji @WebListener 
 * dostpnej w Servletach 3.0, metoda "contextInitialized" bdzie automatycznie wywoana podczas startu kontenera servletw.
 */
@WebListener
public class StartupDataLoader implements javax.servlet.ServletContextListener {
	
	Logger logger = LoggerFactory.getLogger(StartupDataLoader.class);

	/**
	 * Nie powinna by uywana bezporednio. Uyj openSession().
	 */
	private static SessionFactory sessionFactory;
	
	/**
	 * Konstruowanie nowej SessionFactory Hibernate dla kadego dania HTTP powodowaoby problemy wydajnociowe. Poniewa
	 * servlety Javy musz by wspbiene, nie moemy zadeklarowa by SessionFactory bya publiczn statyczn zmienn.
	 * Ta metoda udostpnia wspbieny dostp do SessionFactory, dziki czemu metoda zapeniajca baz danych przykadowymi danymi 
	 * i servlet wyszukujcy mog otwiera poczenia do bazy danych bardziej wydajnie. 
	 * 
	 * @return Session
	 */
	public static synchronized Session openSession() {
		if(sessionFactory == null) {
			Configuration configuration = new Configuration();
			configuration.configure();
			ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(configuration.getProperties()).buildServiceRegistry();
			sessionFactory = configuration.buildSessionFactory(serviceRegistry);			
		}
		return sessionFactory.openSession();
	}

	/**
	 * Ta metoda jest uruchamiana automatycznie gdy uruchomiony zostaje mechanizm servletw.
	 */
	public void contextInitialized(ServletContextEvent event) {

		//
		// Utwrz sesj Hibernate i rozpocznij now transakcj bazodanow.
		//
		Session session = openSession();
		session.beginTransaction();
		
		//
		// Utwrz 5 urzdze
		//
		Device xPhone = new Device("Orange", "xPhone", null);
		Device xTablet = new Device("Orange", "xTablet", null);
		Device solarSystem = new Device("Song-Sung", "Solar System Phone", null);
		Device flame = new Device("Jungle", "Flame Book Reader", null);
		Device pc = new Device(null, "Pecet", null);
		
		//
		// Utwrz i zapisz 12 testowych aplikacji
		//
		App theCloud = new App(
				"Chmura!", 
				"cloud.jpg", 
				"Aplikacja Chmura! jest miejscem, w ktrym dziej si cuda. Firmy dziaaj w chmurach. Programici nie potrzebuj administratorw, jedzenia i picia w zasadzie te nie. Moesz oglda telewizj na tablecie, siedza na kanapie; nie musisz w ogle patrze na telewizor! cignij aplikacj Chmura! z chmury i dowiadcz tej cudownej potgi!",
				"Biznes",
				7.99f);
		theCloud.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, xTablet })) );
		CustomerReview theCloudReview1 = new CustomerReview("fanboy1984", 5, "Ta aplikacja sprawia, e mj xPhone jest jeszcze bardziej stylowy i trendy!");
		CustomerReview theCloudReview2 = new CustomerReview("anty.hipster", 1, "Nie rozumiem o co chodzi z t 'Chmur'.  Dla mnie to raczej marketingowy bekot...");
		theCloud.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { theCloudReview1, theCloudReview2 })) );
		session.save(theCloud);
		logger.info("Zapisuj " + theCloud.getName());

		App salesCloser = new App(
				"Zamykacz transakcji", 
				"pointing.jpg", 
				"Wysokoenergetyczna aplikacja wspomagajca energicznych sprzedawcw. Twrz pene energii kalendarze i arkusze. Gdy jeste w miecie i energicznie nawizujesz kontakty, chcesz prezentowa swe naenergetyzowane foldery, pokazujce, e te masz w sobie mnstwo energii.",
				"Biznes",
				5.99f);
		salesCloser.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, solarSystem })) );
		CustomerReview salesCloserReview = new CustomerReview("GdzieJestKasa", 5, "wietna aplikacja!  Jeeli uywae kiedy 'Sales Commandera 2000', szybko poapiesz si w tym interfejsie.");
		salesCloser.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { salesCloserReview })) );
		session.save(salesCloser);
		logger.info("Zapisuj " + salesCloser.getName());

		App football = new App(
				"Midzynarodowy turniej pikarski", 
				"ball.jpg", 
				"Ta maa aplikacja oferuje Ci rado gry w pik non, poza tym, e grasz na ekranie dotykowym, zamiast biega i kopa albo w ogle si rusza. Poza tym zapewnia podobne wraenia.",
				"Gry",
				1.99f);
		football.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xTablet, flame })) );
		CustomerReview footballReview = new CustomerReview("PrawdziwyAmerykanin", 2, "Podpucha... To nie jest amerykaski futbol!");
		football.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { footballReview })) );
		session.save(football);
		logger.info("Zapisuj " + football.getName());
		
		App crystal = new App(
				"Kolejna gra o krysztaach", 
				"brilliant.jpg", 
				"Olniewajca aplikacja, w ktrej czysz krysztay tego samego koloru, by znikny. Co jak Tetris. W sumie przypomina tuzin innych gier, w ktrych czysz krysztay tego samego koloru.",
				"Gry",
				0.99f);
		crystal.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { flame, pc })) );
		CustomerReview crystalReview = new CustomerReview("KolejnyGracz", 3, "czemu ta gra jest dostpna tylko na dwch urzdzeniach?  Z tuzin klonw tej gry jest dostpny dla wszystkich urzdze.  Powinnicie deaktywowa t aplikacj do czasu, gdy wszystkie urzdzenia bd wspierane...");
		crystal.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { crystalReview })) );
		crystal.setActive(false);
		session.save(crystal);
		logger.info("Zapisuj " + crystal.getName());
		
		App pencilSharpener = new App(
				"Temperwka", 
				"pencil.jpg", 
				"Ostrz owki, wkadajc je do gniazda Bluetooth i wciskajc przycisk. Ta aplikacja wyciska ze sprztu wszystko!",
				"Biznes",
				2.99f);
		pencilSharpener.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, solarSystem })) );
		CustomerReview pencilSharpenerReview1 = new CustomerReview("brakuje.cyferek", 1, "Ta aplikacja jest niebezpieczna!  Myl o pozwie.");
		CustomerReview pencilSharpenerReview2 = new CustomerReview("Prawnik", 5, "@brakuje.cyferek  Napisz do mnie.  Pogadamy...");
		pencilSharpener.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { pencilSharpenerReview1, pencilSharpenerReview2 })) );
		session.save(pencilSharpener);
		logger.info("Zapisuj " + pencilSharpener.getName());
		
		App staplerTracker = new App(
				"Namierzacz zszywaczy", 
				"stapler.jpg", 
				"Czy kto cigle poycza sobie Twj zszywacz? To typowy problem w biurach. Nasza aplikacja biznesowa sprawi, e ju nigdy nie bdziesz musia si zastanawia, gdzie podziewa si Twj zszywacz.",
				"Biznes",
				0.99f);
		staplerTracker.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { pc })) );
		CustomerReview staplerTrackerReview = new CustomerReview("mike.bolton", 3, "'PC LOAD LETTER'?  O co w ogle chodzi?!?");
		staplerTracker.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { staplerTrackerReview })) );
		session.save(staplerTracker);
		logger.info("Zapisuj " + staplerTracker.getName());
		
		App frustratedFlamingos = new App(
				"Sfrustrowane Flamingi", 
				"flamingo.jpg", 
				"Maa aplikacja pozwalajca na ciskanie wielkimi ptakami na lewo i prawo bez powodu. Chyba nie zastanawiasz si czemu s sfrustrowane?",
				"Gry",
				0.99f);
		frustratedFlamingos.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, xTablet, solarSystem, flame, pc })) );
		CustomerReview frustratedFlamingosReview = new CustomerReview("Procarz", 4, "LOL, uwielbiam katapulotwa flamingi w krowy! Troch mnie wkurza, e reklama troch zasania obszar gry.");
		frustratedFlamingos.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { frustratedFlamingosReview })) );
		session.save(frustratedFlamingos);
		logger.info("Zapisuj " + frustratedFlamingos.getName());
		
		App grype = new App(
				"Wideokonferencje Grype", 
				"laptop.jpg", 
				"Dzwo za darmo lokalnie i za granic, rwnie z transmisj obrazu, uywajc domowego poczenia internetowego i naszego produktu. W sumie nasz aplikacja zadziaa jeszcze lepiej jeli skorzystasz z poczenia internetowego Twojego pracodawcy!",
				"Internet",
				3.99f);
		grype.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, xTablet, solarSystem, pc })) );
		CustomerReview grypeReview = new CustomerReview("biurowy.luzak", 4, "Szkoda, e dodali obsug wideo do najnowszej wersji. Wczeniej nie musiaem si ubiera.");
		grype.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { grypeReview })) );
		session.save(grype);
		logger.info("Zapisuj " + grype.getName());
		
		App eReader = new App(
				"Czytnik e-bookw", 
				"book.jpg", 
				"Nasza aplikacja sprawi, e bdziesz mg czyta ksiki na komputerze albo na dowolnym urzdzeniu mobilnym.  Polecamy \"Hibernate Search by Example\".",
				"Media",
				1.99f);
		eReader.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, xTablet, solarSystem, flame, pc })) );
		CustomerReview eReaderReview = new CustomerReview("StevePerkins", 5, "Ksika 'Hibernate Search by Example' jest super!  Dziki za rekomendacje!");
		eReader.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { eReaderReview })) );
		session.save(eReader);
		logger.info("Zapisuj " + eReader.getName());
		
		App domeBrowser = new App(
				"Przegldarka pod kopu", 
				"orangeswirls.jpg", 
				"Ta cudowna aplikacja pozwala nam ledzi Twoj aktywno w Internecie. Moemy odgadn gdzie mieszkasz, co jade dzisiaj na niadanie, albo jakie s Twoje najwiksze sekrety. Aha, w aplikacj jest jeszcze wbudowana przegldarka stron WWW.",
				"Internet",
				0);
		domeBrowser.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { solarSystem, flame, pc })) );
		CustomerReview domeBrowserReview = new CustomerReview("oni.wiedza", 1, "Odinstalowaem t aplikacj.  Jeeli udao im si sfaszowa ldowanie na ksiycu, z pewnoci wykorzystaj histori mojej przegldarki przeciwko mnie.");
		domeBrowser.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { domeBrowserReview })) );
		session.save(domeBrowser);
		logger.info("Zapisuj " + domeBrowser.getName());
		
		App athenaRadio = new App(
				"Internetowe radio Atena", 
				"jamming.jpg", 
				"Suchaj swoich ulubionych piosenek w radiu internetowym! Kiedy polubisz jak piosenk, nasza aplikacja zagra Ci wicej podobnych piosenek. A przynajmniej zagra wicej piosenek ... eby by szczerym, czasem wcale nie s takie podobne  :(",
				"Media",
				3.99f);
		athenaRadio.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, xTablet, solarSystem, flame, pc })) );
		CustomerReview athenaRadioReview = new CustomerReview("lskinner", 5, "Chciaem'Free Bird', dostaem 'Free Bird'.  Czego chcie wicej?");
		athenaRadio.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { athenaRadioReview })) );
		session.save(athenaRadio);
		logger.info("Zapisuj " + athenaRadio.getName());
		
		App mapJourney = new App(
				"Mapa podry", 
				"compass.jpg", 
				"Potrzebujesz wskazwek, by dotrze do celu?  Nasza aplikacja GPS na pewno wygeneruje wystarczajco duo propozycji, by dotar do celu!  Prdzej czy pniej.",
				"Podre",
				0.99f);
		mapJourney.setSupportedDevices( new HashSet<Device>(Arrays.asList(new Device[] { xPhone, solarSystem, pc })) );
		CustomerReview mapJourneyReview = new CustomerReview("Zagubiony", 3, "Nic szczeglnego... ale cigle o niebo lepsze od map Orange.");
		mapJourney.setCustomerReviews( new HashSet<CustomerReview>(Arrays.asList(new CustomerReview[] { mapJourneyReview })) );
		session.save(mapJourney);
		logger.info("Zapisuj " + mapJourney.getName());
		
		//
		// Zamknij i wyczy sesj Hibernate
		//
		session.getTransaction().commit();
		session.close();
	} 

	/**
	 * Ta metoda jest wywoywana gdy mechanizm servletw jest wyczany. Zamyka Hibernate SessionFactory jeeli jeszcze jest otwarta.
	 */
	public void contextDestroyed(ServletContextEvent event) {
		if(!sessionFactory.isClosed()) {
			sessionFactory.close();
		}
	}

}
