<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<!--
Design by Free CSS Templates
http://www.freecsstemplates.org
Released for free under a Creative Commons Attribution 3.0 License

Name       : Unofficial Channels
Description: A two-column, fixed-width design with a bright color scheme.
Version    : 1.0
Released   : 20120723
-->
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta name="keywords" content="" />
		<meta name="description" content="" />
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<title>
			Bazar Aplikacji
		</title>

		<link type="text/css" href="css/custom-theme/jquery-ui-1.8.24.custom.css" rel="stylesheet" />
		<link href="http://fonts.googleapis.com/css?family=Arvo" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" type="text/css" href="style.css" />

		<script type="text/javascript" src="js/jquery-1.8.2.min.js"></script>
		<script type="text/javascript" src="js/jquery-ui-1.8.24.custom.min.js"></script>
		<script language="JavaScript">

			// Ustaw aktywny kursor na okienku wyszukiwania po załadowaniu strony
			$(function() {
				$("#searchString").focus();
			});		
			
			// Gdy zostanie wciśnięty przycisk "Szukaj", upewnij się że pole nie jest puste i wyślij formularz
			function submitSearchForm() {
				var searchString = $("#searchString").val();
				if(searchString == null || searchString.replace(/^\s+|\s+$/g, '') == "") {
					alert("Musisz wprowadzić jakieś słowa kluczowe");
				} else {
					$("#searchForm").submit();
				}
			}
			
			// Kiedy użytkownik wybierze nowy sposób sortowania, ponownie wykonaj operację wyszukiwania wg nowych kryteriów
			function submitSortedSearch() {
				$("#sortedSearchForm").submit();
			}

			// Kiedy zostanie kliknięty przycisk "Instaluj", wyświetl komunikat, że aplikacja została kupiona			
			function installApp(price) {
				alert("Dziękujemy za udawanie, że instalujesz tę udawaną aplikację!\nUdajmy, że " + price + "PLN zostało pobrane z Twojego udawanego konta.");
			}
		</script>
	</head>
	<body>
		<div id="bg1"></div>
		<div id="bg2"></div>
		<div id="outer">
			<div id="header">
				<div id="logo">
					<h1><a href="index.html"><i>Bazar</i> Aplikacji</a></h1>
				</div>
				<form id="searchForm" action="search" method="post">
					<div id="search">
						<div>
							<input class="text" id="searchString" name="searchString" size="32" maxlength="64" value='${fn:replace(searchString, "\"", "&quot;")}' />
							<img src="images/search.png" style="margin: -13px;" onclick="submitSearchForm()"/>
						</div>
					</div>
				</form>
			</div>
			<div id="banner">
				<div class="captions">
					<h2><i>Największe</i>&nbsp;&nbsp;źródło aplikacji, niekoniecznie ukończonych</h2>
				</div>
				<img src="images/banner.jpg" alt="" height="150" width="1180"/>
			</div>
			<div id="main">
				<div id="sidebar">
					<div class="box">
						<h3>Nadchodzące premiery</h3>
						<div class="dateList">
							<ul class="linkedList dateList">
								<li class="first">
									<span class="date">23 lipca</span> Sfrustrowane Flamingi
								</li>
								<li>
									<span class="date">28 lipca</span> Internetowe Radio Atena
								</li>
								<li>
									<span class="date">7 sierpnia</span> Przeglądarka pod kopułą
								</li>
								<li>
									<span class="date">9 sierpnia</span> Wideokonferencje Grype
								</li>
							</ul>
						</div>
					</div>
				</div>
				<div id="content">
					<div class="box">
						<table>
							<tr>
								<td valign="top"><h2>Wyniki wyszukiwania</h2></td>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
								<td valign="top">
								
									<!-- 
										Rozwijane menu <select> prezentujące dostępne opcje sortowania, jako domyśna wartość jest ustawiona aktualnie wybrana opcja.
										W razie zmiany opcji sortowania zostanie wykonana kolejna operacja wyszukiwania.
									-->
									
									<form id="sortedSearchForm" action="search" method="post">
										<label for="sortField">Sortuj wg:</label>
										<select id="sortField" name="sortField" onchange="submitSortedSearch()">
											<option value="relevance" ${sortField == 'relevance' ? 'selected="selected"' : ''}>Ważności</option>
											<option value="name" ${sortField == 'name' ? 'selected="selected"' : ''}>Nazwy (A-Z)</option>
											<option value="name-reverse" ${sortField == 'name-reverse' ? 'selected="selected"' : ''}>Nazwy (Z-A)</option>
										</select>
										<input type="hidden" name="searchString" value='${fn:replace(searchString, "\"", "&quot;")}' />							
									</form>
								</td>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
								<td valign="top">
								
									<!-- 
										Stronicowanie. Jeżeli wynik wyszukiwania ma więcej niż 5 elementów, jest podzielony na strony. Kontroler przesyła do widoku tylko 
										5 wyników.  Poniższy kod prezentuje łączną liczbę wyników i gdzie znajdują się aktualnie wyświetlane wyniki. 
										Strony pod linkami "Poprzednie" i "Następne" prezentują poprzednie lub kolejne pięć wyników. 
									-->
								
									Wyniki: ${firstResult+1}-${firstResult+5 < resultSize ? firstResult+5 : resultSize} z ${resultSize} 
									&nbsp;&nbsp;&nbsp;
									<c:if test="${firstResult > 0}">
										(<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="sortField" value="${sortField}"/>
										<c:param name="firstResult" value="${firstResult-5}"/>
										</c:url>'>Poprzednie</a>)
									</c:if>
									<c:if test="${firstResult+5 < resultSize}">
										(<a href='<c:url value="search">
										<c:param name="searchString" value="${searchString}"/>
										<c:param name="sortField" value="${sortField}"/>
										<c:param name="firstResult" value="${firstResult+5}"/>
										</c:url>'>Następne</a>)
									</c:if>
								</td>
							</tr>
						</table>
						
						<!-- Iteruj przez wyniki wyszukiwania umieszczone w żądaniu przez servlet, wyświetl każdy wynik w nowym wierszu. -->
						
						<table style="width: 100%; margin-left: auto; margin-right: auto;">
						<c:forEach items="${apps}" var="app" varStatus="loop">
						<tr>
							<td style="width: 25%; text-align: center; vertical-align: middle;" rowspan="2"><img src="images/apps/${app.image}"/></td>
							<td style="height: 1em; width: 75%; text-align: left; vertical-align: bottom; border-bottom: thin dotted black;">
								<b>${app.name}</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
								<input type="button" id="appDetailButton_${loop.index}" value="Szczegóły" />
							</td>							
						</tr>
						<tr>
							<td style="text-align: left; vertical-align: top; padding-bottom: 30px;">${app.description}</td>
						</tr>
						
						<!-- 
							Pop-up prezentujący szczegółowe dane aplikacji.  Element <div> jest ukrywany podczas zdarzenia
							on page load, ale jest używany do zbudowania dialogu jQuery UI gdy zostanie kliknięty przycisk "Szczegóły".
						-->
						<div style="font-size:10px; display:none;">
							<div id="appDetail_${loop.index}" title="Szczegóły">
								<img src="images/apps/${app.image}" style="float:left; margin:10px;" />
								<b>${app.name}</b>&nbsp;&nbsp;&nbsp;&nbsp;<input type="button" value="Instaluj" onclick="installApp(${app.price});" /><hr/>
								<br/>${app.description}<br/><br/><hr/>
								Wspierane urządzenia: 
								<c:forEach items="${app.supportedDevices}" var="device" varStatus="devicesLoop">
									${device.manufacturer} ${device.name}<c:if test="${not devicesLoop.last}">,</c:if>
								</c:forEach>
								<hr/><br/>
								Opinie klientów:<br/><br/>
								<c:forEach items="${app.customerReviews}" var="customerReview">
									<b>${customerReview.stars} na 5 gwiazdek</b> (Użytkownik: <i>${customerReview.username}</i>)<br/>
									${customerReview.comments}<br/><br/>
								</c:forEach>
							</div>
						</div>
						<script language="JavaScript">
							$(function() {
								$("#appDetailButton_${loop.index}").click(function() {
									$("#appDetail_${loop.index}").dialog({
										width: 650,
										modal: true
									});
								});
							});
						</script>
						
						</c:forEach>
						</table>
					</div><br class="clear" />
				</div><br class="clear" />
			</div>
		</div>
		<div id="copyright">
			Ta aplikacja korzysta z plików HTML/CSS ze strony <a href="http://www.freecsstemplates.org/">freecsstemplates.org</a>, 
			oraz zdjęć z <a href="http://fotogrph.com/">Fotogrph</a>, obu dostępnych na licencji 
			<a href="http://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution license</a>.
		</div>
	</body>
</html>
